/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateSMBFileShareInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSmbFileShareRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<CreateSmbFileShareRequest.Builder, CreateSmbFileShareRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSmbFileShareRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSmbFileShareRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateSmbFileShareRequest::kmsEncrypted)).setter(setter(Builder::kmsEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSmbFileShareRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSmbFileShareRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSmbFileShareRequest::locationARN)).setter(setter(Builder::locationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()).build();

    private static final SdkField<String> DEFAULT_STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSmbFileShareRequest::defaultStorageClass)).setter(setter(Builder::defaultStorageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultStorageClass").build())
            .build();

    private static final SdkField<String> OBJECT_ACL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSmbFileShareRequest::objectACLAsString)).setter(setter(Builder::objectACL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectACL").build()).build();

    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateSmbFileShareRequest::readOnly)).setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()).build();

    private static final SdkField<Boolean> GUESS_MIME_TYPE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateSmbFileShareRequest::guessMIMETypeEnabled)).setter(setter(Builder::guessMIMETypeEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuessMIMETypeEnabled").build())
            .build();

    private static final SdkField<Boolean> REQUESTER_PAYS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateSmbFileShareRequest::requesterPays)).setter(setter(Builder::requesterPays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPays").build()).build();

    private static final SdkField<Boolean> SMBACL_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateSmbFileShareRequest::smbaclEnabled)).setter(setter(Builder::smbaclEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBACLEnabled").build()).build();

    private static final SdkField<List<String>> ADMIN_USER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateSmbFileShareRequest::adminUserList))
            .setter(setter(Builder::adminUserList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminUserList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> VALID_USER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateSmbFileShareRequest::validUserList))
            .setter(setter(Builder::validUserList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUserList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INVALID_USER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateSmbFileShareRequest::invalidUserList))
            .setter(setter(Builder::invalidUserList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidUserList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUTHENTICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSmbFileShareRequest::authentication)).setter(setter(Builder::authentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateSmbFileShareRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            GATEWAY_ARN_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, ROLE_FIELD, LOCATION_ARN_FIELD, DEFAULT_STORAGE_CLASS_FIELD,
            OBJECT_ACL_FIELD, READ_ONLY_FIELD, GUESS_MIME_TYPE_ENABLED_FIELD, REQUESTER_PAYS_FIELD, SMBACL_ENABLED_FIELD,
            ADMIN_USER_LIST_FIELD, VALID_USER_LIST_FIELD, INVALID_USER_LIST_FIELD, AUTHENTICATION_FIELD, TAGS_FIELD));

    private final String clientToken;

    private final String gatewayARN;

    private final Boolean kmsEncrypted;

    private final String kmsKey;

    private final String role;

    private final String locationARN;

    private final String defaultStorageClass;

    private final String objectACL;

    private final Boolean readOnly;

    private final Boolean guessMIMETypeEnabled;

    private final Boolean requesterPays;

    private final Boolean smbaclEnabled;

    private final List<String> adminUserList;

    private final List<String> validUserList;

    private final List<String> invalidUserList;

    private final String authentication;

    private final List<Tag> tags;

    private CreateSmbFileShareRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.gatewayARN = builder.gatewayARN;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.role = builder.role;
        this.locationARN = builder.locationARN;
        this.defaultStorageClass = builder.defaultStorageClass;
        this.objectACL = builder.objectACL;
        this.readOnly = builder.readOnly;
        this.guessMIMETypeEnabled = builder.guessMIMETypeEnabled;
        this.requesterPays = builder.requesterPays;
        this.smbaclEnabled = builder.smbaclEnabled;
        this.adminUserList = builder.adminUserList;
        this.validUserList = builder.validUserList;
        this.invalidUserList = builder.invalidUserList;
        this.authentication = builder.authentication;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique string value that you supply that is used by file gateway to ensure idempotent file share creation.
     * </p>
     * 
     * @return A unique string value that you supply that is used by file gateway to ensure idempotent file share
     *         creation.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the file gateway on which you want to create a file share.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the file gateway on which you want to create a file share.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by Amazon
     * S3. Optional.
     * </p>
     * 
     * @return True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by
     *         Amazon S3. Optional.
     */
    public Boolean kmsEncrypted() {
        return kmsEncrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only
     * be set when KMSEncrypted is true. Optional.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value
     *         can only be set when KMSEncrypted is true. Optional.
     */
    public String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the
     * underlying storage.
     * </p>
     * 
     * @return The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses
     *         the underlying storage.
     */
    public String role() {
        return role;
    }

    /**
     * <p>
     * The ARN of the backed storage used for storing file data.
     * </p>
     * 
     * @return The ARN of the backed storage used for storing file data.
     */
    public String locationARN() {
        return locationARN;
    }

    /**
     * <p>
     * The default storage class for objects put into an Amazon S3 bucket by the file gateway. Possible values are
     * <code>S3_STANDARD</code>, <code>S3_STANDARD_IA</code>, or <code>S3_ONEZONE_IA</code>. If this field is not
     * populated, the default value <code>S3_STANDARD</code> is used. Optional.
     * </p>
     * 
     * @return The default storage class for objects put into an Amazon S3 bucket by the file gateway. Possible values
     *         are <code>S3_STANDARD</code>, <code>S3_STANDARD_IA</code>, or <code>S3_ONEZONE_IA</code>. If this field
     *         is not populated, the default value <code>S3_STANDARD</code> is used. Optional.
     */
    public String defaultStorageClass() {
        return defaultStorageClass;
    }

    /**
     * <p>
     * A value that sets the access control list permission for objects in the S3 bucket that a file gateway puts
     * objects into. The default value is "private".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectACL} will
     * return {@link ObjectACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectACLAsString}.
     * </p>
     * 
     * @return A value that sets the access control list permission for objects in the S3 bucket that a file gateway
     *         puts objects into. The default value is "private".
     * @see ObjectACL
     */
    public ObjectACL objectACL() {
        return ObjectACL.fromValue(objectACL);
    }

    /**
     * <p>
     * A value that sets the access control list permission for objects in the S3 bucket that a file gateway puts
     * objects into. The default value is "private".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectACL} will
     * return {@link ObjectACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectACLAsString}.
     * </p>
     * 
     * @return A value that sets the access control list permission for objects in the S3 bucket that a file gateway
     *         puts objects into. The default value is "private".
     * @see ObjectACL
     */
    public String objectACLAsString() {
        return objectACL;
    }

    /**
     * <p>
     * A value that sets the write status of a file share. This value is true if the write status is read-only, and
     * otherwise false.
     * </p>
     * 
     * @return A value that sets the write status of a file share. This value is true if the write status is read-only,
     *         and otherwise false.
     */
    public Boolean readOnly() {
        return readOnly;
    }

    /**
     * <p>
     * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to
     * true to enable MIME type guessing, and otherwise to false. The default value is true.
     * </p>
     * 
     * @return A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this
     *         value to true to enable MIME type guessing, and otherwise to false. The default value is true.
     */
    public Boolean guessMIMETypeEnabled() {
        return guessMIMETypeEnabled;
    }

    /**
     * <p>
     * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket.
     * If this value is set to true, the requester pays the costs. Otherwise the S3 bucket owner pays. However, the S3
     * bucket owner always pays the cost of storing data.
     * </p>
     * <note>
     * <p>
     * <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the
     * configuration on the file share is the same as the S3 bucket configuration.
     * </p>
     * </note>
     * 
     * @return A value that sets who pays the cost of the request and the cost associated with data download from the S3
     *         bucket. If this value is set to true, the requester pays the costs. Otherwise the S3 bucket owner pays.
     *         However, the S3 bucket owner always pays the cost of storing data.</p> <note>
     *         <p>
     *         <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure
     *         that the configuration on the file share is the same as the S3 bucket configuration.
     *         </p>
     */
    public Boolean requesterPays() {
        return requesterPays;
    }

    /**
     * <p>
     * Set this value to "true to enable ACL (access control list) on the SMB file share. Set it to "false" to map file
     * and directory permissions to the POSIX permissions.
     * </p>
     * <p>
     * For more information, see https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html in the Storage
     * Gateway User Guide.
     * </p>
     * 
     * @return Set this value to "true to enable ACL (access control list) on the SMB file share. Set it to "false" to
     *         map file and directory permissions to the POSIX permissions.</p>
     *         <p>
     *         For more information, see https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html in the
     *         Storage Gateway User Guide.
     */
    public Boolean smbaclEnabled() {
        return smbaclEnabled;
    }

    /**
     * <p>
     * A list of users in the Active Directory that will be granted administrator privileges on the file share. These
     * users can do all file operations as the super-user.
     * </p>
     * <important>
     * <p>
     * Use this option very carefully, because any user in this list can do anything they like on the file share,
     * regardless of file permissions.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of users in the Active Directory that will be granted administrator privileges on the file share.
     *         These users can do all file operations as the super-user. </p> <important>
     *         <p>
     *         Use this option very carefully, because any user in this list can do anything they like on the file
     *         share, regardless of file permissions.
     *         </p>
     */
    public List<String> adminUserList() {
        return adminUserList;
    }

    /**
     * <p>
     * A list of users or groups in the Active Directory that are allowed to access the file share. A group must be
     * prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is set to
     * <code>ActiveDirectory</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of users or groups in the Active Directory that are allowed to access the file share. A group must
     *         be prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is
     *         set to <code>ActiveDirectory</code>.
     */
    public List<String> validUserList() {
        return validUserList;
    }

    /**
     * <p>
     * A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be
     * prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is set to
     * <code>ActiveDirectory</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of users or groups in the Active Directory that are not allowed to access the file share. A group
     *         must be prefixed with the @ character. For example <code>@group1</code>. Can only be set if
     *         Authentication is set to <code>ActiveDirectory</code>.
     */
    public List<String> invalidUserList() {
        return invalidUserList;
    }

    /**
     * <p>
     * The authentication method that users use to access the file share.
     * </p>
     * <p>
     * Valid values are <code>ActiveDirectory</code> or <code>GuestAccess</code>. The default is
     * <code>ActiveDirectory</code>.
     * </p>
     * 
     * @return The authentication method that users use to access the file share.</p>
     *         <p>
     *         Valid values are <code>ActiveDirectory</code> or <code>GuestAccess</code>. The default is
     *         <code>ActiveDirectory</code>.
     */
    public String authentication() {
        return authentication;
    }

    /**
     * <p>
     * A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.
     * </p>
     * <note>
     * <p>
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
     * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
     * maximum length for a tag's value is 256.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.</p>
     *         <note>
     *         <p>
     *         Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
     *         the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters,
     *         and the maximum length for a tag's value is 256.
     *         </p>
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(defaultStorageClass());
        hashCode = 31 * hashCode + Objects.hashCode(objectACLAsString());
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(guessMIMETypeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(requesterPays());
        hashCode = 31 * hashCode + Objects.hashCode(smbaclEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(adminUserList());
        hashCode = 31 * hashCode + Objects.hashCode(validUserList());
        hashCode = 31 * hashCode + Objects.hashCode(invalidUserList());
        hashCode = 31 * hashCode + Objects.hashCode(authentication());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSmbFileShareRequest)) {
            return false;
        }
        CreateSmbFileShareRequest other = (CreateSmbFileShareRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(gatewayARN(), other.gatewayARN())
                && Objects.equals(kmsEncrypted(), other.kmsEncrypted()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(role(), other.role()) && Objects.equals(locationARN(), other.locationARN())
                && Objects.equals(defaultStorageClass(), other.defaultStorageClass())
                && Objects.equals(objectACLAsString(), other.objectACLAsString()) && Objects.equals(readOnly(), other.readOnly())
                && Objects.equals(guessMIMETypeEnabled(), other.guessMIMETypeEnabled())
                && Objects.equals(requesterPays(), other.requesterPays())
                && Objects.equals(smbaclEnabled(), other.smbaclEnabled())
                && Objects.equals(adminUserList(), other.adminUserList())
                && Objects.equals(validUserList(), other.validUserList())
                && Objects.equals(invalidUserList(), other.invalidUserList())
                && Objects.equals(authentication(), other.authentication()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSmbFileShareRequest").add("ClientToken", clientToken()).add("GatewayARN", gatewayARN())
                .add("KMSEncrypted", kmsEncrypted()).add("KMSKey", kmsKey()).add("Role", role())
                .add("LocationARN", locationARN()).add("DefaultStorageClass", defaultStorageClass())
                .add("ObjectACL", objectACLAsString()).add("ReadOnly", readOnly())
                .add("GuessMIMETypeEnabled", guessMIMETypeEnabled()).add("RequesterPays", requesterPays())
                .add("SMBACLEnabled", smbaclEnabled()).add("AdminUserList", adminUserList())
                .add("ValidUserList", validUserList()).add("InvalidUserList", invalidUserList())
                .add("Authentication", authentication()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "KMSEncrypted":
            return Optional.ofNullable(clazz.cast(kmsEncrypted()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "LocationARN":
            return Optional.ofNullable(clazz.cast(locationARN()));
        case "DefaultStorageClass":
            return Optional.ofNullable(clazz.cast(defaultStorageClass()));
        case "ObjectACL":
            return Optional.ofNullable(clazz.cast(objectACLAsString()));
        case "ReadOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        case "GuessMIMETypeEnabled":
            return Optional.ofNullable(clazz.cast(guessMIMETypeEnabled()));
        case "RequesterPays":
            return Optional.ofNullable(clazz.cast(requesterPays()));
        case "SMBACLEnabled":
            return Optional.ofNullable(clazz.cast(smbaclEnabled()));
        case "AdminUserList":
            return Optional.ofNullable(clazz.cast(adminUserList()));
        case "ValidUserList":
            return Optional.ofNullable(clazz.cast(validUserList()));
        case "InvalidUserList":
            return Optional.ofNullable(clazz.cast(invalidUserList()));
        case "Authentication":
            return Optional.ofNullable(clazz.cast(authentication()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSmbFileShareRequest, T> g) {
        return obj -> g.apply((CreateSmbFileShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSmbFileShareRequest> {
        /**
         * <p>
         * A unique string value that you supply that is used by file gateway to ensure idempotent file share creation.
         * </p>
         * 
         * @param clientToken
         *        A unique string value that you supply that is used by file gateway to ensure idempotent file share
         *        creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the file gateway on which you want to create a file share.
         * </p>
         * 
         * @param gatewayARN
         *        The Amazon Resource Name (ARN) of the file gateway on which you want to create a file share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by
         * Amazon S3. Optional.
         * </p>
         * 
         * @param kmsEncrypted
         *        True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed
         *        by Amazon S3. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncrypted(Boolean kmsEncrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can
         * only be set when KMSEncrypted is true. Optional.
         * </p>
         * 
         * @param kmsKey
         *        The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This
         *        value can only be set when KMSEncrypted is true. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the
         * underlying storage.
         * </p>
         * 
         * @param role
         *        The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it
         *        accesses the underlying storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The ARN of the backed storage used for storing file data.
         * </p>
         * 
         * @param locationARN
         *        The ARN of the backed storage used for storing file data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationARN(String locationARN);

        /**
         * <p>
         * The default storage class for objects put into an Amazon S3 bucket by the file gateway. Possible values are
         * <code>S3_STANDARD</code>, <code>S3_STANDARD_IA</code>, or <code>S3_ONEZONE_IA</code>. If this field is not
         * populated, the default value <code>S3_STANDARD</code> is used. Optional.
         * </p>
         * 
         * @param defaultStorageClass
         *        The default storage class for objects put into an Amazon S3 bucket by the file gateway. Possible
         *        values are <code>S3_STANDARD</code>, <code>S3_STANDARD_IA</code>, or <code>S3_ONEZONE_IA</code>. If
         *        this field is not populated, the default value <code>S3_STANDARD</code> is used. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultStorageClass(String defaultStorageClass);

        /**
         * <p>
         * A value that sets the access control list permission for objects in the S3 bucket that a file gateway puts
         * objects into. The default value is "private".
         * </p>
         * 
         * @param objectACL
         *        A value that sets the access control list permission for objects in the S3 bucket that a file gateway
         *        puts objects into. The default value is "private".
         * @see ObjectACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectACL
         */
        Builder objectACL(String objectACL);

        /**
         * <p>
         * A value that sets the access control list permission for objects in the S3 bucket that a file gateway puts
         * objects into. The default value is "private".
         * </p>
         * 
         * @param objectACL
         *        A value that sets the access control list permission for objects in the S3 bucket that a file gateway
         *        puts objects into. The default value is "private".
         * @see ObjectACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectACL
         */
        Builder objectACL(ObjectACL objectACL);

        /**
         * <p>
         * A value that sets the write status of a file share. This value is true if the write status is read-only, and
         * otherwise false.
         * </p>
         * 
         * @param readOnly
         *        A value that sets the write status of a file share. This value is true if the write status is
         *        read-only, and otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);

        /**
         * <p>
         * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value
         * to true to enable MIME type guessing, and otherwise to false. The default value is true.
         * </p>
         * 
         * @param guessMIMETypeEnabled
         *        A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this
         *        value to true to enable MIME type guessing, and otherwise to false. The default value is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled);

        /**
         * <p>
         * A value that sets who pays the cost of the request and the cost associated with data download from the S3
         * bucket. If this value is set to true, the requester pays the costs. Otherwise the S3 bucket owner pays.
         * However, the S3 bucket owner always pays the cost of storing data.
         * </p>
         * <note>
         * <p>
         * <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that
         * the configuration on the file share is the same as the S3 bucket configuration.
         * </p>
         * </note>
         * 
         * @param requesterPays
         *        A value that sets who pays the cost of the request and the cost associated with data download from the
         *        S3 bucket. If this value is set to true, the requester pays the costs. Otherwise the S3 bucket owner
         *        pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
         *        <p>
         *        <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make
         *        sure that the configuration on the file share is the same as the S3 bucket configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPays(Boolean requesterPays);

        /**
         * <p>
         * Set this value to "true to enable ACL (access control list) on the SMB file share. Set it to "false" to map
         * file and directory permissions to the POSIX permissions.
         * </p>
         * <p>
         * For more information, see https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html in the
         * Storage Gateway User Guide.
         * </p>
         * 
         * @param smbaclEnabled
         *        Set this value to "true to enable ACL (access control list) on the SMB file share. Set it to "false"
         *        to map file and directory permissions to the POSIX permissions.</p>
         *        <p>
         *        For more information, see https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html in
         *        the Storage Gateway User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smbaclEnabled(Boolean smbaclEnabled);

        /**
         * <p>
         * A list of users in the Active Directory that will be granted administrator privileges on the file share.
         * These users can do all file operations as the super-user.
         * </p>
         * <important>
         * <p>
         * Use this option very carefully, because any user in this list can do anything they like on the file share,
         * regardless of file permissions.
         * </p>
         * </important>
         * 
         * @param adminUserList
         *        A list of users in the Active Directory that will be granted administrator privileges on the file
         *        share. These users can do all file operations as the super-user. </p> <important>
         *        <p>
         *        Use this option very carefully, because any user in this list can do anything they like on the file
         *        share, regardless of file permissions.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUserList(Collection<String> adminUserList);

        /**
         * <p>
         * A list of users in the Active Directory that will be granted administrator privileges on the file share.
         * These users can do all file operations as the super-user.
         * </p>
         * <important>
         * <p>
         * Use this option very carefully, because any user in this list can do anything they like on the file share,
         * regardless of file permissions.
         * </p>
         * </important>
         * 
         * @param adminUserList
         *        A list of users in the Active Directory that will be granted administrator privileges on the file
         *        share. These users can do all file operations as the super-user. </p> <important>
         *        <p>
         *        Use this option very carefully, because any user in this list can do anything they like on the file
         *        share, regardless of file permissions.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUserList(String... adminUserList);

        /**
         * <p>
         * A list of users or groups in the Active Directory that are allowed to access the file share. A group must be
         * prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is set to
         * <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param validUserList
         *        A list of users or groups in the Active Directory that are allowed to access the file share. A group
         *        must be prefixed with the @ character. For example <code>@group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUserList(Collection<String> validUserList);

        /**
         * <p>
         * A list of users or groups in the Active Directory that are allowed to access the file share. A group must be
         * prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is set to
         * <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param validUserList
         *        A list of users or groups in the Active Directory that are allowed to access the file share. A group
         *        must be prefixed with the @ character. For example <code>@group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUserList(String... validUserList);

        /**
         * <p>
         * A list of users or groups in the Active Directory that are not allowed to access the file share. A group must
         * be prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is set
         * to <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param invalidUserList
         *        A list of users or groups in the Active Directory that are not allowed to access the file share. A
         *        group must be prefixed with the @ character. For example <code>@group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidUserList(Collection<String> invalidUserList);

        /**
         * <p>
         * A list of users or groups in the Active Directory that are not allowed to access the file share. A group must
         * be prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is set
         * to <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param invalidUserList
         *        A list of users or groups in the Active Directory that are not allowed to access the file share. A
         *        group must be prefixed with the @ character. For example <code>@group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidUserList(String... invalidUserList);

        /**
         * <p>
         * The authentication method that users use to access the file share.
         * </p>
         * <p>
         * Valid values are <code>ActiveDirectory</code> or <code>GuestAccess</code>. The default is
         * <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param authentication
         *        The authentication method that users use to access the file share.</p>
         *        <p>
         *        Valid values are <code>ActiveDirectory</code> or <code>GuestAccess</code>. The default is
         *        <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authentication(String authentication);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.</p>
         *        <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
         *        characters, and the maximum length for a tag's value is 256.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.</p>
         *        <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
         *        characters, and the maximum length for a tag's value is 256.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String gatewayARN;

        private Boolean kmsEncrypted;

        private String kmsKey;

        private String role;

        private String locationARN;

        private String defaultStorageClass;

        private String objectACL;

        private Boolean readOnly;

        private Boolean guessMIMETypeEnabled;

        private Boolean requesterPays;

        private Boolean smbaclEnabled;

        private List<String> adminUserList = DefaultSdkAutoConstructList.getInstance();

        private List<String> validUserList = DefaultSdkAutoConstructList.getInstance();

        private List<String> invalidUserList = DefaultSdkAutoConstructList.getInstance();

        private String authentication;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSmbFileShareRequest model) {
            super(model);
            clientToken(model.clientToken);
            gatewayARN(model.gatewayARN);
            kmsEncrypted(model.kmsEncrypted);
            kmsKey(model.kmsKey);
            role(model.role);
            locationARN(model.locationARN);
            defaultStorageClass(model.defaultStorageClass);
            objectACL(model.objectACL);
            readOnly(model.readOnly);
            guessMIMETypeEnabled(model.guessMIMETypeEnabled);
            requesterPays(model.requesterPays);
            smbaclEnabled(model.smbaclEnabled);
            adminUserList(model.adminUserList);
            validUserList(model.validUserList);
            invalidUserList(model.invalidUserList);
            authentication(model.authentication);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Boolean getKmsEncrypted() {
            return kmsEncrypted;
        }

        @Override
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getLocationARN() {
            return locationARN;
        }

        @Override
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        public final String getDefaultStorageClass() {
            return defaultStorageClass;
        }

        @Override
        public final Builder defaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
            return this;
        }

        public final void setDefaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
        }

        public final String getObjectACLAsString() {
            return objectACL;
        }

        @Override
        public final Builder objectACL(String objectACL) {
            this.objectACL = objectACL;
            return this;
        }

        @Override
        public final Builder objectACL(ObjectACL objectACL) {
            this.objectACL(objectACL == null ? null : objectACL.toString());
            return this;
        }

        public final void setObjectACL(String objectACL) {
            this.objectACL = objectACL;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public final Boolean getGuessMIMETypeEnabled() {
            return guessMIMETypeEnabled;
        }

        @Override
        public final Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
            return this;
        }

        public final void setGuessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
        }

        public final Boolean getRequesterPays() {
            return requesterPays;
        }

        @Override
        public final Builder requesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
            return this;
        }

        public final void setRequesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
        }

        public final Boolean getSmbaclEnabled() {
            return smbaclEnabled;
        }

        @Override
        public final Builder smbaclEnabled(Boolean smbaclEnabled) {
            this.smbaclEnabled = smbaclEnabled;
            return this;
        }

        public final void setSmbaclEnabled(Boolean smbaclEnabled) {
            this.smbaclEnabled = smbaclEnabled;
        }

        public final Collection<String> getAdminUserList() {
            return adminUserList;
        }

        @Override
        public final Builder adminUserList(Collection<String> adminUserList) {
            this.adminUserList = FileShareUserListCopier.copy(adminUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adminUserList(String... adminUserList) {
            adminUserList(Arrays.asList(adminUserList));
            return this;
        }

        public final void setAdminUserList(Collection<String> adminUserList) {
            this.adminUserList = FileShareUserListCopier.copy(adminUserList);
        }

        public final Collection<String> getValidUserList() {
            return validUserList;
        }

        @Override
        public final Builder validUserList(Collection<String> validUserList) {
            this.validUserList = FileShareUserListCopier.copy(validUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUserList(String... validUserList) {
            validUserList(Arrays.asList(validUserList));
            return this;
        }

        public final void setValidUserList(Collection<String> validUserList) {
            this.validUserList = FileShareUserListCopier.copy(validUserList);
        }

        public final Collection<String> getInvalidUserList() {
            return invalidUserList;
        }

        @Override
        public final Builder invalidUserList(Collection<String> invalidUserList) {
            this.invalidUserList = FileShareUserListCopier.copy(invalidUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidUserList(String... invalidUserList) {
            invalidUserList(Arrays.asList(invalidUserList));
            return this;
        }

        public final void setInvalidUserList(Collection<String> invalidUserList) {
            this.invalidUserList = FileShareUserListCopier.copy(invalidUserList);
        }

        public final String getAuthentication() {
            return authentication;
        }

        @Override
        public final Builder authentication(String authentication) {
            this.authentication = authentication;
            return this;
        }

        public final void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSmbFileShareRequest build() {
            return new CreateSmbFileShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
