/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotScheduleResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeSnapshotScheduleResponse.Builder, DescribeSnapshotScheduleResponse> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSnapshotScheduleResponse::volumeARN)).setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final SdkField<Integer> START_AT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeSnapshotScheduleResponse::startAt)).setter(setter(Builder::startAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartAt").build()).build();

    private static final SdkField<Integer> RECURRENCE_IN_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeSnapshotScheduleResponse::recurrenceInHours)).setter(setter(Builder::recurrenceInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurrenceInHours").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSnapshotScheduleResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSnapshotScheduleResponse::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSnapshotScheduleResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD,
            START_AT_FIELD, RECURRENCE_IN_HOURS_FIELD, DESCRIPTION_FIELD, TIMEZONE_FIELD, TAGS_FIELD));

    private final String volumeARN;

    private final Integer startAt;

    private final Integer recurrenceInHours;

    private final String description;

    private final String timezone;

    private final List<Tag> tags;

    private DescribeSnapshotScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.volumeARN = builder.volumeARN;
        this.startAt = builder.startAt;
        this.recurrenceInHours = builder.recurrenceInHours;
        this.description = builder.description;
        this.timezone = builder.timezone;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the volume that was specified in the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the volume that was specified in the request.
     */
    public String volumeARN() {
        return volumeARN;
    }

    /**
     * <p>
     * The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the hour
     * (0 to 23). The hour of the day is in the time zone of the gateway.
     * </p>
     * 
     * @return The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is
     *         the hour (0 to 23). The hour of the day is in the time zone of the gateway.
     */
    public Integer startAt() {
        return startAt;
    }

    /**
     * <p>
     * The number of hours between snapshots.
     * </p>
     * 
     * @return The number of hours between snapshots.
     */
    public Integer recurrenceInHours() {
        return recurrenceInHours;
    }

    /**
     * <p>
     * The snapshot description.
     * </p>
     * 
     * @return The snapshot description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A value that indicates the time zone of the gateway.
     * </p>
     * 
     * @return A value that indicates the time zone of the gateway.
     */
    public String timezone() {
        return timezone;
    }

    /**
     * <p>
     * A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key name. Each tag is a
     * key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
     * <code>ListTagsForResource</code> API operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key name. Each tag is
     *         a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
     *         <code>ListTagsForResource</code> API operation.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(startAt());
        hashCode = 31 * hashCode + Objects.hashCode(recurrenceInHours());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotScheduleResponse)) {
            return false;
        }
        DescribeSnapshotScheduleResponse other = (DescribeSnapshotScheduleResponse) obj;
        return Objects.equals(volumeARN(), other.volumeARN()) && Objects.equals(startAt(), other.startAt())
                && Objects.equals(recurrenceInHours(), other.recurrenceInHours())
                && Objects.equals(description(), other.description()) && Objects.equals(timezone(), other.timezone())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSnapshotScheduleResponse").add("VolumeARN", volumeARN()).add("StartAt", startAt())
                .add("RecurrenceInHours", recurrenceInHours()).add("Description", description()).add("Timezone", timezone())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        case "StartAt":
            return Optional.ofNullable(clazz.cast(startAt()));
        case "RecurrenceInHours":
            return Optional.ofNullable(clazz.cast(recurrenceInHours()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotScheduleResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSnapshotScheduleResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the volume that was specified in the request.
         * </p>
         * 
         * @param volumeARN
         *        The Amazon Resource Name (ARN) of the volume that was specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);

        /**
         * <p>
         * The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the
         * hour (0 to 23). The hour of the day is in the time zone of the gateway.
         * </p>
         * 
         * @param startAt
         *        The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is
         *        the hour (0 to 23). The hour of the day is in the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startAt(Integer startAt);

        /**
         * <p>
         * The number of hours between snapshots.
         * </p>
         * 
         * @param recurrenceInHours
         *        The number of hours between snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrenceInHours(Integer recurrenceInHours);

        /**
         * <p>
         * The snapshot description.
         * </p>
         * 
         * @param description
         *        The snapshot description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A value that indicates the time zone of the gateway.
         * </p>
         * 
         * @param timezone
         *        A value that indicates the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key name. Each tag is a
         * key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         * <code>ListTagsForResource</code> API operation.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key name. Each tag
         *        is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         *        <code>ListTagsForResource</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key name. Each tag is a
         * key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         * <code>ListTagsForResource</code> API operation.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key name. Each tag
         *        is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         *        <code>ListTagsForResource</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key name. Each tag is a
         * key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         * <code>ListTagsForResource</code> API operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String volumeARN;

        private Integer startAt;

        private Integer recurrenceInHours;

        private String description;

        private String timezone;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotScheduleResponse model) {
            super(model);
            volumeARN(model.volumeARN);
            startAt(model.startAt);
            recurrenceInHours(model.recurrenceInHours);
            description(model.description);
            timezone(model.timezone);
            tags(model.tags);
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final Integer getStartAt() {
            return startAt;
        }

        @Override
        public final Builder startAt(Integer startAt) {
            this.startAt = startAt;
            return this;
        }

        public final void setStartAt(Integer startAt) {
            this.startAt = startAt;
        }

        public final Integer getRecurrenceInHours() {
            return recurrenceInHours;
        }

        @Override
        public final Builder recurrenceInHours(Integer recurrenceInHours) {
            this.recurrenceInHours = recurrenceInHours;
            return this;
        }

        public final void setRecurrenceInHours(Integer recurrenceInHours) {
            this.recurrenceInHours = recurrenceInHours;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTimezone() {
            return timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public DescribeSnapshotScheduleResponse build() {
            return new DescribeSnapshotScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
