/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCacheResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeCacheResponse.Builder, DescribeCacheResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeCacheResponse::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<List<String>> DISK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeCacheResponse::diskIds))
            .setter(setter(Builder::diskIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> CACHE_ALLOCATED_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeCacheResponse::cacheAllocatedInBytes)).setter(setter(Builder::cacheAllocatedInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAllocatedInBytes").build())
            .build();

    private static final SdkField<Double> CACHE_USED_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DescribeCacheResponse::cacheUsedPercentage)).setter(setter(Builder::cacheUsedPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheUsedPercentage").build())
            .build();

    private static final SdkField<Double> CACHE_DIRTY_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DescribeCacheResponse::cacheDirtyPercentage)).setter(setter(Builder::cacheDirtyPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheDirtyPercentage").build())
            .build();

    private static final SdkField<Double> CACHE_HIT_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DescribeCacheResponse::cacheHitPercentage)).setter(setter(Builder::cacheHitPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheHitPercentage").build())
            .build();

    private static final SdkField<Double> CACHE_MISS_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DescribeCacheResponse::cacheMissPercentage)).setter(setter(Builder::cacheMissPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheMissPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            DISK_IDS_FIELD, CACHE_ALLOCATED_IN_BYTES_FIELD, CACHE_USED_PERCENTAGE_FIELD, CACHE_DIRTY_PERCENTAGE_FIELD,
            CACHE_HIT_PERCENTAGE_FIELD, CACHE_MISS_PERCENTAGE_FIELD));

    private final String gatewayARN;

    private final List<String> diskIds;

    private final Long cacheAllocatedInBytes;

    private final Double cacheUsedPercentage;

    private final Double cacheDirtyPercentage;

    private final Double cacheHitPercentage;

    private final Double cacheMissPercentage;

    private DescribeCacheResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.diskIds = builder.diskIds;
        this.cacheAllocatedInBytes = builder.cacheAllocatedInBytes;
        this.cacheUsedPercentage = builder.cacheUsedPercentage;
        this.cacheDirtyPercentage = builder.cacheDirtyPercentage;
        this.cacheHitPercentage = builder.cacheHitPercentage;
        this.cacheMissPercentage = builder.cacheMissPercentage;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * An array of strings that identify disks that are to be configured as working storage. Each string have a minimum
     * length of 1 and maximum length of 300. You can get the disk IDs from the <a>ListLocalDisks</a> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of strings that identify disks that are to be configured as working storage. Each string have a
     *         minimum length of 1 and maximum length of 300. You can get the disk IDs from the <a>ListLocalDisks</a>
     *         API.
     */
    public List<String> diskIds() {
        return diskIds;
    }

    /**
     * <p>
     * The amount of cache in bytes allocated to the a gateway.
     * </p>
     * 
     * @return The amount of cache in bytes allocated to the a gateway.
     */
    public Long cacheAllocatedInBytes() {
        return cacheAllocatedInBytes;
    }

    /**
     * <p>
     * Percent use of the gateway's cache storage. This metric applies only to the gateway-cached volume setup. The
     * sample is taken at the end of the reporting period.
     * </p>
     * 
     * @return Percent use of the gateway's cache storage. This metric applies only to the gateway-cached volume setup.
     *         The sample is taken at the end of the reporting period.
     */
    public Double cacheUsedPercentage() {
        return cacheUsedPercentage;
    }

    /**
     * <p>
     * The file share's contribution to the overall percentage of the gateway's cache that has not been persisted to
     * AWS. The sample is taken at the end of the reporting period.
     * </p>
     * 
     * @return The file share's contribution to the overall percentage of the gateway's cache that has not been
     *         persisted to AWS. The sample is taken at the end of the reporting period.
     */
    public Double cacheDirtyPercentage() {
        return cacheDirtyPercentage;
    }

    /**
     * <p>
     * Percent of application read operations from the file shares that are served from cache. The sample is taken at
     * the end of the reporting period.
     * </p>
     * 
     * @return Percent of application read operations from the file shares that are served from cache. The sample is
     *         taken at the end of the reporting period.
     */
    public Double cacheHitPercentage() {
        return cacheHitPercentage;
    }

    /**
     * <p>
     * Percent of application read operations from the file shares that are not served from cache. The sample is taken
     * at the end of the reporting period.
     * </p>
     * 
     * @return Percent of application read operations from the file shares that are not served from cache. The sample is
     *         taken at the end of the reporting period.
     */
    public Double cacheMissPercentage() {
        return cacheMissPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(diskIds());
        hashCode = 31 * hashCode + Objects.hashCode(cacheAllocatedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(cacheUsedPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(cacheDirtyPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(cacheHitPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(cacheMissPercentage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheResponse)) {
            return false;
        }
        DescribeCacheResponse other = (DescribeCacheResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(diskIds(), other.diskIds())
                && Objects.equals(cacheAllocatedInBytes(), other.cacheAllocatedInBytes())
                && Objects.equals(cacheUsedPercentage(), other.cacheUsedPercentage())
                && Objects.equals(cacheDirtyPercentage(), other.cacheDirtyPercentage())
                && Objects.equals(cacheHitPercentage(), other.cacheHitPercentage())
                && Objects.equals(cacheMissPercentage(), other.cacheMissPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeCacheResponse").add("GatewayARN", gatewayARN()).add("DiskIds", diskIds())
                .add("CacheAllocatedInBytes", cacheAllocatedInBytes()).add("CacheUsedPercentage", cacheUsedPercentage())
                .add("CacheDirtyPercentage", cacheDirtyPercentage()).add("CacheHitPercentage", cacheHitPercentage())
                .add("CacheMissPercentage", cacheMissPercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "DiskIds":
            return Optional.ofNullable(clazz.cast(diskIds()));
        case "CacheAllocatedInBytes":
            return Optional.ofNullable(clazz.cast(cacheAllocatedInBytes()));
        case "CacheUsedPercentage":
            return Optional.ofNullable(clazz.cast(cacheUsedPercentage()));
        case "CacheDirtyPercentage":
            return Optional.ofNullable(clazz.cast(cacheDirtyPercentage()));
        case "CacheHitPercentage":
            return Optional.ofNullable(clazz.cast(cacheHitPercentage()));
        case "CacheMissPercentage":
            return Optional.ofNullable(clazz.cast(cacheMissPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheResponse, T> g) {
        return obj -> g.apply((DescribeCacheResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCacheResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * An array of strings that identify disks that are to be configured as working storage. Each string have a
         * minimum length of 1 and maximum length of 300. You can get the disk IDs from the <a>ListLocalDisks</a> API.
         * </p>
         * 
         * @param diskIds
         *        An array of strings that identify disks that are to be configured as working storage. Each string have
         *        a minimum length of 1 and maximum length of 300. You can get the disk IDs from the
         *        <a>ListLocalDisks</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskIds(Collection<String> diskIds);

        /**
         * <p>
         * An array of strings that identify disks that are to be configured as working storage. Each string have a
         * minimum length of 1 and maximum length of 300. You can get the disk IDs from the <a>ListLocalDisks</a> API.
         * </p>
         * 
         * @param diskIds
         *        An array of strings that identify disks that are to be configured as working storage. Each string have
         *        a minimum length of 1 and maximum length of 300. You can get the disk IDs from the
         *        <a>ListLocalDisks</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskIds(String... diskIds);

        /**
         * <p>
         * The amount of cache in bytes allocated to the a gateway.
         * </p>
         * 
         * @param cacheAllocatedInBytes
         *        The amount of cache in bytes allocated to the a gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheAllocatedInBytes(Long cacheAllocatedInBytes);

        /**
         * <p>
         * Percent use of the gateway's cache storage. This metric applies only to the gateway-cached volume setup. The
         * sample is taken at the end of the reporting period.
         * </p>
         * 
         * @param cacheUsedPercentage
         *        Percent use of the gateway's cache storage. This metric applies only to the gateway-cached volume
         *        setup. The sample is taken at the end of the reporting period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheUsedPercentage(Double cacheUsedPercentage);

        /**
         * <p>
         * The file share's contribution to the overall percentage of the gateway's cache that has not been persisted to
         * AWS. The sample is taken at the end of the reporting period.
         * </p>
         * 
         * @param cacheDirtyPercentage
         *        The file share's contribution to the overall percentage of the gateway's cache that has not been
         *        persisted to AWS. The sample is taken at the end of the reporting period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheDirtyPercentage(Double cacheDirtyPercentage);

        /**
         * <p>
         * Percent of application read operations from the file shares that are served from cache. The sample is taken
         * at the end of the reporting period.
         * </p>
         * 
         * @param cacheHitPercentage
         *        Percent of application read operations from the file shares that are served from cache. The sample is
         *        taken at the end of the reporting period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheHitPercentage(Double cacheHitPercentage);

        /**
         * <p>
         * Percent of application read operations from the file shares that are not served from cache. The sample is
         * taken at the end of the reporting period.
         * </p>
         * 
         * @param cacheMissPercentage
         *        Percent of application read operations from the file shares that are not served from cache. The sample
         *        is taken at the end of the reporting period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheMissPercentage(Double cacheMissPercentage);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private List<String> diskIds = DefaultSdkAutoConstructList.getInstance();

        private Long cacheAllocatedInBytes;

        private Double cacheUsedPercentage;

        private Double cacheDirtyPercentage;

        private Double cacheHitPercentage;

        private Double cacheMissPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            diskIds(model.diskIds);
            cacheAllocatedInBytes(model.cacheAllocatedInBytes);
            cacheUsedPercentage(model.cacheUsedPercentage);
            cacheDirtyPercentage(model.cacheDirtyPercentage);
            cacheHitPercentage(model.cacheHitPercentage);
            cacheMissPercentage(model.cacheMissPercentage);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<String> getDiskIds() {
            return diskIds;
        }

        @Override
        public final Builder diskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskIds(String... diskIds) {
            diskIds(Arrays.asList(diskIds));
            return this;
        }

        public final void setDiskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
        }

        public final Long getCacheAllocatedInBytes() {
            return cacheAllocatedInBytes;
        }

        @Override
        public final Builder cacheAllocatedInBytes(Long cacheAllocatedInBytes) {
            this.cacheAllocatedInBytes = cacheAllocatedInBytes;
            return this;
        }

        public final void setCacheAllocatedInBytes(Long cacheAllocatedInBytes) {
            this.cacheAllocatedInBytes = cacheAllocatedInBytes;
        }

        public final Double getCacheUsedPercentage() {
            return cacheUsedPercentage;
        }

        @Override
        public final Builder cacheUsedPercentage(Double cacheUsedPercentage) {
            this.cacheUsedPercentage = cacheUsedPercentage;
            return this;
        }

        public final void setCacheUsedPercentage(Double cacheUsedPercentage) {
            this.cacheUsedPercentage = cacheUsedPercentage;
        }

        public final Double getCacheDirtyPercentage() {
            return cacheDirtyPercentage;
        }

        @Override
        public final Builder cacheDirtyPercentage(Double cacheDirtyPercentage) {
            this.cacheDirtyPercentage = cacheDirtyPercentage;
            return this;
        }

        public final void setCacheDirtyPercentage(Double cacheDirtyPercentage) {
            this.cacheDirtyPercentage = cacheDirtyPercentage;
        }

        public final Double getCacheHitPercentage() {
            return cacheHitPercentage;
        }

        @Override
        public final Builder cacheHitPercentage(Double cacheHitPercentage) {
            this.cacheHitPercentage = cacheHitPercentage;
            return this;
        }

        public final void setCacheHitPercentage(Double cacheHitPercentage) {
            this.cacheHitPercentage = cacheHitPercentage;
        }

        public final Double getCacheMissPercentage() {
            return cacheMissPercentage;
        }

        @Override
        public final Builder cacheMissPercentage(Double cacheMissPercentage) {
            this.cacheMissPercentage = cacheMissPercentage;
            return this;
        }

        public final void setCacheMissPercentage(Double cacheMissPercentage) {
            this.cacheMissPercentage = cacheMissPercentage;
        }

        @Override
        public DescribeCacheResponse build() {
            return new DescribeCacheResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
