/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGatewayInformationResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeGatewayInformationResponse.Builder, DescribeGatewayInformationResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayInformationResponse::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayInformationResponse::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()).build();

    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayInformationResponse::gatewayName)).setter(setter(Builder::gatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayName").build()).build();

    private static final SdkField<String> GATEWAY_TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayInformationResponse::gatewayTimezone)).setter(setter(Builder::gatewayTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayTimezone").build()).build();

    private static final SdkField<String> GATEWAY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayInformationResponse::gatewayState)).setter(setter(Builder::gatewayState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayState").build()).build();

    private static final SdkField<List<NetworkInterface>> GATEWAY_NETWORK_INTERFACES_FIELD = SdkField
            .<List<NetworkInterface>> builder(MarshallingType.LIST)
            .getter(getter(DescribeGatewayInformationResponse::gatewayNetworkInterfaces))
            .setter(setter(Builder::gatewayNetworkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayNetworkInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayInformationResponse::gatewayType)).setter(setter(Builder::gatewayType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()).build();

    private static final SdkField<String> NEXT_UPDATE_AVAILABILITY_DATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayInformationResponse::nextUpdateAvailabilityDate))
            .setter(setter(Builder::nextUpdateAvailabilityDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextUpdateAvailabilityDate").build())
            .build();

    private static final SdkField<String> LAST_SOFTWARE_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayInformationResponse::lastSoftwareUpdate)).setter(setter(Builder::lastSoftwareUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSoftwareUpdate").build())
            .build();

    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayInformationResponse::ec2InstanceId)).setter(setter(Builder::ec2InstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()).build();

    private static final SdkField<String> EC2_INSTANCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayInformationResponse::ec2InstanceRegion)).setter(setter(Builder::ec2InstanceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceRegion").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(DescribeGatewayInformationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayInformationResponse::vpcEndpoint)).setter(setter(Builder::vpcEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCEndpoint").build()).build();

    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayInformationResponse::cloudWatchLogGroupARN))
            .setter(setter(Builder::cloudWatchLogGroupARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupARN").build())
            .build();

    private static final SdkField<String> HOST_ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayInformationResponse::hostEnvironmentAsString)).setter(setter(Builder::hostEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostEnvironment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            GATEWAY_ID_FIELD, GATEWAY_NAME_FIELD, GATEWAY_TIMEZONE_FIELD, GATEWAY_STATE_FIELD, GATEWAY_NETWORK_INTERFACES_FIELD,
            GATEWAY_TYPE_FIELD, NEXT_UPDATE_AVAILABILITY_DATE_FIELD, LAST_SOFTWARE_UPDATE_FIELD, EC2_INSTANCE_ID_FIELD,
            EC2_INSTANCE_REGION_FIELD, TAGS_FIELD, VPC_ENDPOINT_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, HOST_ENVIRONMENT_FIELD));

    private final String gatewayARN;

    private final String gatewayId;

    private final String gatewayName;

    private final String gatewayTimezone;

    private final String gatewayState;

    private final List<NetworkInterface> gatewayNetworkInterfaces;

    private final String gatewayType;

    private final String nextUpdateAvailabilityDate;

    private final String lastSoftwareUpdate;

    private final String ec2InstanceId;

    private final String ec2InstanceRegion;

    private final List<Tag> tags;

    private final String vpcEndpoint;

    private final String cloudWatchLogGroupARN;

    private final String hostEnvironment;

    private DescribeGatewayInformationResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.gatewayId = builder.gatewayId;
        this.gatewayName = builder.gatewayName;
        this.gatewayTimezone = builder.gatewayTimezone;
        this.gatewayState = builder.gatewayState;
        this.gatewayNetworkInterfaces = builder.gatewayNetworkInterfaces;
        this.gatewayType = builder.gatewayType;
        this.nextUpdateAvailabilityDate = builder.nextUpdateAvailabilityDate;
        this.lastSoftwareUpdate = builder.lastSoftwareUpdate;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.ec2InstanceRegion = builder.ec2InstanceRegion;
        this.tags = builder.tags;
        this.vpcEndpoint = builder.vpcEndpoint;
        this.cloudWatchLogGroupARN = builder.cloudWatchLogGroupARN;
        this.hostEnvironment = builder.hostEnvironment;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
     * Resource Name (ARN), which you use as input for other operations.
     * </p>
     * 
     * @return The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway
     *         Amazon Resource Name (ARN), which you use as input for other operations.
     */
    public String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The name you configured for your gateway.
     * </p>
     * 
     * @return The name you configured for your gateway.
     */
    public String gatewayName() {
        return gatewayName;
    }

    /**
     * <p>
     * A value that indicates the time zone configured for the gateway.
     * </p>
     * 
     * @return A value that indicates the time zone configured for the gateway.
     */
    public String gatewayTimezone() {
        return gatewayTimezone;
    }

    /**
     * <p>
     * A value that indicates the operating state of the gateway.
     * </p>
     * 
     * @return A value that indicates the operating state of the gateway.
     */
    public String gatewayState() {
        return gatewayState;
    }

    /**
     * <p>
     * A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
     */
    public List<NetworkInterface> gatewayNetworkInterfaces() {
        return gatewayNetworkInterfaces;
    }

    /**
     * <p>
     * The type of the gateway.
     * </p>
     * 
     * @return The type of the gateway.
     */
    public String gatewayType() {
        return gatewayType;
    }

    /**
     * <p>
     * The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the
     * gateway is not available for an update this field is not returned in the response.
     * </p>
     * 
     * @return The date on which an update to the gateway is available. This date is in the time zone of the gateway. If
     *         the gateway is not available for an update this field is not returned in the response.
     */
    public String nextUpdateAvailabilityDate() {
        return nextUpdateAvailabilityDate;
    }

    /**
     * <p>
     * The date on which the last software update was applied to the gateway. If the gateway has never been updated,
     * this field does not return a value in the response.
     * </p>
     * 
     * @return The date on which the last software update was applied to the gateway. If the gateway has never been
     *         updated, this field does not return a value in the response.
     */
    public String lastSoftwareUpdate() {
        return lastSoftwareUpdate;
    }

    /**
     * <p>
     * The ID of the Amazon EC2 instance that was used to launch the gateway.
     * </p>
     * 
     * @return The ID of the Amazon EC2 instance that was used to launch the gateway.
     */
    public String ec2InstanceId() {
        return ec2InstanceId;
    }

    /**
     * <p>
     * The AWS Region where the Amazon EC2 instance is located.
     * </p>
     * 
     * @return The AWS Region where the Amazon EC2 instance is located.
     */
    public String ec2InstanceRegion() {
        return ec2InstanceRegion;
    }

    /**
     * <p>
     * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair.
     * For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code>
     * API operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a
     *         key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
     *         <code>ListTagsForResource</code> API operation.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
     * </p>
     * 
     * @return The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
     */
    public String vpcEndpoint() {
        return vpcEndpoint;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch Log Group that is used to monitor events in the gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon CloudWatch Log Group that is used to monitor events in the
     *         gateway.
     */
    public String cloudWatchLogGroupARN() {
        return cloudWatchLogGroupARN;
    }

    /**
     * <p>
     * The type of hypervisor environment used by the host.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostEnvironment}
     * will return {@link HostEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hostEnvironmentAsString}.
     * </p>
     * 
     * @return The type of hypervisor environment used by the host.
     * @see HostEnvironment
     */
    public HostEnvironment hostEnvironment() {
        return HostEnvironment.fromValue(hostEnvironment);
    }

    /**
     * <p>
     * The type of hypervisor environment used by the host.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostEnvironment}
     * will return {@link HostEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hostEnvironmentAsString}.
     * </p>
     * 
     * @return The type of hypervisor environment used by the host.
     * @see HostEnvironment
     */
    public String hostEnvironmentAsString() {
        return hostEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayState());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayNetworkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayType());
        hashCode = 31 * hashCode + Objects.hashCode(nextUpdateAvailabilityDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastSoftwareUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupARN());
        hashCode = 31 * hashCode + Objects.hashCode(hostEnvironmentAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayInformationResponse)) {
            return false;
        }
        DescribeGatewayInformationResponse other = (DescribeGatewayInformationResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(gatewayId(), other.gatewayId())
                && Objects.equals(gatewayName(), other.gatewayName())
                && Objects.equals(gatewayTimezone(), other.gatewayTimezone())
                && Objects.equals(gatewayState(), other.gatewayState())
                && Objects.equals(gatewayNetworkInterfaces(), other.gatewayNetworkInterfaces())
                && Objects.equals(gatewayType(), other.gatewayType())
                && Objects.equals(nextUpdateAvailabilityDate(), other.nextUpdateAvailabilityDate())
                && Objects.equals(lastSoftwareUpdate(), other.lastSoftwareUpdate())
                && Objects.equals(ec2InstanceId(), other.ec2InstanceId())
                && Objects.equals(ec2InstanceRegion(), other.ec2InstanceRegion()) && Objects.equals(tags(), other.tags())
                && Objects.equals(vpcEndpoint(), other.vpcEndpoint())
                && Objects.equals(cloudWatchLogGroupARN(), other.cloudWatchLogGroupARN())
                && Objects.equals(hostEnvironmentAsString(), other.hostEnvironmentAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeGatewayInformationResponse").add("GatewayARN", gatewayARN())
                .add("GatewayId", gatewayId()).add("GatewayName", gatewayName()).add("GatewayTimezone", gatewayTimezone())
                .add("GatewayState", gatewayState()).add("GatewayNetworkInterfaces", gatewayNetworkInterfaces())
                .add("GatewayType", gatewayType()).add("NextUpdateAvailabilityDate", nextUpdateAvailabilityDate())
                .add("LastSoftwareUpdate", lastSoftwareUpdate()).add("Ec2InstanceId", ec2InstanceId())
                .add("Ec2InstanceRegion", ec2InstanceRegion()).add("Tags", tags()).add("VPCEndpoint", vpcEndpoint())
                .add("CloudWatchLogGroupARN", cloudWatchLogGroupARN()).add("HostEnvironment", hostEnvironmentAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "GatewayName":
            return Optional.ofNullable(clazz.cast(gatewayName()));
        case "GatewayTimezone":
            return Optional.ofNullable(clazz.cast(gatewayTimezone()));
        case "GatewayState":
            return Optional.ofNullable(clazz.cast(gatewayState()));
        case "GatewayNetworkInterfaces":
            return Optional.ofNullable(clazz.cast(gatewayNetworkInterfaces()));
        case "GatewayType":
            return Optional.ofNullable(clazz.cast(gatewayType()));
        case "NextUpdateAvailabilityDate":
            return Optional.ofNullable(clazz.cast(nextUpdateAvailabilityDate()));
        case "LastSoftwareUpdate":
            return Optional.ofNullable(clazz.cast(lastSoftwareUpdate()));
        case "Ec2InstanceId":
            return Optional.ofNullable(clazz.cast(ec2InstanceId()));
        case "Ec2InstanceRegion":
            return Optional.ofNullable(clazz.cast(ec2InstanceRegion()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VPCEndpoint":
            return Optional.ofNullable(clazz.cast(vpcEndpoint()));
        case "CloudWatchLogGroupARN":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupARN()));
        case "HostEnvironment":
            return Optional.ofNullable(clazz.cast(hostEnvironmentAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayInformationResponse, T> g) {
        return obj -> g.apply((DescribeGatewayInformationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeGatewayInformationResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
         * Resource Name (ARN), which you use as input for other operations.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway
         *        Amazon Resource Name (ARN), which you use as input for other operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The name you configured for your gateway.
         * </p>
         * 
         * @param gatewayName
         *        The name you configured for your gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayName(String gatewayName);

        /**
         * <p>
         * A value that indicates the time zone configured for the gateway.
         * </p>
         * 
         * @param gatewayTimezone
         *        A value that indicates the time zone configured for the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayTimezone(String gatewayTimezone);

        /**
         * <p>
         * A value that indicates the operating state of the gateway.
         * </p>
         * 
         * @param gatewayState
         *        A value that indicates the operating state of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayState(String gatewayState);

        /**
         * <p>
         * A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
         * </p>
         * 
         * @param gatewayNetworkInterfaces
         *        A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayNetworkInterfaces(Collection<NetworkInterface> gatewayNetworkInterfaces);

        /**
         * <p>
         * A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
         * </p>
         * 
         * @param gatewayNetworkInterfaces
         *        A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayNetworkInterfaces(NetworkInterface... gatewayNetworkInterfaces);

        /**
         * <p>
         * A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkInterface>.Builder} avoiding the
         * need to create one manually via {@link List<NetworkInterface>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkInterface>.Builder#build()} is called immediately and
         * its result is passed to {@link #gatewayNetworkInterfaces(List<NetworkInterface>)}.
         * 
         * @param gatewayNetworkInterfaces
         *        a consumer that will call methods on {@link List<NetworkInterface>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewayNetworkInterfaces(List<NetworkInterface>)
         */
        Builder gatewayNetworkInterfaces(Consumer<NetworkInterface.Builder>... gatewayNetworkInterfaces);

        /**
         * <p>
         * The type of the gateway.
         * </p>
         * 
         * @param gatewayType
         *        The type of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayType(String gatewayType);

        /**
         * <p>
         * The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the
         * gateway is not available for an update this field is not returned in the response.
         * </p>
         * 
         * @param nextUpdateAvailabilityDate
         *        The date on which an update to the gateway is available. This date is in the time zone of the gateway.
         *        If the gateway is not available for an update this field is not returned in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextUpdateAvailabilityDate(String nextUpdateAvailabilityDate);

        /**
         * <p>
         * The date on which the last software update was applied to the gateway. If the gateway has never been updated,
         * this field does not return a value in the response.
         * </p>
         * 
         * @param lastSoftwareUpdate
         *        The date on which the last software update was applied to the gateway. If the gateway has never been
         *        updated, this field does not return a value in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSoftwareUpdate(String lastSoftwareUpdate);

        /**
         * <p>
         * The ID of the Amazon EC2 instance that was used to launch the gateway.
         * </p>
         * 
         * @param ec2InstanceId
         *        The ID of the Amazon EC2 instance that was used to launch the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceId(String ec2InstanceId);

        /**
         * <p>
         * The AWS Region where the Amazon EC2 instance is located.
         * </p>
         * 
         * @param ec2InstanceRegion
         *        The AWS Region where the Amazon EC2 instance is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceRegion(String ec2InstanceRegion);

        /**
         * <p>
         * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value
         * pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         * <code>ListTagsForResource</code> API operation.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a
         *        key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         *        <code>ListTagsForResource</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value
         * pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         * <code>ListTagsForResource</code> API operation.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a
         *        key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         *        <code>ListTagsForResource</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value
         * pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         * <code>ListTagsForResource</code> API operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
         * </p>
         * 
         * @param vpcEndpoint
         *        The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpoint(String vpcEndpoint);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch Log Group that is used to monitor events in the
         * gateway.
         * </p>
         * 
         * @param cloudWatchLogGroupARN
         *        The Amazon Resource Name (ARN) of the Amazon CloudWatch Log Group that is used to monitor events in
         *        the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupARN(String cloudWatchLogGroupARN);

        /**
         * <p>
         * The type of hypervisor environment used by the host.
         * </p>
         * 
         * @param hostEnvironment
         *        The type of hypervisor environment used by the host.
         * @see HostEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostEnvironment
         */
        Builder hostEnvironment(String hostEnvironment);

        /**
         * <p>
         * The type of hypervisor environment used by the host.
         * </p>
         * 
         * @param hostEnvironment
         *        The type of hypervisor environment used by the host.
         * @see HostEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostEnvironment
         */
        Builder hostEnvironment(HostEnvironment hostEnvironment);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private String gatewayId;

        private String gatewayName;

        private String gatewayTimezone;

        private String gatewayState;

        private List<NetworkInterface> gatewayNetworkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private String gatewayType;

        private String nextUpdateAvailabilityDate;

        private String lastSoftwareUpdate;

        private String ec2InstanceId;

        private String ec2InstanceRegion;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String vpcEndpoint;

        private String cloudWatchLogGroupARN;

        private String hostEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayInformationResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            gatewayId(model.gatewayId);
            gatewayName(model.gatewayName);
            gatewayTimezone(model.gatewayTimezone);
            gatewayState(model.gatewayState);
            gatewayNetworkInterfaces(model.gatewayNetworkInterfaces);
            gatewayType(model.gatewayType);
            nextUpdateAvailabilityDate(model.nextUpdateAvailabilityDate);
            lastSoftwareUpdate(model.lastSoftwareUpdate);
            ec2InstanceId(model.ec2InstanceId);
            ec2InstanceRegion(model.ec2InstanceRegion);
            tags(model.tags);
            vpcEndpoint(model.vpcEndpoint);
            cloudWatchLogGroupARN(model.cloudWatchLogGroupARN);
            hostEnvironment(model.hostEnvironment);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getGatewayName() {
            return gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        public final String getGatewayTimezone() {
            return gatewayTimezone;
        }

        @Override
        public final Builder gatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
            return this;
        }

        public final void setGatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
        }

        public final String getGatewayState() {
            return gatewayState;
        }

        @Override
        public final Builder gatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
            return this;
        }

        public final void setGatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
        }

        public final Collection<NetworkInterface.Builder> getGatewayNetworkInterfaces() {
            return gatewayNetworkInterfaces != null ? gatewayNetworkInterfaces.stream().map(NetworkInterface::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gatewayNetworkInterfaces(Collection<NetworkInterface> gatewayNetworkInterfaces) {
            this.gatewayNetworkInterfaces = GatewayNetworkInterfacesCopier.copy(gatewayNetworkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayNetworkInterfaces(NetworkInterface... gatewayNetworkInterfaces) {
            gatewayNetworkInterfaces(Arrays.asList(gatewayNetworkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayNetworkInterfaces(Consumer<NetworkInterface.Builder>... gatewayNetworkInterfaces) {
            gatewayNetworkInterfaces(Stream.of(gatewayNetworkInterfaces)
                    .map(c -> NetworkInterface.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGatewayNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> gatewayNetworkInterfaces) {
            this.gatewayNetworkInterfaces = GatewayNetworkInterfacesCopier.copyFromBuilder(gatewayNetworkInterfaces);
        }

        public final String getGatewayType() {
            return gatewayType;
        }

        @Override
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        public final String getNextUpdateAvailabilityDate() {
            return nextUpdateAvailabilityDate;
        }

        @Override
        public final Builder nextUpdateAvailabilityDate(String nextUpdateAvailabilityDate) {
            this.nextUpdateAvailabilityDate = nextUpdateAvailabilityDate;
            return this;
        }

        public final void setNextUpdateAvailabilityDate(String nextUpdateAvailabilityDate) {
            this.nextUpdateAvailabilityDate = nextUpdateAvailabilityDate;
        }

        public final String getLastSoftwareUpdate() {
            return lastSoftwareUpdate;
        }

        @Override
        public final Builder lastSoftwareUpdate(String lastSoftwareUpdate) {
            this.lastSoftwareUpdate = lastSoftwareUpdate;
            return this;
        }

        public final void setLastSoftwareUpdate(String lastSoftwareUpdate) {
            this.lastSoftwareUpdate = lastSoftwareUpdate;
        }

        public final String getEc2InstanceId() {
            return ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final String getEc2InstanceRegion() {
            return ec2InstanceRegion;
        }

        @Override
        public final Builder ec2InstanceRegion(String ec2InstanceRegion) {
            this.ec2InstanceRegion = ec2InstanceRegion;
            return this;
        }

        public final void setEc2InstanceRegion(String ec2InstanceRegion) {
            this.ec2InstanceRegion = ec2InstanceRegion;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getVpcEndpoint() {
            return vpcEndpoint;
        }

        @Override
        public final Builder vpcEndpoint(String vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
            return this;
        }

        public final void setVpcEndpoint(String vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
        }

        public final String getCloudWatchLogGroupARN() {
            return cloudWatchLogGroupARN;
        }

        @Override
        public final Builder cloudWatchLogGroupARN(String cloudWatchLogGroupARN) {
            this.cloudWatchLogGroupARN = cloudWatchLogGroupARN;
            return this;
        }

        public final void setCloudWatchLogGroupARN(String cloudWatchLogGroupARN) {
            this.cloudWatchLogGroupARN = cloudWatchLogGroupARN;
        }

        public final String getHostEnvironmentAsString() {
            return hostEnvironment;
        }

        @Override
        public final Builder hostEnvironment(String hostEnvironment) {
            this.hostEnvironment = hostEnvironment;
            return this;
        }

        @Override
        public final Builder hostEnvironment(HostEnvironment hostEnvironment) {
            this.hostEnvironment(hostEnvironment == null ? null : hostEnvironment.toString());
            return this;
        }

        public final void setHostEnvironment(String hostEnvironment) {
            this.hostEnvironment = hostEnvironment;
        }

        @Override
        public DescribeGatewayInformationResponse build() {
            return new DescribeGatewayInformationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
