/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object that contains one or more of the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>ListTapesInput$Limit</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListTapesInput$Marker</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListTapesInput$TapeARNs</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTapesRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<ListTapesRequest.Builder, ListTapesRequest> {
    private static final SdkField<List<String>> TAPE_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListTapesRequest::tapeARNs))
            .setter(setter(Builder::tapeARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTapesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListTapesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_AR_NS_FIELD,
            MARKER_FIELD, LIMIT_FIELD));

    private final List<String> tapeARNs;

    private final String marker;

    private final Integer limit;

    private ListTapesRequest(BuilderImpl builder) {
        super(builder);
        this.tapeARNs = builder.tapeARNs;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    /**
     * Returns the value of the TapeARNs property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the TapeARNs property for this object.
     */
    public List<String> tapeARNs() {
        return tapeARNs;
    }

    /**
     * <p>
     * A string that indicates the position at which to begin the returned list of tapes.
     * </p>
     * 
     * @return A string that indicates the position at which to begin the returned list of tapes.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * An optional number limit for the tapes in the list returned by this call.
     * </p>
     * 
     * @return An optional number limit for the tapes in the list returned by this call.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tapeARNs());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTapesRequest)) {
            return false;
        }
        ListTapesRequest other = (ListTapesRequest) obj;
        return Objects.equals(tapeARNs(), other.tapeARNs()) && Objects.equals(marker(), other.marker())
                && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTapesRequest").add("TapeARNs", tapeARNs()).add("Marker", marker()).add("Limit", limit())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeARNs":
            return Optional.ofNullable(clazz.cast(tapeARNs()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTapesRequest, T> g) {
        return obj -> g.apply((ListTapesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTapesRequest> {
        /**
         * Sets the value of the TapeARNs property for this object.
         *
         * @param tapeARNs
         *        The new value for the TapeARNs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARNs(Collection<String> tapeARNs);

        /**
         * Sets the value of the TapeARNs property for this object.
         *
         * @param tapeARNs
         *        The new value for the TapeARNs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARNs(String... tapeARNs);

        /**
         * <p>
         * A string that indicates the position at which to begin the returned list of tapes.
         * </p>
         * 
         * @param marker
         *        A string that indicates the position at which to begin the returned list of tapes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * An optional number limit for the tapes in the list returned by this call.
         * </p>
         * 
         * @param limit
         *        An optional number limit for the tapes in the list returned by this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private List<String> tapeARNs = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTapesRequest model) {
            super(model);
            tapeARNs(model.tapeARNs);
            marker(model.marker);
            limit(model.limit);
        }

        public final Collection<String> getTapeARNs() {
            return tapeARNs;
        }

        @Override
        public final Builder tapeARNs(Collection<String> tapeARNs) {
            this.tapeARNs = TapeARNsCopier.copy(tapeARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeARNs(String... tapeARNs) {
            tapeARNs(Arrays.asList(tapeARNs));
            return this;
        }

        public final void setTapeARNs(Collection<String> tapeARNs) {
            this.tapeARNs = TapeARNsCopier.copy(tapeARNs);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTapesRequest build() {
            return new ListTapesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
