/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a storage volume object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeInfo implements SdkPojo, Serializable, ToCopyableBuilder<VolumeInfo.Builder, VolumeInfo> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeInfo::volumeARN)).setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeInfo::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeInfo::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeInfo::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeInfo::volumeType)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final SdkField<Long> VOLUME_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(VolumeInfo::volumeSizeInBytes)).setter(setter(Builder::volumeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInBytes").build()).build();

    private static final SdkField<String> VOLUME_ATTACHMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeInfo::volumeAttachmentStatus)).setter(setter(Builder::volumeAttachmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeAttachmentStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD,
            VOLUME_ID_FIELD, GATEWAY_ARN_FIELD, GATEWAY_ID_FIELD, VOLUME_TYPE_FIELD, VOLUME_SIZE_IN_BYTES_FIELD,
            VOLUME_ATTACHMENT_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String volumeARN;

    private final String volumeId;

    private final String gatewayARN;

    private final String gatewayId;

    private final String volumeType;

    private final Long volumeSizeInBytes;

    private final String volumeAttachmentStatus;

    private VolumeInfo(BuilderImpl builder) {
        this.volumeARN = builder.volumeARN;
        this.volumeId = builder.volumeId;
        this.gatewayARN = builder.gatewayARN;
        this.gatewayId = builder.gatewayId;
        this.volumeType = builder.volumeType;
        this.volumeSizeInBytes = builder.volumeSizeInBytes;
        this.volumeAttachmentStatus = builder.volumeAttachmentStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the storage volume. For example, the following is a valid ARN:
     * </p>
     * <p>
     * <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB</code>
     * </p>
     * <p>
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the storage volume. For example, the following is a valid ARN:</p>
     *         <p>
     *         <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB</code>
     *         </p>
     *         <p>
     *         Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    public String volumeARN() {
        return volumeARN;
    }

    /**
     * <p>
     * The unique identifier assigned to the volume. This ID becomes part of the volume Amazon Resource Name (ARN),
     * which you use as input for other operations.
     * </p>
     * <p>
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     * </p>
     * 
     * @return The unique identifier assigned to the volume. This ID becomes part of the volume Amazon Resource Name
     *         (ARN), which you use as input for other operations.</p>
     *         <p>
     *         Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
     * Resource Name (ARN), which you use as input for other operations.
     * </p>
     * <p>
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     * </p>
     * 
     * @return The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway
     *         Amazon Resource Name (ARN), which you use as input for other operations.</p>
     *         <p>
     *         Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    public String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * One of the VolumeType enumeration values describing the type of the volume.
     * </p>
     * 
     * @return One of the VolumeType enumeration values describing the type of the volume.
     */
    public String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * The size of the volume in bytes.
     * </p>
     * <p>
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     * </p>
     * 
     * @return The size of the volume in bytes.</p>
     *         <p>
     *         Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    public Long volumeSizeInBytes() {
        return volumeSizeInBytes;
    }

    /**
     * <p>
     * One of the VolumeStatus values that indicates the state of the storage volume.
     * </p>
     * 
     * @return One of the VolumeStatus values that indicates the state of the storage volume.
     */
    public String volumeAttachmentStatus() {
        return volumeAttachmentStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(volumeAttachmentStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeInfo)) {
            return false;
        }
        VolumeInfo other = (VolumeInfo) obj;
        return Objects.equals(volumeARN(), other.volumeARN()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(gatewayId(), other.gatewayId())
                && Objects.equals(volumeType(), other.volumeType())
                && Objects.equals(volumeSizeInBytes(), other.volumeSizeInBytes())
                && Objects.equals(volumeAttachmentStatus(), other.volumeAttachmentStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VolumeInfo").add("VolumeARN", volumeARN()).add("VolumeId", volumeId())
                .add("GatewayARN", gatewayARN()).add("GatewayId", gatewayId()).add("VolumeType", volumeType())
                .add("VolumeSizeInBytes", volumeSizeInBytes()).add("VolumeAttachmentStatus", volumeAttachmentStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeType()));
        case "VolumeSizeInBytes":
            return Optional.ofNullable(clazz.cast(volumeSizeInBytes()));
        case "VolumeAttachmentStatus":
            return Optional.ofNullable(clazz.cast(volumeAttachmentStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeInfo, T> g) {
        return obj -> g.apply((VolumeInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeInfo> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the storage volume. For example, the following is a valid ARN:
         * </p>
         * <p>
         * <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB</code>
         * </p>
         * <p>
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         * </p>
         * 
         * @param volumeARN
         *        The Amazon Resource Name (ARN) for the storage volume. For example, the following is a valid ARN:</p>
         *        <p>
         *        <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB</code>
         *        </p>
         *        <p>
         *        Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);

        /**
         * <p>
         * The unique identifier assigned to the volume. This ID becomes part of the volume Amazon Resource Name (ARN),
         * which you use as input for other operations.
         * </p>
         * <p>
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         * </p>
         * 
         * @param volumeId
         *        The unique identifier assigned to the volume. This ID becomes part of the volume Amazon Resource Name
         *        (ARN), which you use as input for other operations.</p>
         *        <p>
         *        Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
         * Resource Name (ARN), which you use as input for other operations.
         * </p>
         * <p>
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway
         *        Amazon Resource Name (ARN), which you use as input for other operations.</p>
         *        <p>
         *        Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * One of the VolumeType enumeration values describing the type of the volume.
         * </p>
         * 
         * @param volumeType
         *        One of the VolumeType enumeration values describing the type of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The size of the volume in bytes.
         * </p>
         * <p>
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         * </p>
         * 
         * @param volumeSizeInBytes
         *        The size of the volume in bytes.</p>
         *        <p>
         *        Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInBytes(Long volumeSizeInBytes);

        /**
         * <p>
         * One of the VolumeStatus values that indicates the state of the storage volume.
         * </p>
         * 
         * @param volumeAttachmentStatus
         *        One of the VolumeStatus values that indicates the state of the storage volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeAttachmentStatus(String volumeAttachmentStatus);
    }

    static final class BuilderImpl implements Builder {
        private String volumeARN;

        private String volumeId;

        private String gatewayARN;

        private String gatewayId;

        private String volumeType;

        private Long volumeSizeInBytes;

        private String volumeAttachmentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeInfo model) {
            volumeARN(model.volumeARN);
            volumeId(model.volumeId);
            gatewayARN(model.gatewayARN);
            gatewayId(model.gatewayId);
            volumeType(model.volumeType);
            volumeSizeInBytes(model.volumeSizeInBytes);
            volumeAttachmentStatus(model.volumeAttachmentStatus);
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Long getVolumeSizeInBytes() {
            return volumeSizeInBytes;
        }

        @Override
        public final Builder volumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
            return this;
        }

        public final void setVolumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
        }

        public final String getVolumeAttachmentStatus() {
            return volumeAttachmentStatus;
        }

        @Override
        public final Builder volumeAttachmentStatus(String volumeAttachmentStatus) {
            this.volumeAttachmentStatus = volumeAttachmentStatus;
            return this;
        }

        public final void setVolumeAttachmentStatus(String volumeAttachmentStatus) {
            this.volumeAttachmentStatus = volumeAttachmentStatus;
        }

        @Override
        public VolumeInfo build() {
            return new VolumeInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
