/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ListFileShareInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFileSharesRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<ListFileSharesRequest.Builder, ListFileSharesRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFileSharesRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListFileSharesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFileSharesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            LIMIT_FIELD, MARKER_FIELD));

    private final String gatewayARN;

    private final Integer limit;

    private final String marker;

    private ListFileSharesRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.limit = builder.limit;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The Amazon resource Name (ARN) of the gateway whose file shares you want to list. If this field is not present,
     * all file shares under your account are listed.
     * </p>
     * 
     * @return The Amazon resource Name (ARN) of the gateway whose file shares you want to list. If this field is not
     *         present, all file shares under your account are listed.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The maximum number of file shares to return in the response. The value must be an integer with a value greater
     * than zero. Optional.
     * </p>
     * 
     * @return The maximum number of file shares to return in the response. The value must be an integer with a value
     *         greater than zero. Optional.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Opaque pagination token returned from a previous ListFileShares operation. If present, <code>Marker</code>
     * specifies where to continue the list from after a previous call to ListFileShares. Optional.
     * </p>
     * 
     * @return Opaque pagination token returned from a previous ListFileShares operation. If present,
     *         <code>Marker</code> specifies where to continue the list from after a previous call to ListFileShares.
     *         Optional.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFileSharesRequest)) {
            return false;
        }
        ListFileSharesRequest other = (ListFileSharesRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(limit(), other.limit())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFileSharesRequest").add("GatewayARN", gatewayARN()).add("Limit", limit())
                .add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFileSharesRequest, T> g) {
        return obj -> g.apply((ListFileSharesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFileSharesRequest> {
        /**
         * <p>
         * The Amazon resource Name (ARN) of the gateway whose file shares you want to list. If this field is not
         * present, all file shares under your account are listed.
         * </p>
         * 
         * @param gatewayARN
         *        The Amazon resource Name (ARN) of the gateway whose file shares you want to list. If this field is not
         *        present, all file shares under your account are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The maximum number of file shares to return in the response. The value must be an integer with a value
         * greater than zero. Optional.
         * </p>
         * 
         * @param limit
         *        The maximum number of file shares to return in the response. The value must be an integer with a value
         *        greater than zero. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Opaque pagination token returned from a previous ListFileShares operation. If present, <code>Marker</code>
         * specifies where to continue the list from after a previous call to ListFileShares. Optional.
         * </p>
         * 
         * @param marker
         *        Opaque pagination token returned from a previous ListFileShares operation. If present,
         *        <code>Marker</code> specifies where to continue the list from after a previous call to ListFileShares.
         *        Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private Integer limit;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFileSharesRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            limit(model.limit);
            marker(model.marker);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFileSharesRequest build() {
            return new ListFileSharesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
