/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChapInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChapInfo> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ChapInfo.getter(ChapInfo::targetARN)).setter(ChapInfo.setter(Builder::targetARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetARN").build()}).build();
    private static final SdkField<String> SECRET_TO_AUTHENTICATE_INITIATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ChapInfo.getter(ChapInfo::secretToAuthenticateInitiator)).setter(ChapInfo.setter(Builder::secretToAuthenticateInitiator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretToAuthenticateInitiator").build()}).build();
    private static final SdkField<String> INITIATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ChapInfo.getter(ChapInfo::initiatorName)).setter(ChapInfo.setter(Builder::initiatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatorName").build()}).build();
    private static final SdkField<String> SECRET_TO_AUTHENTICATE_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ChapInfo.getter(ChapInfo::secretToAuthenticateTarget)).setter(ChapInfo.setter(Builder::secretToAuthenticateTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretToAuthenticateTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD, SECRET_TO_AUTHENTICATE_INITIATOR_FIELD, INITIATOR_NAME_FIELD, SECRET_TO_AUTHENTICATE_TARGET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String targetARN;
    private final String secretToAuthenticateInitiator;
    private final String initiatorName;
    private final String secretToAuthenticateTarget;

    private ChapInfo(BuilderImpl builder) {
        this.targetARN = builder.targetARN;
        this.secretToAuthenticateInitiator = builder.secretToAuthenticateInitiator;
        this.initiatorName = builder.initiatorName;
        this.secretToAuthenticateTarget = builder.secretToAuthenticateTarget;
    }

    public String targetARN() {
        return this.targetARN;
    }

    public String secretToAuthenticateInitiator() {
        return this.secretToAuthenticateInitiator;
    }

    public String initiatorName() {
        return this.initiatorName;
    }

    public String secretToAuthenticateTarget() {
        return this.secretToAuthenticateTarget;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretToAuthenticateInitiator());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretToAuthenticateTarget());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChapInfo)) {
            return false;
        }
        ChapInfo other = (ChapInfo)obj;
        return Objects.equals(this.targetARN(), other.targetARN()) && Objects.equals(this.secretToAuthenticateInitiator(), other.secretToAuthenticateInitiator()) && Objects.equals(this.initiatorName(), other.initiatorName()) && Objects.equals(this.secretToAuthenticateTarget(), other.secretToAuthenticateTarget());
    }

    public String toString() {
        return ToString.builder((String)"ChapInfo").add("TargetARN", (Object)this.targetARN()).add("SecretToAuthenticateInitiator", (Object)(this.secretToAuthenticateInitiator() == null ? null : "*** Sensitive Data Redacted ***")).add("InitiatorName", (Object)this.initiatorName()).add("SecretToAuthenticateTarget", (Object)(this.secretToAuthenticateTarget() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetARN": {
                return Optional.ofNullable(clazz.cast(this.targetARN()));
            }
            case "SecretToAuthenticateInitiator": {
                return Optional.ofNullable(clazz.cast(this.secretToAuthenticateInitiator()));
            }
            case "InitiatorName": {
                return Optional.ofNullable(clazz.cast(this.initiatorName()));
            }
            case "SecretToAuthenticateTarget": {
                return Optional.ofNullable(clazz.cast(this.secretToAuthenticateTarget()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChapInfo, T> g) {
        return obj -> g.apply((ChapInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetARN;
        private String secretToAuthenticateInitiator;
        private String initiatorName;
        private String secretToAuthenticateTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(ChapInfo model) {
            this.targetARN(model.targetARN);
            this.secretToAuthenticateInitiator(model.secretToAuthenticateInitiator);
            this.initiatorName(model.initiatorName);
            this.secretToAuthenticateTarget(model.secretToAuthenticateTarget);
        }

        public final String getTargetARN() {
            return this.targetARN;
        }

        @Override
        public final Builder targetARN(String targetARN) {
            this.targetARN = targetARN;
            return this;
        }

        public final void setTargetARN(String targetARN) {
            this.targetARN = targetARN;
        }

        public final String getSecretToAuthenticateInitiator() {
            return this.secretToAuthenticateInitiator;
        }

        @Override
        public final Builder secretToAuthenticateInitiator(String secretToAuthenticateInitiator) {
            this.secretToAuthenticateInitiator = secretToAuthenticateInitiator;
            return this;
        }

        public final void setSecretToAuthenticateInitiator(String secretToAuthenticateInitiator) {
            this.secretToAuthenticateInitiator = secretToAuthenticateInitiator;
        }

        public final String getInitiatorName() {
            return this.initiatorName;
        }

        @Override
        public final Builder initiatorName(String initiatorName) {
            this.initiatorName = initiatorName;
            return this;
        }

        public final void setInitiatorName(String initiatorName) {
            this.initiatorName = initiatorName;
        }

        public final String getSecretToAuthenticateTarget() {
            return this.secretToAuthenticateTarget;
        }

        @Override
        public final Builder secretToAuthenticateTarget(String secretToAuthenticateTarget) {
            this.secretToAuthenticateTarget = secretToAuthenticateTarget;
            return this;
        }

        public final void setSecretToAuthenticateTarget(String secretToAuthenticateTarget) {
            this.secretToAuthenticateTarget = secretToAuthenticateTarget;
        }

        public ChapInfo build() {
            return new ChapInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChapInfo> {
        public Builder targetARN(String var1);

        public Builder secretToAuthenticateInitiator(String var1);

        public Builder initiatorName(String var1);

        public Builder secretToAuthenticateTarget(String var1);
    }
}

