/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomaticTapeCreationRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomaticTapeCreationRule> {
    private static final SdkField<String> TAPE_BARCODE_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomaticTapeCreationRule.getter(AutomaticTapeCreationRule::tapeBarcodePrefix)).setter(AutomaticTapeCreationRule.setter(Builder::tapeBarcodePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcodePrefix").build()}).build();
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomaticTapeCreationRule.getter(AutomaticTapeCreationRule::poolId)).setter(AutomaticTapeCreationRule.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(AutomaticTapeCreationRule.getter(AutomaticTapeCreationRule::tapeSizeInBytes)).setter(AutomaticTapeCreationRule.setter(Builder::tapeSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()}).build();
    private static final SdkField<Integer> MINIMUM_NUM_TAPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AutomaticTapeCreationRule.getter(AutomaticTapeCreationRule::minimumNumTapes)).setter(AutomaticTapeCreationRule.setter(Builder::minimumNumTapes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumNumTapes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_BARCODE_PREFIX_FIELD, POOL_ID_FIELD, TAPE_SIZE_IN_BYTES_FIELD, MINIMUM_NUM_TAPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tapeBarcodePrefix;
    private final String poolId;
    private final Long tapeSizeInBytes;
    private final Integer minimumNumTapes;

    private AutomaticTapeCreationRule(BuilderImpl builder) {
        this.tapeBarcodePrefix = builder.tapeBarcodePrefix;
        this.poolId = builder.poolId;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.minimumNumTapes = builder.minimumNumTapes;
    }

    public String tapeBarcodePrefix() {
        return this.tapeBarcodePrefix;
    }

    public String poolId() {
        return this.poolId;
    }

    public Long tapeSizeInBytes() {
        return this.tapeSizeInBytes;
    }

    public Integer minimumNumTapes() {
        return this.minimumNumTapes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeBarcodePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumNumTapes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomaticTapeCreationRule)) {
            return false;
        }
        AutomaticTapeCreationRule other = (AutomaticTapeCreationRule)obj;
        return Objects.equals(this.tapeBarcodePrefix(), other.tapeBarcodePrefix()) && Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.tapeSizeInBytes(), other.tapeSizeInBytes()) && Objects.equals(this.minimumNumTapes(), other.minimumNumTapes());
    }

    public String toString() {
        return ToString.builder((String)"AutomaticTapeCreationRule").add("TapeBarcodePrefix", (Object)this.tapeBarcodePrefix()).add("PoolId", (Object)this.poolId()).add("TapeSizeInBytes", (Object)this.tapeSizeInBytes()).add("MinimumNumTapes", (Object)this.minimumNumTapes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TapeBarcodePrefix": {
                return Optional.ofNullable(clazz.cast(this.tapeBarcodePrefix()));
            }
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "TapeSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.tapeSizeInBytes()));
            }
            case "MinimumNumTapes": {
                return Optional.ofNullable(clazz.cast(this.minimumNumTapes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomaticTapeCreationRule, T> g) {
        return obj -> g.apply((AutomaticTapeCreationRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tapeBarcodePrefix;
        private String poolId;
        private Long tapeSizeInBytes;
        private Integer minimumNumTapes;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomaticTapeCreationRule model) {
            this.tapeBarcodePrefix(model.tapeBarcodePrefix);
            this.poolId(model.poolId);
            this.tapeSizeInBytes(model.tapeSizeInBytes);
            this.minimumNumTapes(model.minimumNumTapes);
        }

        public final String getTapeBarcodePrefix() {
            return this.tapeBarcodePrefix;
        }

        @Override
        public final Builder tapeBarcodePrefix(String tapeBarcodePrefix) {
            this.tapeBarcodePrefix = tapeBarcodePrefix;
            return this;
        }

        public final void setTapeBarcodePrefix(String tapeBarcodePrefix) {
            this.tapeBarcodePrefix = tapeBarcodePrefix;
        }

        public final String getPoolId() {
            return this.poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        public final Long getTapeSizeInBytes() {
            return this.tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        public final Integer getMinimumNumTapes() {
            return this.minimumNumTapes;
        }

        @Override
        public final Builder minimumNumTapes(Integer minimumNumTapes) {
            this.minimumNumTapes = minimumNumTapes;
            return this;
        }

        public final void setMinimumNumTapes(Integer minimumNumTapes) {
            this.minimumNumTapes = minimumNumTapes;
        }

        public AutomaticTapeCreationRule build() {
            return new AutomaticTapeCreationRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomaticTapeCreationRule> {
        public Builder tapeBarcodePrefix(String var1);

        public Builder poolId(String var1);

        public Builder tapeSizeInBytes(Long var1);

        public Builder minimumNumTapes(Integer var1);
    }
}

