/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.VolumeARNsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStorediScsiVolumesRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, DescribeStorediScsiVolumesRequest> {
    private static final SdkField<List<String>> VOLUME_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeStorediScsiVolumesRequest.getter(DescribeStorediScsiVolumesRequest::volumeARNs)).setter(DescribeStorediScsiVolumesRequest.setter(Builder::volumeARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_AR_NS_FIELD));
    private final List<String> volumeARNs;

    private DescribeStorediScsiVolumesRequest(BuilderImpl builder) {
        super(builder);
        this.volumeARNs = builder.volumeARNs;
    }

    public boolean hasVolumeARNs() {
        return this.volumeARNs != null && !(this.volumeARNs instanceof SdkAutoConstructList);
    }

    public List<String> volumeARNs() {
        return this.volumeARNs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeARNs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorediScsiVolumesRequest)) {
            return false;
        }
        DescribeStorediScsiVolumesRequest other = (DescribeStorediScsiVolumesRequest)((Object)obj);
        return Objects.equals(this.volumeARNs(), other.volumeARNs());
    }

    public String toString() {
        return ToString.builder((String)"DescribeStorediScsiVolumesRequest").add("VolumeARNs", this.volumeARNs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeARNs": {
                return Optional.ofNullable(clazz.cast(this.volumeARNs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorediScsiVolumesRequest, T> g) {
        return obj -> g.apply((DescribeStorediScsiVolumesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private List<String> volumeARNs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorediScsiVolumesRequest model) {
            super(model);
            this.volumeARNs(model.volumeARNs);
        }

        public final Collection<String> getVolumeARNs() {
            return this.volumeARNs;
        }

        @Override
        public final Builder volumeARNs(Collection<String> volumeARNs) {
            this.volumeARNs = VolumeARNsCopier.copy(volumeARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeARNs(String ... volumeARNs) {
            this.volumeARNs(Arrays.asList(volumeARNs));
            return this;
        }

        public final void setVolumeARNs(Collection<String> volumeARNs) {
            this.volumeARNs = VolumeARNsCopier.copy(volumeARNs);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStorediScsiVolumesRequest build() {
            return new DescribeStorediScsiVolumesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStorediScsiVolumesRequest> {
        public Builder volumeARNs(Collection<String> var1);

        public Builder volumeARNs(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

