/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSmbSecurityStrategyRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, UpdateSmbSecurityStrategyRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSmbSecurityStrategyRequest.getter(UpdateSmbSecurityStrategyRequest::gatewayARN)).setter(UpdateSmbSecurityStrategyRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> SMB_SECURITY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSmbSecurityStrategyRequest.getter(UpdateSmbSecurityStrategyRequest::smbSecurityStrategyAsString)).setter(UpdateSmbSecurityStrategyRequest.setter(Builder::smbSecurityStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBSecurityStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, SMB_SECURITY_STRATEGY_FIELD));
    private final String gatewayARN;
    private final String smbSecurityStrategy;

    private UpdateSmbSecurityStrategyRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.smbSecurityStrategy = builder.smbSecurityStrategy;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public SMBSecurityStrategy smbSecurityStrategy() {
        return SMBSecurityStrategy.fromValue(this.smbSecurityStrategy);
    }

    public String smbSecurityStrategyAsString() {
        return this.smbSecurityStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.smbSecurityStrategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSmbSecurityStrategyRequest)) {
            return false;
        }
        UpdateSmbSecurityStrategyRequest other = (UpdateSmbSecurityStrategyRequest)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.smbSecurityStrategyAsString(), other.smbSecurityStrategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSmbSecurityStrategyRequest").add("GatewayARN", (Object)this.gatewayARN()).add("SMBSecurityStrategy", (Object)this.smbSecurityStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "SMBSecurityStrategy": {
                return Optional.ofNullable(clazz.cast(this.smbSecurityStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSmbSecurityStrategyRequest, T> g) {
        return obj -> g.apply((UpdateSmbSecurityStrategyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private String smbSecurityStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSmbSecurityStrategyRequest model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.smbSecurityStrategy(model.smbSecurityStrategy);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getSmbSecurityStrategy() {
            return this.smbSecurityStrategy;
        }

        @Override
        public final Builder smbSecurityStrategy(String smbSecurityStrategy) {
            this.smbSecurityStrategy = smbSecurityStrategy;
            return this;
        }

        @Override
        public final Builder smbSecurityStrategy(SMBSecurityStrategy smbSecurityStrategy) {
            this.smbSecurityStrategy(smbSecurityStrategy == null ? null : smbSecurityStrategy.toString());
            return this;
        }

        public final void setSmbSecurityStrategy(String smbSecurityStrategy) {
            this.smbSecurityStrategy = smbSecurityStrategy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSmbSecurityStrategyRequest build() {
            return new UpdateSmbSecurityStrategyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSmbSecurityStrategyRequest> {
        public Builder gatewayARN(String var1);

        public Builder smbSecurityStrategy(String var1);

        public Builder smbSecurityStrategy(SMBSecurityStrategy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

