/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.Disk;
import software.amazon.awssdk.services.storagegateway.model.DisksCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLocalDisksResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, ListLocalDisksResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListLocalDisksResponse.getter(ListLocalDisksResponse::gatewayARN)).setter(ListLocalDisksResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<List<Disk>> DISKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListLocalDisksResponse.getter(ListLocalDisksResponse::disks)).setter(ListLocalDisksResponse.setter(Builder::disks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Disk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, DISKS_FIELD));
    private final String gatewayARN;
    private final List<Disk> disks;

    private ListLocalDisksResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.disks = builder.disks;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public boolean hasDisks() {
        return this.disks != null && !(this.disks instanceof SdkAutoConstructList);
    }

    public List<Disk> disks() {
        return this.disks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.disks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLocalDisksResponse)) {
            return false;
        }
        ListLocalDisksResponse other = (ListLocalDisksResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.disks(), other.disks());
    }

    public String toString() {
        return ToString.builder((String)"ListLocalDisksResponse").add("GatewayARN", (Object)this.gatewayARN()).add("Disks", this.disks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "Disks": {
                return Optional.ofNullable(clazz.cast(this.disks()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLocalDisksResponse, T> g) {
        return obj -> g.apply((ListLocalDisksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private List<Disk> disks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLocalDisksResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.disks(model.disks);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<Disk.Builder> getDisks() {
            return this.disks != null ? (Collection)this.disks.stream().map(Disk::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder disks(Collection<Disk> disks) {
            this.disks = DisksCopier.copy(disks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Disk ... disks) {
            this.disks(Arrays.asList(disks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Consumer<Disk.Builder> ... disks) {
            this.disks(Stream.of(disks).map(c -> (Disk)((Disk.Builder)Disk.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDisks(Collection<Disk.BuilderImpl> disks) {
            this.disks = DisksCopier.copyFromBuilder(disks);
        }

        @Override
        public ListLocalDisksResponse build() {
            return new ListLocalDisksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLocalDisksResponse> {
        public Builder gatewayARN(String var1);

        public Builder disks(Collection<Disk> var1);

        public Builder disks(Disk ... var1);

        public Builder disks(Consumer<Disk.Builder> ... var1);
    }
}

