/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Tape
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Tape> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Tape.getter(Tape::tapeARN)).setter(Tape.setter(Builder::tapeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()}).build();
    private static final SdkField<String> TAPE_BARCODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Tape.getter(Tape::tapeBarcode)).setter(Tape.setter(Builder::tapeBarcode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcode").build()}).build();
    private static final SdkField<Instant> TAPE_CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Tape.getter(Tape::tapeCreatedDate)).setter(Tape.setter(Builder::tapeCreatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeCreatedDate").build()}).build();
    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(Tape.getter(Tape::tapeSizeInBytes)).setter(Tape.setter(Builder::tapeSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()}).build();
    private static final SdkField<String> TAPE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Tape.getter(Tape::tapeStatus)).setter(Tape.setter(Builder::tapeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeStatus").build()}).build();
    private static final SdkField<String> VTL_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Tape.getter(Tape::vtlDevice)).setter(Tape.setter(Builder::vtlDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDevice").build()}).build();
    private static final SdkField<Double> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Tape.getter(Tape::progress)).setter(Tape.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").build()}).build();
    private static final SdkField<Long> TAPE_USED_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(Tape.getter(Tape::tapeUsedInBytes)).setter(Tape.setter(Builder::tapeUsedInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeUsedInBytes").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Tape.getter(Tape::kmsKey)).setter(Tape.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()}).build();
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Tape.getter(Tape::poolId)).setter(Tape.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD, TAPE_BARCODE_FIELD, TAPE_CREATED_DATE_FIELD, TAPE_SIZE_IN_BYTES_FIELD, TAPE_STATUS_FIELD, VTL_DEVICE_FIELD, PROGRESS_FIELD, TAPE_USED_IN_BYTES_FIELD, KMS_KEY_FIELD, POOL_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tapeARN;
    private final String tapeBarcode;
    private final Instant tapeCreatedDate;
    private final Long tapeSizeInBytes;
    private final String tapeStatus;
    private final String vtlDevice;
    private final Double progress;
    private final Long tapeUsedInBytes;
    private final String kmsKey;
    private final String poolId;

    private Tape(BuilderImpl builder) {
        this.tapeARN = builder.tapeARN;
        this.tapeBarcode = builder.tapeBarcode;
        this.tapeCreatedDate = builder.tapeCreatedDate;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.tapeStatus = builder.tapeStatus;
        this.vtlDevice = builder.vtlDevice;
        this.progress = builder.progress;
        this.tapeUsedInBytes = builder.tapeUsedInBytes;
        this.kmsKey = builder.kmsKey;
        this.poolId = builder.poolId;
    }

    public String tapeARN() {
        return this.tapeARN;
    }

    public String tapeBarcode() {
        return this.tapeBarcode;
    }

    public Instant tapeCreatedDate() {
        return this.tapeCreatedDate;
    }

    public Long tapeSizeInBytes() {
        return this.tapeSizeInBytes;
    }

    public String tapeStatus() {
        return this.tapeStatus;
    }

    public String vtlDevice() {
        return this.vtlDevice;
    }

    public Double progress() {
        return this.progress;
    }

    public Long tapeUsedInBytes() {
        return this.tapeUsedInBytes;
    }

    public String kmsKey() {
        return this.kmsKey;
    }

    public String poolId() {
        return this.poolId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeBarcode());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeCreatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.vtlDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeUsedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tape)) {
            return false;
        }
        Tape other = (Tape)obj;
        return Objects.equals(this.tapeARN(), other.tapeARN()) && Objects.equals(this.tapeBarcode(), other.tapeBarcode()) && Objects.equals(this.tapeCreatedDate(), other.tapeCreatedDate()) && Objects.equals(this.tapeSizeInBytes(), other.tapeSizeInBytes()) && Objects.equals(this.tapeStatus(), other.tapeStatus()) && Objects.equals(this.vtlDevice(), other.vtlDevice()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.tapeUsedInBytes(), other.tapeUsedInBytes()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.poolId(), other.poolId());
    }

    public String toString() {
        return ToString.builder((String)"Tape").add("TapeARN", (Object)this.tapeARN()).add("TapeBarcode", (Object)this.tapeBarcode()).add("TapeCreatedDate", (Object)this.tapeCreatedDate()).add("TapeSizeInBytes", (Object)this.tapeSizeInBytes()).add("TapeStatus", (Object)this.tapeStatus()).add("VTLDevice", (Object)this.vtlDevice()).add("Progress", (Object)this.progress()).add("TapeUsedInBytes", (Object)this.tapeUsedInBytes()).add("KMSKey", (Object)this.kmsKey()).add("PoolId", (Object)this.poolId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TapeARN": {
                return Optional.ofNullable(clazz.cast(this.tapeARN()));
            }
            case "TapeBarcode": {
                return Optional.ofNullable(clazz.cast(this.tapeBarcode()));
            }
            case "TapeCreatedDate": {
                return Optional.ofNullable(clazz.cast(this.tapeCreatedDate()));
            }
            case "TapeSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.tapeSizeInBytes()));
            }
            case "TapeStatus": {
                return Optional.ofNullable(clazz.cast(this.tapeStatus()));
            }
            case "VTLDevice": {
                return Optional.ofNullable(clazz.cast(this.vtlDevice()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "TapeUsedInBytes": {
                return Optional.ofNullable(clazz.cast(this.tapeUsedInBytes()));
            }
            case "KMSKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tape, T> g) {
        return obj -> g.apply((Tape)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tapeARN;
        private String tapeBarcode;
        private Instant tapeCreatedDate;
        private Long tapeSizeInBytes;
        private String tapeStatus;
        private String vtlDevice;
        private Double progress;
        private Long tapeUsedInBytes;
        private String kmsKey;
        private String poolId;

        private BuilderImpl() {
        }

        private BuilderImpl(Tape model) {
            this.tapeARN(model.tapeARN);
            this.tapeBarcode(model.tapeBarcode);
            this.tapeCreatedDate(model.tapeCreatedDate);
            this.tapeSizeInBytes(model.tapeSizeInBytes);
            this.tapeStatus(model.tapeStatus);
            this.vtlDevice(model.vtlDevice);
            this.progress(model.progress);
            this.tapeUsedInBytes(model.tapeUsedInBytes);
            this.kmsKey(model.kmsKey);
            this.poolId(model.poolId);
        }

        public final String getTapeARN() {
            return this.tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        public final String getTapeBarcode() {
            return this.tapeBarcode;
        }

        @Override
        public final Builder tapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
            return this;
        }

        public final void setTapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
        }

        public final Instant getTapeCreatedDate() {
            return this.tapeCreatedDate;
        }

        @Override
        public final Builder tapeCreatedDate(Instant tapeCreatedDate) {
            this.tapeCreatedDate = tapeCreatedDate;
            return this;
        }

        public final void setTapeCreatedDate(Instant tapeCreatedDate) {
            this.tapeCreatedDate = tapeCreatedDate;
        }

        public final Long getTapeSizeInBytes() {
            return this.tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        public final String getTapeStatus() {
            return this.tapeStatus;
        }

        @Override
        public final Builder tapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
            return this;
        }

        public final void setTapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
        }

        public final String getVtlDevice() {
            return this.vtlDevice;
        }

        @Override
        public final Builder vtlDevice(String vtlDevice) {
            this.vtlDevice = vtlDevice;
            return this;
        }

        public final void setVtlDevice(String vtlDevice) {
            this.vtlDevice = vtlDevice;
        }

        public final Double getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(Double progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(Double progress) {
            this.progress = progress;
        }

        public final Long getTapeUsedInBytes() {
            return this.tapeUsedInBytes;
        }

        @Override
        public final Builder tapeUsedInBytes(Long tapeUsedInBytes) {
            this.tapeUsedInBytes = tapeUsedInBytes;
            return this;
        }

        public final void setTapeUsedInBytes(Long tapeUsedInBytes) {
            this.tapeUsedInBytes = tapeUsedInBytes;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        public final String getPoolId() {
            return this.poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        public Tape build() {
            return new Tape(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Tape> {
        public Builder tapeARN(String var1);

        public Builder tapeBarcode(String var1);

        public Builder tapeCreatedDate(Instant var1);

        public Builder tapeSizeInBytes(Long var1);

        public Builder tapeStatus(String var1);

        public Builder vtlDevice(String var1);

        public Builder progress(Double var1);

        public Builder tapeUsedInBytes(Long var1);

        public Builder kmsKey(String var1);

        public Builder poolId(String var1);
    }
}

