/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.PoolInfo;
import software.amazon.awssdk.services.storagegateway.model.PoolInfosCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTapePoolsResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, ListTapePoolsResponse> {
    private static final SdkField<List<PoolInfo>> POOL_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListTapePoolsResponse.getter(ListTapePoolsResponse::poolInfos)).setter(ListTapePoolsResponse.setter(Builder::poolInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PoolInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTapePoolsResponse.getter(ListTapePoolsResponse::marker)).setter(ListTapePoolsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_INFOS_FIELD, MARKER_FIELD));
    private final List<PoolInfo> poolInfos;
    private final String marker;

    private ListTapePoolsResponse(BuilderImpl builder) {
        super(builder);
        this.poolInfos = builder.poolInfos;
        this.marker = builder.marker;
    }

    public boolean hasPoolInfos() {
        return this.poolInfos != null && !(this.poolInfos instanceof SdkAutoConstructList);
    }

    public List<PoolInfo> poolInfos() {
        return this.poolInfos;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.poolInfos());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTapePoolsResponse)) {
            return false;
        }
        ListTapePoolsResponse other = (ListTapePoolsResponse)((Object)obj);
        return Objects.equals(this.poolInfos(), other.poolInfos()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListTapePoolsResponse").add("PoolInfos", this.poolInfos()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolInfos": {
                return Optional.ofNullable(clazz.cast(this.poolInfos()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTapePoolsResponse, T> g) {
        return obj -> g.apply((ListTapePoolsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<PoolInfo> poolInfos = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTapePoolsResponse model) {
            super(model);
            this.poolInfos(model.poolInfos);
            this.marker(model.marker);
        }

        public final Collection<PoolInfo.Builder> getPoolInfos() {
            return this.poolInfos != null ? (Collection)this.poolInfos.stream().map(PoolInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder poolInfos(Collection<PoolInfo> poolInfos) {
            this.poolInfos = PoolInfosCopier.copy(poolInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolInfos(PoolInfo ... poolInfos) {
            this.poolInfos(Arrays.asList(poolInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolInfos(Consumer<PoolInfo.Builder> ... poolInfos) {
            this.poolInfos(Stream.of(poolInfos).map(c -> (PoolInfo)((PoolInfo.Builder)PoolInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPoolInfos(Collection<PoolInfo.BuilderImpl> poolInfos) {
            this.poolInfos = PoolInfosCopier.copyFromBuilder(poolInfos);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListTapePoolsResponse build() {
            return new ListTapePoolsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTapePoolsResponse> {
        public Builder poolInfos(Collection<PoolInfo> var1);

        public Builder poolInfos(PoolInfo ... var1);

        public Builder poolInfos(Consumer<PoolInfo.Builder> ... var1);

        public Builder marker(String var1);
    }
}

