/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssignTapePoolRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, AssignTapePoolRequest> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssignTapePoolRequest.getter(AssignTapePoolRequest::tapeARN)).setter(AssignTapePoolRequest.setter(Builder::tapeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()}).build();
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssignTapePoolRequest.getter(AssignTapePoolRequest::poolId)).setter(AssignTapePoolRequest.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<Boolean> BYPASS_GOVERNANCE_RETENTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AssignTapePoolRequest.getter(AssignTapePoolRequest::bypassGovernanceRetention)).setter(AssignTapePoolRequest.setter(Builder::bypassGovernanceRetention)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BypassGovernanceRetention").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD, POOL_ID_FIELD, BYPASS_GOVERNANCE_RETENTION_FIELD));
    private final String tapeARN;
    private final String poolId;
    private final Boolean bypassGovernanceRetention;

    private AssignTapePoolRequest(BuilderImpl builder) {
        super(builder);
        this.tapeARN = builder.tapeARN;
        this.poolId = builder.poolId;
        this.bypassGovernanceRetention = builder.bypassGovernanceRetention;
    }

    public String tapeARN() {
        return this.tapeARN;
    }

    public String poolId() {
        return this.poolId;
    }

    public Boolean bypassGovernanceRetention() {
        return this.bypassGovernanceRetention;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bypassGovernanceRetention());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignTapePoolRequest)) {
            return false;
        }
        AssignTapePoolRequest other = (AssignTapePoolRequest)((Object)obj);
        return Objects.equals(this.tapeARN(), other.tapeARN()) && Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.bypassGovernanceRetention(), other.bypassGovernanceRetention());
    }

    public String toString() {
        return ToString.builder((String)"AssignTapePoolRequest").add("TapeARN", (Object)this.tapeARN()).add("PoolId", (Object)this.poolId()).add("BypassGovernanceRetention", (Object)this.bypassGovernanceRetention()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TapeARN": {
                return Optional.ofNullable(clazz.cast(this.tapeARN()));
            }
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "BypassGovernanceRetention": {
                return Optional.ofNullable(clazz.cast(this.bypassGovernanceRetention()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssignTapePoolRequest, T> g) {
        return obj -> g.apply((AssignTapePoolRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String tapeARN;
        private String poolId;
        private Boolean bypassGovernanceRetention;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignTapePoolRequest model) {
            super(model);
            this.tapeARN(model.tapeARN);
            this.poolId(model.poolId);
            this.bypassGovernanceRetention(model.bypassGovernanceRetention);
        }

        public final String getTapeARN() {
            return this.tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        public final String getPoolId() {
            return this.poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        public final Boolean getBypassGovernanceRetention() {
            return this.bypassGovernanceRetention;
        }

        @Override
        public final Builder bypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
            return this;
        }

        public final void setBypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssignTapePoolRequest build() {
            return new AssignTapePoolRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssignTapePoolRequest> {
        public Builder tapeARN(String var1);

        public Builder poolId(String var1);

        public Builder bypassGovernanceRetention(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

