/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.NFSFileShareInfo;
import software.amazon.awssdk.services.storagegateway.model.NFSFileShareInfoListCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNfsFileSharesResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeNfsFileSharesResponse> {
    private static final SdkField<List<NFSFileShareInfo>> NFS_FILE_SHARE_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeNfsFileSharesResponse.getter(DescribeNfsFileSharesResponse::nfsFileShareInfoList)).setter(DescribeNfsFileSharesResponse.setter(Builder::nfsFileShareInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFSFileShareInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NFSFileShareInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NFS_FILE_SHARE_INFO_LIST_FIELD));
    private final List<NFSFileShareInfo> nfsFileShareInfoList;

    private DescribeNfsFileSharesResponse(BuilderImpl builder) {
        super(builder);
        this.nfsFileShareInfoList = builder.nfsFileShareInfoList;
    }

    public boolean hasNfsFileShareInfoList() {
        return this.nfsFileShareInfoList != null && !(this.nfsFileShareInfoList instanceof SdkAutoConstructList);
    }

    public List<NFSFileShareInfo> nfsFileShareInfoList() {
        return this.nfsFileShareInfoList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nfsFileShareInfoList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNfsFileSharesResponse)) {
            return false;
        }
        DescribeNfsFileSharesResponse other = (DescribeNfsFileSharesResponse)((Object)obj);
        return Objects.equals(this.nfsFileShareInfoList(), other.nfsFileShareInfoList());
    }

    public String toString() {
        return ToString.builder((String)"DescribeNfsFileSharesResponse").add("NFSFileShareInfoList", this.nfsFileShareInfoList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NFSFileShareInfoList": {
                return Optional.ofNullable(clazz.cast(this.nfsFileShareInfoList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNfsFileSharesResponse, T> g) {
        return obj -> g.apply((DescribeNfsFileSharesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<NFSFileShareInfo> nfsFileShareInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNfsFileSharesResponse model) {
            super(model);
            this.nfsFileShareInfoList(model.nfsFileShareInfoList);
        }

        public final Collection<NFSFileShareInfo.Builder> getNfsFileShareInfoList() {
            return this.nfsFileShareInfoList != null ? (Collection)this.nfsFileShareInfoList.stream().map(NFSFileShareInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nfsFileShareInfoList(Collection<NFSFileShareInfo> nfsFileShareInfoList) {
            this.nfsFileShareInfoList = NFSFileShareInfoListCopier.copy(nfsFileShareInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nfsFileShareInfoList(NFSFileShareInfo ... nfsFileShareInfoList) {
            this.nfsFileShareInfoList(Arrays.asList(nfsFileShareInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nfsFileShareInfoList(Consumer<NFSFileShareInfo.Builder> ... nfsFileShareInfoList) {
            this.nfsFileShareInfoList(Stream.of(nfsFileShareInfoList).map(c -> (NFSFileShareInfo)((NFSFileShareInfo.Builder)NFSFileShareInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNfsFileShareInfoList(Collection<NFSFileShareInfo.BuilderImpl> nfsFileShareInfoList) {
            this.nfsFileShareInfoList = NFSFileShareInfoListCopier.copyFromBuilder(nfsFileShareInfoList);
        }

        @Override
        public DescribeNfsFileSharesResponse build() {
            return new DescribeNfsFileSharesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNfsFileSharesResponse> {
        public Builder nfsFileShareInfoList(Collection<NFSFileShareInfo> var1);

        public Builder nfsFileShareInfoList(NFSFileShareInfo ... var1);

        public Builder nfsFileShareInfoList(Consumer<NFSFileShareInfo.Builder> ... var1);
    }
}

