/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCachediScsiVolumeResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, CreateCachediScsiVolumeResponse> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeARN").getter(CreateCachediScsiVolumeResponse.getter(CreateCachediScsiVolumeResponse::volumeARN)).setter(CreateCachediScsiVolumeResponse.setter(Builder::volumeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetARN").getter(CreateCachediScsiVolumeResponse.getter(CreateCachediScsiVolumeResponse::targetARN)).setter(CreateCachediScsiVolumeResponse.setter(Builder::targetARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD, TARGET_ARN_FIELD));
    private final String volumeARN;
    private final String targetARN;

    private CreateCachediScsiVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.volumeARN = builder.volumeARN;
        this.targetARN = builder.targetARN;
    }

    public String volumeARN() {
        return this.volumeARN;
    }

    public String targetARN() {
        return this.targetARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCachediScsiVolumeResponse)) {
            return false;
        }
        CreateCachediScsiVolumeResponse other = (CreateCachediScsiVolumeResponse)((Object)obj);
        return Objects.equals(this.volumeARN(), other.volumeARN()) && Objects.equals(this.targetARN(), other.targetARN());
    }

    public String toString() {
        return ToString.builder((String)"CreateCachediScsiVolumeResponse").add("VolumeARN", (Object)this.volumeARN()).add("TargetARN", (Object)this.targetARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeARN": {
                return Optional.ofNullable(clazz.cast(this.volumeARN()));
            }
            case "TargetARN": {
                return Optional.ofNullable(clazz.cast(this.targetARN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCachediScsiVolumeResponse, T> g) {
        return obj -> g.apply((CreateCachediScsiVolumeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String volumeARN;
        private String targetARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCachediScsiVolumeResponse model) {
            super(model);
            this.volumeARN(model.volumeARN);
            this.targetARN(model.targetARN);
        }

        public final String getVolumeARN() {
            return this.volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final String getTargetARN() {
            return this.targetARN;
        }

        @Override
        public final Builder targetARN(String targetARN) {
            this.targetARN = targetARN;
            return this;
        }

        public final void setTargetARN(String targetARN) {
            this.targetARN = targetARN;
        }

        @Override
        public CreateCachediScsiVolumeResponse build() {
            return new CreateCachediScsiVolumeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCachediScsiVolumeResponse> {
        public Builder volumeARN(String var1);

        public Builder targetARN(String var1);
    }
}

