/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteChapCredentialsRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, DeleteChapCredentialsRequest> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetARN").getter(DeleteChapCredentialsRequest.getter(DeleteChapCredentialsRequest::targetARN)).setter(DeleteChapCredentialsRequest.setter(Builder::targetARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetARN").build()}).build();
    private static final SdkField<String> INITIATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitiatorName").getter(DeleteChapCredentialsRequest.getter(DeleteChapCredentialsRequest::initiatorName)).setter(DeleteChapCredentialsRequest.setter(Builder::initiatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatorName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD, INITIATOR_NAME_FIELD));
    private final String targetARN;
    private final String initiatorName;

    private DeleteChapCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.targetARN = builder.targetARN;
        this.initiatorName = builder.initiatorName;
    }

    public String targetARN() {
        return this.targetARN;
    }

    public String initiatorName() {
        return this.initiatorName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiatorName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteChapCredentialsRequest)) {
            return false;
        }
        DeleteChapCredentialsRequest other = (DeleteChapCredentialsRequest)((Object)obj);
        return Objects.equals(this.targetARN(), other.targetARN()) && Objects.equals(this.initiatorName(), other.initiatorName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteChapCredentialsRequest").add("TargetARN", (Object)this.targetARN()).add("InitiatorName", (Object)this.initiatorName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetARN": {
                return Optional.ofNullable(clazz.cast(this.targetARN()));
            }
            case "InitiatorName": {
                return Optional.ofNullable(clazz.cast(this.initiatorName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteChapCredentialsRequest, T> g) {
        return obj -> g.apply((DeleteChapCredentialsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String targetARN;
        private String initiatorName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteChapCredentialsRequest model) {
            super(model);
            this.targetARN(model.targetARN);
            this.initiatorName(model.initiatorName);
        }

        public final String getTargetARN() {
            return this.targetARN;
        }

        @Override
        public final Builder targetARN(String targetARN) {
            this.targetARN = targetARN;
            return this;
        }

        public final void setTargetARN(String targetARN) {
            this.targetARN = targetARN;
        }

        public final String getInitiatorName() {
            return this.initiatorName;
        }

        @Override
        public final Builder initiatorName(String initiatorName) {
            this.initiatorName = initiatorName;
            return this;
        }

        public final void setInitiatorName(String initiatorName) {
            this.initiatorName = initiatorName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteChapCredentialsRequest build() {
            return new DeleteChapCredentialsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteChapCredentialsRequest> {
        public Builder targetARN(String var1);

        public Builder initiatorName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

