/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.SMBFileShareInfo;
import software.amazon.awssdk.services.storagegateway.model.SMBFileShareInfoListCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSmbFileSharesResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeSmbFileSharesResponse> {
    private static final SdkField<List<SMBFileShareInfo>> SMB_FILE_SHARE_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SMBFileShareInfoList").getter(DescribeSmbFileSharesResponse.getter(DescribeSmbFileSharesResponse::smbFileShareInfoList)).setter(DescribeSmbFileSharesResponse.setter(Builder::smbFileShareInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBFileShareInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SMBFileShareInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMB_FILE_SHARE_INFO_LIST_FIELD));
    private final List<SMBFileShareInfo> smbFileShareInfoList;

    private DescribeSmbFileSharesResponse(BuilderImpl builder) {
        super(builder);
        this.smbFileShareInfoList = builder.smbFileShareInfoList;
    }

    public boolean hasSmbFileShareInfoList() {
        return this.smbFileShareInfoList != null && !(this.smbFileShareInfoList instanceof SdkAutoConstructList);
    }

    public List<SMBFileShareInfo> smbFileShareInfoList() {
        return this.smbFileShareInfoList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSmbFileShareInfoList() ? this.smbFileShareInfoList() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSmbFileSharesResponse)) {
            return false;
        }
        DescribeSmbFileSharesResponse other = (DescribeSmbFileSharesResponse)((Object)obj);
        return this.hasSmbFileShareInfoList() == other.hasSmbFileShareInfoList() && Objects.equals(this.smbFileShareInfoList(), other.smbFileShareInfoList());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSmbFileSharesResponse").add("SMBFileShareInfoList", this.hasSmbFileShareInfoList() ? this.smbFileShareInfoList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SMBFileShareInfoList": {
                return Optional.ofNullable(clazz.cast(this.smbFileShareInfoList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSmbFileSharesResponse, T> g) {
        return obj -> g.apply((DescribeSmbFileSharesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<SMBFileShareInfo> smbFileShareInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSmbFileSharesResponse model) {
            super(model);
            this.smbFileShareInfoList(model.smbFileShareInfoList);
        }

        public final Collection<SMBFileShareInfo.Builder> getSmbFileShareInfoList() {
            if (this.smbFileShareInfoList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.smbFileShareInfoList != null ? (Collection)this.smbFileShareInfoList.stream().map(SMBFileShareInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder smbFileShareInfoList(Collection<SMBFileShareInfo> smbFileShareInfoList) {
            this.smbFileShareInfoList = SMBFileShareInfoListCopier.copy(smbFileShareInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smbFileShareInfoList(SMBFileShareInfo ... smbFileShareInfoList) {
            this.smbFileShareInfoList(Arrays.asList(smbFileShareInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smbFileShareInfoList(Consumer<SMBFileShareInfo.Builder> ... smbFileShareInfoList) {
            this.smbFileShareInfoList(Stream.of(smbFileShareInfoList).map(c -> (SMBFileShareInfo)((SMBFileShareInfo.Builder)SMBFileShareInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSmbFileShareInfoList(Collection<SMBFileShareInfo.BuilderImpl> smbFileShareInfoList) {
            this.smbFileShareInfoList = SMBFileShareInfoListCopier.copyFromBuilder(smbFileShareInfoList);
        }

        @Override
        public DescribeSmbFileSharesResponse build() {
            return new DescribeSmbFileSharesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSmbFileSharesResponse> {
        public Builder smbFileShareInfoList(Collection<SMBFileShareInfo> var1);

        public Builder smbFileShareInfoList(SMBFileShareInfo ... var1);

        public Builder smbFileShareInfoList(Consumer<SMBFileShareInfo.Builder> ... var1);
    }
}

