/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.DiskIdsCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkingStorageResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeWorkingStorageResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(DescribeWorkingStorageResponse.getter(DescribeWorkingStorageResponse::gatewayARN)).setter(DescribeWorkingStorageResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<List<String>> DISK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DiskIds").getter(DescribeWorkingStorageResponse.getter(DescribeWorkingStorageResponse::diskIds)).setter(DescribeWorkingStorageResponse.setter(Builder::diskIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> WORKING_STORAGE_USED_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("WorkingStorageUsedInBytes").getter(DescribeWorkingStorageResponse.getter(DescribeWorkingStorageResponse::workingStorageUsedInBytes)).setter(DescribeWorkingStorageResponse.setter(Builder::workingStorageUsedInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingStorageUsedInBytes").build()}).build();
    private static final SdkField<Long> WORKING_STORAGE_ALLOCATED_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("WorkingStorageAllocatedInBytes").getter(DescribeWorkingStorageResponse.getter(DescribeWorkingStorageResponse::workingStorageAllocatedInBytes)).setter(DescribeWorkingStorageResponse.setter(Builder::workingStorageAllocatedInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingStorageAllocatedInBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, DISK_IDS_FIELD, WORKING_STORAGE_USED_IN_BYTES_FIELD, WORKING_STORAGE_ALLOCATED_IN_BYTES_FIELD));
    private final String gatewayARN;
    private final List<String> diskIds;
    private final Long workingStorageUsedInBytes;
    private final Long workingStorageAllocatedInBytes;

    private DescribeWorkingStorageResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.diskIds = builder.diskIds;
        this.workingStorageUsedInBytes = builder.workingStorageUsedInBytes;
        this.workingStorageAllocatedInBytes = builder.workingStorageAllocatedInBytes;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public boolean hasDiskIds() {
        return this.diskIds != null && !(this.diskIds instanceof SdkAutoConstructList);
    }

    public List<String> diskIds() {
        return this.diskIds;
    }

    public Long workingStorageUsedInBytes() {
        return this.workingStorageUsedInBytes;
    }

    public Long workingStorageAllocatedInBytes() {
        return this.workingStorageAllocatedInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDiskIds() ? this.diskIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workingStorageUsedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.workingStorageAllocatedInBytes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkingStorageResponse)) {
            return false;
        }
        DescribeWorkingStorageResponse other = (DescribeWorkingStorageResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && this.hasDiskIds() == other.hasDiskIds() && Objects.equals(this.diskIds(), other.diskIds()) && Objects.equals(this.workingStorageUsedInBytes(), other.workingStorageUsedInBytes()) && Objects.equals(this.workingStorageAllocatedInBytes(), other.workingStorageAllocatedInBytes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeWorkingStorageResponse").add("GatewayARN", (Object)this.gatewayARN()).add("DiskIds", this.hasDiskIds() ? this.diskIds() : null).add("WorkingStorageUsedInBytes", (Object)this.workingStorageUsedInBytes()).add("WorkingStorageAllocatedInBytes", (Object)this.workingStorageAllocatedInBytes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "DiskIds": {
                return Optional.ofNullable(clazz.cast(this.diskIds()));
            }
            case "WorkingStorageUsedInBytes": {
                return Optional.ofNullable(clazz.cast(this.workingStorageUsedInBytes()));
            }
            case "WorkingStorageAllocatedInBytes": {
                return Optional.ofNullable(clazz.cast(this.workingStorageAllocatedInBytes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkingStorageResponse, T> g) {
        return obj -> g.apply((DescribeWorkingStorageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private List<String> diskIds = DefaultSdkAutoConstructList.getInstance();
        private Long workingStorageUsedInBytes;
        private Long workingStorageAllocatedInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkingStorageResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.diskIds(model.diskIds);
            this.workingStorageUsedInBytes(model.workingStorageUsedInBytes);
            this.workingStorageAllocatedInBytes(model.workingStorageAllocatedInBytes);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<String> getDiskIds() {
            if (this.diskIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.diskIds;
        }

        @Override
        public final Builder diskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskIds(String ... diskIds) {
            this.diskIds(Arrays.asList(diskIds));
            return this;
        }

        public final void setDiskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
        }

        public final Long getWorkingStorageUsedInBytes() {
            return this.workingStorageUsedInBytes;
        }

        @Override
        public final Builder workingStorageUsedInBytes(Long workingStorageUsedInBytes) {
            this.workingStorageUsedInBytes = workingStorageUsedInBytes;
            return this;
        }

        public final void setWorkingStorageUsedInBytes(Long workingStorageUsedInBytes) {
            this.workingStorageUsedInBytes = workingStorageUsedInBytes;
        }

        public final Long getWorkingStorageAllocatedInBytes() {
            return this.workingStorageAllocatedInBytes;
        }

        @Override
        public final Builder workingStorageAllocatedInBytes(Long workingStorageAllocatedInBytes) {
            this.workingStorageAllocatedInBytes = workingStorageAllocatedInBytes;
            return this;
        }

        public final void setWorkingStorageAllocatedInBytes(Long workingStorageAllocatedInBytes) {
            this.workingStorageAllocatedInBytes = workingStorageAllocatedInBytes;
        }

        @Override
        public DescribeWorkingStorageResponse build() {
            return new DescribeWorkingStorageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkingStorageResponse> {
        public Builder gatewayARN(String var1);

        public Builder diskIds(Collection<String> var1);

        public Builder diskIds(String ... var1);

        public Builder workingStorageUsedInBytes(Long var1);

        public Builder workingStorageAllocatedInBytes(Long var1);
    }
}

