/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeVTLDevicesInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVtlDevicesRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<DescribeVtlDevicesRequest.Builder, DescribeVtlDevicesRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(DescribeVtlDevicesRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<List<String>> VTL_DEVICE_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VTLDeviceARNs")
            .getter(getter(DescribeVtlDevicesRequest::vtlDeviceARNs))
            .setter(setter(Builder::vtlDeviceARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDeviceARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeVtlDevicesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeVtlDevicesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            VTL_DEVICE_AR_NS_FIELD, MARKER_FIELD, LIMIT_FIELD));

    private final String gatewayARN;

    private final List<String> vtlDeviceARNs;

    private final String marker;

    private final Integer limit;

    private DescribeVtlDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.vtlDeviceARNs = builder.vtlDeviceARNs;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * Returns true if the VTLDeviceARNs property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVtlDeviceARNs() {
        return vtlDeviceARNs != null && !(vtlDeviceARNs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings, where each string represents the Amazon Resource Name (ARN) of a VTL device.
     * </p>
     * <note>
     * <p>
     * All of the specified VTL devices must be from the same gateway. If no VTL devices are specified, the result will
     * contain all devices on the specified gateway.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVtlDeviceARNs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of strings, where each string represents the Amazon Resource Name (ARN) of a VTL device.</p>
     *         <note>
     *         <p>
     *         All of the specified VTL devices must be from the same gateway. If no VTL devices are specified, the
     *         result will contain all devices on the specified gateway.
     *         </p>
     */
    public List<String> vtlDeviceARNs() {
        return vtlDeviceARNs;
    }

    /**
     * <p>
     * An opaque string that indicates the position at which to begin describing the VTL devices.
     * </p>
     * 
     * @return An opaque string that indicates the position at which to begin describing the VTL devices.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Specifies that the number of VTL devices described be limited to the specified number.
     * </p>
     * 
     * @return Specifies that the number of VTL devices described be limited to the specified number.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasVtlDeviceARNs() ? vtlDeviceARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVtlDevicesRequest)) {
            return false;
        }
        DescribeVtlDevicesRequest other = (DescribeVtlDevicesRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && hasVtlDeviceARNs() == other.hasVtlDeviceARNs()
                && Objects.equals(vtlDeviceARNs(), other.vtlDeviceARNs()) && Objects.equals(marker(), other.marker())
                && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVtlDevicesRequest").add("GatewayARN", gatewayARN())
                .add("VTLDeviceARNs", hasVtlDeviceARNs() ? vtlDeviceARNs() : null).add("Marker", marker()).add("Limit", limit())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "VTLDeviceARNs":
            return Optional.ofNullable(clazz.cast(vtlDeviceARNs()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVtlDevicesRequest, T> g) {
        return obj -> g.apply((DescribeVtlDevicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVtlDevicesRequest> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * An array of strings, where each string represents the Amazon Resource Name (ARN) of a VTL device.
         * </p>
         * <note>
         * <p>
         * All of the specified VTL devices must be from the same gateway. If no VTL devices are specified, the result
         * will contain all devices on the specified gateway.
         * </p>
         * </note>
         * 
         * @param vtlDeviceARNs
         *        An array of strings, where each string represents the Amazon Resource Name (ARN) of a VTL device.</p>
         *        <note>
         *        <p>
         *        All of the specified VTL devices must be from the same gateway. If no VTL devices are specified, the
         *        result will contain all devices on the specified gateway.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDeviceARNs(Collection<String> vtlDeviceARNs);

        /**
         * <p>
         * An array of strings, where each string represents the Amazon Resource Name (ARN) of a VTL device.
         * </p>
         * <note>
         * <p>
         * All of the specified VTL devices must be from the same gateway. If no VTL devices are specified, the result
         * will contain all devices on the specified gateway.
         * </p>
         * </note>
         * 
         * @param vtlDeviceARNs
         *        An array of strings, where each string represents the Amazon Resource Name (ARN) of a VTL device.</p>
         *        <note>
         *        <p>
         *        All of the specified VTL devices must be from the same gateway. If no VTL devices are specified, the
         *        result will contain all devices on the specified gateway.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDeviceARNs(String... vtlDeviceARNs);

        /**
         * <p>
         * An opaque string that indicates the position at which to begin describing the VTL devices.
         * </p>
         * 
         * @param marker
         *        An opaque string that indicates the position at which to begin describing the VTL devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Specifies that the number of VTL devices described be limited to the specified number.
         * </p>
         * 
         * @param limit
         *        Specifies that the number of VTL devices described be limited to the specified number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private List<String> vtlDeviceARNs = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVtlDevicesRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            vtlDeviceARNs(model.vtlDeviceARNs);
            marker(model.marker);
            limit(model.limit);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<String> getVtlDeviceARNs() {
            if (vtlDeviceARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return vtlDeviceARNs;
        }

        @Override
        public final Builder vtlDeviceARNs(Collection<String> vtlDeviceARNs) {
            this.vtlDeviceARNs = VTLDeviceARNsCopier.copy(vtlDeviceARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vtlDeviceARNs(String... vtlDeviceARNs) {
            vtlDeviceARNs(Arrays.asList(vtlDeviceARNs));
            return this;
        }

        public final void setVtlDeviceARNs(Collection<String> vtlDeviceARNs) {
            this.vtlDeviceARNs = VTLDeviceARNsCopier.copy(vtlDeviceARNs);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVtlDevicesRequest build() {
            return new DescribeVtlDevicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
