/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.storagegateway.model.ErrorCode;
import software.amazon.awssdk.services.storagegateway.model._errorDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageGatewayError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageGatewayError> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(StorageGatewayError.getter(StorageGatewayError::errorCodeAsString)).setter(StorageGatewayError.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<Map<String, String>> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("errorDetails").getter(StorageGatewayError.getter(StorageGatewayError::errorDetails)).setter(StorageGatewayError.setter(Builder::errorDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD, ERROR_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String errorCode;
    private final Map<String, String> errorDetails;

    private StorageGatewayError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorDetails = builder.errorDetails;
    }

    public ErrorCode errorCode() {
        return ErrorCode.fromValue(this.errorCode);
    }

    public String errorCodeAsString() {
        return this.errorCode;
    }

    public boolean hasErrorDetails() {
        return this.errorDetails != null && !(this.errorDetails instanceof SdkAutoConstructMap);
    }

    public Map<String, String> errorDetails() {
        return this.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorDetails() ? this.errorDetails() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageGatewayError)) {
            return false;
        }
        StorageGatewayError other = (StorageGatewayError)obj;
        return Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && this.hasErrorDetails() == other.hasErrorDetails() && Objects.equals(this.errorDetails(), other.errorDetails());
    }

    public String toString() {
        return ToString.builder((String)"StorageGatewayError").add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorDetails", this.hasErrorDetails() ? this.errorDetails() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "errorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageGatewayError, T> g) {
        return obj -> g.apply((StorageGatewayError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private Map<String, String> errorDetails = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StorageGatewayError model) {
            this.errorCode(model.errorCode);
            this.errorDetails(model.errorDetails);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final Map<String, String> getErrorDetails() {
            if (this.errorDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.errorDetails;
        }

        @Override
        public final Builder errorDetails(Map<String, String> errorDetails) {
            this.errorDetails = _errorDetailsCopier.copy(errorDetails);
            return this;
        }

        public final void setErrorDetails(Map<String, String> errorDetails) {
            this.errorDetails = _errorDetailsCopier.copy(errorDetails);
        }

        public StorageGatewayError build() {
            return new StorageGatewayError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageGatewayError> {
        public Builder errorCode(String var1);

        public Builder errorCode(ErrorCode var1);

        public Builder errorDetails(Map<String, String> var1);
    }
}

