/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes Challenge-Handshake Authentication Protocol (CHAP) information that supports authentication between your
 * gateway and iSCSI initiators.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChapInfo implements SdkPojo, Serializable, ToCopyableBuilder<ChapInfo.Builder, ChapInfo> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetARN").getter(getter(ChapInfo::targetARN)).setter(setter(Builder::targetARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetARN").build()).build();

    private static final SdkField<String> SECRET_TO_AUTHENTICATE_INITIATOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretToAuthenticateInitiator")
            .getter(getter(ChapInfo::secretToAuthenticateInitiator))
            .setter(setter(Builder::secretToAuthenticateInitiator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretToAuthenticateInitiator")
                    .build()).build();

    private static final SdkField<String> INITIATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitiatorName").getter(getter(ChapInfo::initiatorName)).setter(setter(Builder::initiatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatorName").build()).build();

    private static final SdkField<String> SECRET_TO_AUTHENTICATE_TARGET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretToAuthenticateTarget")
            .getter(getter(ChapInfo::secretToAuthenticateTarget))
            .setter(setter(Builder::secretToAuthenticateTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretToAuthenticateTarget").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD,
            SECRET_TO_AUTHENTICATE_INITIATOR_FIELD, INITIATOR_NAME_FIELD, SECRET_TO_AUTHENTICATE_TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetARN;

    private final String secretToAuthenticateInitiator;

    private final String initiatorName;

    private final String secretToAuthenticateTarget;

    private ChapInfo(BuilderImpl builder) {
        this.targetARN = builder.targetARN;
        this.secretToAuthenticateInitiator = builder.secretToAuthenticateInitiator;
        this.initiatorName = builder.initiatorName;
        this.secretToAuthenticateTarget = builder.secretToAuthenticateTarget;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the volume.
     * </p>
     * <p>
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the volume.</p>
     *         <p>
     *         Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    public String targetARN() {
        return targetARN;
    }

    /**
     * <p>
     * The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP
     * with the target.
     * </p>
     * 
     * @return The secret key that the initiator (for example, the Windows client) must provide to participate in mutual
     *         CHAP with the target.
     */
    public String secretToAuthenticateInitiator() {
        return secretToAuthenticateInitiator;
    }

    /**
     * <p>
     * The iSCSI initiator that connects to the target.
     * </p>
     * 
     * @return The iSCSI initiator that connects to the target.
     */
    public String initiatorName() {
        return initiatorName;
    }

    /**
     * <p>
     * The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g., Windows
     * client).
     * </p>
     * 
     * @return The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g.,
     *         Windows client).
     */
    public String secretToAuthenticateTarget() {
        return secretToAuthenticateTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetARN());
        hashCode = 31 * hashCode + Objects.hashCode(secretToAuthenticateInitiator());
        hashCode = 31 * hashCode + Objects.hashCode(initiatorName());
        hashCode = 31 * hashCode + Objects.hashCode(secretToAuthenticateTarget());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChapInfo)) {
            return false;
        }
        ChapInfo other = (ChapInfo) obj;
        return Objects.equals(targetARN(), other.targetARN())
                && Objects.equals(secretToAuthenticateInitiator(), other.secretToAuthenticateInitiator())
                && Objects.equals(initiatorName(), other.initiatorName())
                && Objects.equals(secretToAuthenticateTarget(), other.secretToAuthenticateTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("ChapInfo")
                .add("TargetARN", targetARN())
                .add("SecretToAuthenticateInitiator",
                        secretToAuthenticateInitiator() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InitiatorName", initiatorName())
                .add("SecretToAuthenticateTarget",
                        secretToAuthenticateTarget() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetARN":
            return Optional.ofNullable(clazz.cast(targetARN()));
        case "SecretToAuthenticateInitiator":
            return Optional.ofNullable(clazz.cast(secretToAuthenticateInitiator()));
        case "InitiatorName":
            return Optional.ofNullable(clazz.cast(initiatorName()));
        case "SecretToAuthenticateTarget":
            return Optional.ofNullable(clazz.cast(secretToAuthenticateTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChapInfo, T> g) {
        return obj -> g.apply((ChapInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChapInfo> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the volume.
         * </p>
         * <p>
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         * </p>
         * 
         * @param targetARN
         *        The Amazon Resource Name (ARN) of the volume.</p>
         *        <p>
         *        Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetARN(String targetARN);

        /**
         * <p>
         * The secret key that the initiator (for example, the Windows client) must provide to participate in mutual
         * CHAP with the target.
         * </p>
         * 
         * @param secretToAuthenticateInitiator
         *        The secret key that the initiator (for example, the Windows client) must provide to participate in
         *        mutual CHAP with the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretToAuthenticateInitiator(String secretToAuthenticateInitiator);

        /**
         * <p>
         * The iSCSI initiator that connects to the target.
         * </p>
         * 
         * @param initiatorName
         *        The iSCSI initiator that connects to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiatorName(String initiatorName);

        /**
         * <p>
         * The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g., Windows
         * client).
         * </p>
         * 
         * @param secretToAuthenticateTarget
         *        The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g.,
         *        Windows client).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretToAuthenticateTarget(String secretToAuthenticateTarget);
    }

    static final class BuilderImpl implements Builder {
        private String targetARN;

        private String secretToAuthenticateInitiator;

        private String initiatorName;

        private String secretToAuthenticateTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(ChapInfo model) {
            targetARN(model.targetARN);
            secretToAuthenticateInitiator(model.secretToAuthenticateInitiator);
            initiatorName(model.initiatorName);
            secretToAuthenticateTarget(model.secretToAuthenticateTarget);
        }

        public final String getTargetARN() {
            return targetARN;
        }

        @Override
        public final Builder targetARN(String targetARN) {
            this.targetARN = targetARN;
            return this;
        }

        public final void setTargetARN(String targetARN) {
            this.targetARN = targetARN;
        }

        public final String getSecretToAuthenticateInitiator() {
            return secretToAuthenticateInitiator;
        }

        @Override
        public final Builder secretToAuthenticateInitiator(String secretToAuthenticateInitiator) {
            this.secretToAuthenticateInitiator = secretToAuthenticateInitiator;
            return this;
        }

        public final void setSecretToAuthenticateInitiator(String secretToAuthenticateInitiator) {
            this.secretToAuthenticateInitiator = secretToAuthenticateInitiator;
        }

        public final String getInitiatorName() {
            return initiatorName;
        }

        @Override
        public final Builder initiatorName(String initiatorName) {
            this.initiatorName = initiatorName;
            return this;
        }

        public final void setInitiatorName(String initiatorName) {
            this.initiatorName = initiatorName;
        }

        public final String getSecretToAuthenticateTarget() {
            return secretToAuthenticateTarget;
        }

        @Override
        public final Builder secretToAuthenticateTarget(String secretToAuthenticateTarget) {
            this.secretToAuthenticateTarget = secretToAuthenticateTarget;
            return this;
        }

        public final void setSecretToAuthenticateTarget(String secretToAuthenticateTarget) {
            this.secretToAuthenticateTarget = secretToAuthenticateTarget;
        }

        @Override
        public ChapInfo build() {
            return new ChapInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
