/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTapePoolRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<CreateTapePoolRequest.Builder, CreateTapePoolRequest> {
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolName").getter(getter(CreateTapePoolRequest::poolName)).setter(setter(Builder::poolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()).build();

    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageClass").getter(getter(CreateTapePoolRequest::storageClassAsString))
            .setter(setter(Builder::storageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").build()).build();

    private static final SdkField<String> RETENTION_LOCK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetentionLockType").getter(getter(CreateTapePoolRequest::retentionLockTypeAsString))
            .setter(setter(Builder::retentionLockType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionLockType").build()).build();

    private static final SdkField<Integer> RETENTION_LOCK_TIME_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("RetentionLockTimeInDays")
            .getter(getter(CreateTapePoolRequest::retentionLockTimeInDays)).setter(setter(Builder::retentionLockTimeInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionLockTimeInDays").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTapePoolRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_NAME_FIELD,
            STORAGE_CLASS_FIELD, RETENTION_LOCK_TYPE_FIELD, RETENTION_LOCK_TIME_IN_DAYS_FIELD, TAGS_FIELD));

    private final String poolName;

    private final String storageClass;

    private final String retentionLockType;

    private final Integer retentionLockTimeInDays;

    private final List<Tag> tags;

    private CreateTapePoolRequest(BuilderImpl builder) {
        super(builder);
        this.poolName = builder.poolName;
        this.storageClass = builder.storageClass;
        this.retentionLockType = builder.retentionLockType;
        this.retentionLockTimeInDays = builder.retentionLockTimeInDays;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the new custom tape pool.
     * </p>
     * 
     * @return The name of the new custom tape pool.
     */
    public String poolName() {
        return poolName;
    }

    /**
     * <p>
     * The storage class that is associated with the new custom pool. When you use your backup application to eject the
     * tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that
     * corresponds to the pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link TapeStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return The storage class that is associated with the new custom pool. When you use your backup application to
     *         eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
     *         Archive) that corresponds to the pool.
     * @see TapeStorageClass
     */
    public TapeStorageClass storageClass() {
        return TapeStorageClass.fromValue(storageClass);
    }

    /**
     * <p>
     * The storage class that is associated with the new custom pool. When you use your backup application to eject the
     * tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that
     * corresponds to the pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link TapeStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return The storage class that is associated with the new custom pool. When you use your backup application to
     *         eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
     *         Archive) that corresponds to the pool.
     * @see TapeStorageClass
     */
    public String storageClassAsString() {
        return storageClass;
    }

    /**
     * <p>
     * Tape retention lock can be configured in two modes. When configured in governance mode, AWS accounts with
     * specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When
     * configured in compliance mode, the tape retention lock cannot be removed by any user, including the root AWS
     * account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retentionLockType}
     * will return {@link RetentionLockType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retentionLockTypeAsString}.
     * </p>
     * 
     * @return Tape retention lock can be configured in two modes. When configured in governance mode, AWS accounts with
     *         specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes.
     *         When configured in compliance mode, the tape retention lock cannot be removed by any user, including the
     *         root AWS account.
     * @see RetentionLockType
     */
    public RetentionLockType retentionLockType() {
        return RetentionLockType.fromValue(retentionLockType);
    }

    /**
     * <p>
     * Tape retention lock can be configured in two modes. When configured in governance mode, AWS accounts with
     * specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When
     * configured in compliance mode, the tape retention lock cannot be removed by any user, including the root AWS
     * account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retentionLockType}
     * will return {@link RetentionLockType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retentionLockTypeAsString}.
     * </p>
     * 
     * @return Tape retention lock can be configured in two modes. When configured in governance mode, AWS accounts with
     *         specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes.
     *         When configured in compliance mode, the tape retention lock cannot be removed by any user, including the
     *         root AWS account.
     * @see RetentionLockType
     */
    public String retentionLockTypeAsString() {
        return retentionLockType;
    }

    /**
     * <p>
     * Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days).
     * </p>
     * 
     * @return Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500
     *         days).
     */
    public Integer retentionLockTimeInDays() {
        return retentionLockTimeInDays;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.
     * </p>
     * <note>
     * <p>
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
     * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
     * maximum length for a tag's value is 256.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.</p> <note>
     *         <p>
     *         Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
     *         the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters,
     *         and the maximum length for a tag's value is 256.
     *         </p>
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolName());
        hashCode = 31 * hashCode + Objects.hashCode(storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retentionLockTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retentionLockTimeInDays());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTapePoolRequest)) {
            return false;
        }
        CreateTapePoolRequest other = (CreateTapePoolRequest) obj;
        return Objects.equals(poolName(), other.poolName())
                && Objects.equals(storageClassAsString(), other.storageClassAsString())
                && Objects.equals(retentionLockTypeAsString(), other.retentionLockTypeAsString())
                && Objects.equals(retentionLockTimeInDays(), other.retentionLockTimeInDays()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTapePoolRequest").add("PoolName", poolName()).add("StorageClass", storageClassAsString())
                .add("RetentionLockType", retentionLockTypeAsString()).add("RetentionLockTimeInDays", retentionLockTimeInDays())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolName":
            return Optional.ofNullable(clazz.cast(poolName()));
        case "StorageClass":
            return Optional.ofNullable(clazz.cast(storageClassAsString()));
        case "RetentionLockType":
            return Optional.ofNullable(clazz.cast(retentionLockTypeAsString()));
        case "RetentionLockTimeInDays":
            return Optional.ofNullable(clazz.cast(retentionLockTimeInDays()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTapePoolRequest, T> g) {
        return obj -> g.apply((CreateTapePoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTapePoolRequest> {
        /**
         * <p>
         * The name of the new custom tape pool.
         * </p>
         * 
         * @param poolName
         *        The name of the new custom tape pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolName(String poolName);

        /**
         * <p>
         * The storage class that is associated with the new custom pool. When you use your backup application to eject
         * the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that
         * corresponds to the pool.
         * </p>
         * 
         * @param storageClass
         *        The storage class that is associated with the new custom pool. When you use your backup application to
         *        eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
         *        Archive) that corresponds to the pool.
         * @see TapeStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TapeStorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * <p>
         * The storage class that is associated with the new custom pool. When you use your backup application to eject
         * the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that
         * corresponds to the pool.
         * </p>
         * 
         * @param storageClass
         *        The storage class that is associated with the new custom pool. When you use your backup application to
         *        eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
         *        Archive) that corresponds to the pool.
         * @see TapeStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TapeStorageClass
         */
        Builder storageClass(TapeStorageClass storageClass);

        /**
         * <p>
         * Tape retention lock can be configured in two modes. When configured in governance mode, AWS accounts with
         * specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When
         * configured in compliance mode, the tape retention lock cannot be removed by any user, including the root AWS
         * account.
         * </p>
         * 
         * @param retentionLockType
         *        Tape retention lock can be configured in two modes. When configured in governance mode, AWS accounts
         *        with specific IAM permissions are authorized to remove the tape retention lock from archived virtual
         *        tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user,
         *        including the root AWS account.
         * @see RetentionLockType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionLockType
         */
        Builder retentionLockType(String retentionLockType);

        /**
         * <p>
         * Tape retention lock can be configured in two modes. When configured in governance mode, AWS accounts with
         * specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When
         * configured in compliance mode, the tape retention lock cannot be removed by any user, including the root AWS
         * account.
         * </p>
         * 
         * @param retentionLockType
         *        Tape retention lock can be configured in two modes. When configured in governance mode, AWS accounts
         *        with specific IAM permissions are authorized to remove the tape retention lock from archived virtual
         *        tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user,
         *        including the root AWS account.
         * @see RetentionLockType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionLockType
         */
        Builder retentionLockType(RetentionLockType retentionLockType);

        /**
         * <p>
         * Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500
         * days).
         * </p>
         * 
         * @param retentionLockTimeInDays
         *        Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years
         *        (36,500 days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionLockTimeInDays(Integer retentionLockTimeInDays);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.</p> <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
         *        characters, and the maximum length for a tag's value is 256.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.</p> <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
         *        characters, and the maximum length for a tag's value is 256.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String poolName;

        private String storageClass;

        private String retentionLockType;

        private Integer retentionLockTimeInDays;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTapePoolRequest model) {
            super(model);
            poolName(model.poolName);
            storageClass(model.storageClass);
            retentionLockType(model.retentionLockType);
            retentionLockTimeInDays(model.retentionLockTimeInDays);
            tags(model.tags);
        }

        public final String getPoolName() {
            return poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(TapeStorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final String getRetentionLockType() {
            return retentionLockType;
        }

        @Override
        public final Builder retentionLockType(String retentionLockType) {
            this.retentionLockType = retentionLockType;
            return this;
        }

        @Override
        public final Builder retentionLockType(RetentionLockType retentionLockType) {
            this.retentionLockType(retentionLockType == null ? null : retentionLockType.toString());
            return this;
        }

        public final void setRetentionLockType(String retentionLockType) {
            this.retentionLockType = retentionLockType;
        }

        public final Integer getRetentionLockTimeInDays() {
            return retentionLockTimeInDays;
        }

        @Override
        public final Builder retentionLockTimeInDays(Integer retentionLockTimeInDays) {
            this.retentionLockTimeInDays = retentionLockTimeInDays;
            return this;
        }

        public final void setRetentionLockTimeInDays(Integer retentionLockTimeInDays) {
            this.retentionLockTimeInDays = retentionLockTimeInDays;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTapePoolRequest build() {
            return new CreateTapePoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
