/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBandwidthRateLimitResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeBandwidthRateLimitResponse.Builder, DescribeBandwidthRateLimitResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(DescribeBandwidthRateLimitResponse::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<Long> AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AverageUploadRateLimitInBitsPerSec")
            .getter(getter(DescribeBandwidthRateLimitResponse::averageUploadRateLimitInBitsPerSec))
            .setter(setter(Builder::averageUploadRateLimitInBitsPerSec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageUploadRateLimitInBitsPerSec")
                    .build()).build();

    private static final SdkField<Long> AVERAGE_DOWNLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AverageDownloadRateLimitInBitsPerSec")
            .getter(getter(DescribeBandwidthRateLimitResponse::averageDownloadRateLimitInBitsPerSec))
            .setter(setter(Builder::averageDownloadRateLimitInBitsPerSec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AverageDownloadRateLimitInBitsPerSec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD, AVERAGE_DOWNLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD));

    private final String gatewayARN;

    private final Long averageUploadRateLimitInBitsPerSec;

    private final Long averageDownloadRateLimitInBitsPerSec;

    private DescribeBandwidthRateLimitResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.averageUploadRateLimitInBitsPerSec = builder.averageUploadRateLimitInBitsPerSec;
        this.averageDownloadRateLimitInBitsPerSec = builder.averageDownloadRateLimitInBitsPerSec;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The average upload bandwidth rate limit in bits per second. This field does not appear in the response if the
     * upload rate limit is not set.
     * </p>
     * 
     * @return The average upload bandwidth rate limit in bits per second. This field does not appear in the response if
     *         the upload rate limit is not set.
     */
    public Long averageUploadRateLimitInBitsPerSec() {
        return averageUploadRateLimitInBitsPerSec;
    }

    /**
     * <p>
     * The average download bandwidth rate limit in bits per second. This field does not appear in the response if the
     * download rate limit is not set.
     * </p>
     * 
     * @return The average download bandwidth rate limit in bits per second. This field does not appear in the response
     *         if the download rate limit is not set.
     */
    public Long averageDownloadRateLimitInBitsPerSec() {
        return averageDownloadRateLimitInBitsPerSec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(averageUploadRateLimitInBitsPerSec());
        hashCode = 31 * hashCode + Objects.hashCode(averageDownloadRateLimitInBitsPerSec());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBandwidthRateLimitResponse)) {
            return false;
        }
        DescribeBandwidthRateLimitResponse other = (DescribeBandwidthRateLimitResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN())
                && Objects.equals(averageUploadRateLimitInBitsPerSec(), other.averageUploadRateLimitInBitsPerSec())
                && Objects.equals(averageDownloadRateLimitInBitsPerSec(), other.averageDownloadRateLimitInBitsPerSec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeBandwidthRateLimitResponse").add("GatewayARN", gatewayARN())
                .add("AverageUploadRateLimitInBitsPerSec", averageUploadRateLimitInBitsPerSec())
                .add("AverageDownloadRateLimitInBitsPerSec", averageDownloadRateLimitInBitsPerSec()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "AverageUploadRateLimitInBitsPerSec":
            return Optional.ofNullable(clazz.cast(averageUploadRateLimitInBitsPerSec()));
        case "AverageDownloadRateLimitInBitsPerSec":
            return Optional.ofNullable(clazz.cast(averageDownloadRateLimitInBitsPerSec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBandwidthRateLimitResponse, T> g) {
        return obj -> g.apply((DescribeBandwidthRateLimitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeBandwidthRateLimitResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The average upload bandwidth rate limit in bits per second. This field does not appear in the response if the
         * upload rate limit is not set.
         * </p>
         * 
         * @param averageUploadRateLimitInBitsPerSec
         *        The average upload bandwidth rate limit in bits per second. This field does not appear in the response
         *        if the upload rate limit is not set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec);

        /**
         * <p>
         * The average download bandwidth rate limit in bits per second. This field does not appear in the response if
         * the download rate limit is not set.
         * </p>
         * 
         * @param averageDownloadRateLimitInBitsPerSec
         *        The average download bandwidth rate limit in bits per second. This field does not appear in the
         *        response if the download rate limit is not set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageDownloadRateLimitInBitsPerSec(Long averageDownloadRateLimitInBitsPerSec);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private Long averageUploadRateLimitInBitsPerSec;

        private Long averageDownloadRateLimitInBitsPerSec;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBandwidthRateLimitResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            averageUploadRateLimitInBitsPerSec(model.averageUploadRateLimitInBitsPerSec);
            averageDownloadRateLimitInBitsPerSec(model.averageDownloadRateLimitInBitsPerSec);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Long getAverageUploadRateLimitInBitsPerSec() {
            return averageUploadRateLimitInBitsPerSec;
        }

        @Override
        public final Builder averageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec) {
            this.averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec;
            return this;
        }

        public final void setAverageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec) {
            this.averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec;
        }

        public final Long getAverageDownloadRateLimitInBitsPerSec() {
            return averageDownloadRateLimitInBitsPerSec;
        }

        @Override
        public final Builder averageDownloadRateLimitInBitsPerSec(Long averageDownloadRateLimitInBitsPerSec) {
            this.averageDownloadRateLimitInBitsPerSec = averageDownloadRateLimitInBitsPerSec;
            return this;
        }

        public final void setAverageDownloadRateLimitInBitsPerSec(Long averageDownloadRateLimitInBitsPerSec) {
            this.averageDownloadRateLimitInBitsPerSec = averageDownloadRateLimitInBitsPerSec;
        }

        @Override
        public DescribeBandwidthRateLimitResponse build() {
            return new DescribeBandwidthRateLimitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
