/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeVTLDevicesOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVtlDevicesResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeVtlDevicesResponse.Builder, DescribeVtlDevicesResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(DescribeVtlDevicesResponse::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<List<VTLDevice>> VTL_DEVICES_FIELD = SdkField
            .<List<VTLDevice>> builder(MarshallingType.LIST)
            .memberName("VTLDevices")
            .getter(getter(DescribeVtlDevicesResponse::vtlDevices))
            .setter(setter(Builder::vtlDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VTLDevice> builder(MarshallingType.SDK_POJO)
                                            .constructor(VTLDevice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeVtlDevicesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            VTL_DEVICES_FIELD, MARKER_FIELD));

    private final String gatewayARN;

    private final List<VTLDevice> vtlDevices;

    private final String marker;

    private DescribeVtlDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.vtlDevices = builder.vtlDevices;
        this.marker = builder.marker;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * Returns true if the VTLDevices property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVtlDevices() {
        return vtlDevices != null && !(vtlDevices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVtlDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
     */
    public List<VTLDevice> vtlDevices() {
        return vtlDevices;
    }

    /**
     * <p>
     * An opaque string that indicates the position at which the VTL devices that were fetched for description ended.
     * Use the marker in your next request to fetch the next set of VTL devices in the list. If there are no more VTL
     * devices to describe, this field does not appear in the response.
     * </p>
     * 
     * @return An opaque string that indicates the position at which the VTL devices that were fetched for description
     *         ended. Use the marker in your next request to fetch the next set of VTL devices in the list. If there are
     *         no more VTL devices to describe, this field does not appear in the response.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasVtlDevices() ? vtlDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVtlDevicesResponse)) {
            return false;
        }
        DescribeVtlDevicesResponse other = (DescribeVtlDevicesResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && hasVtlDevices() == other.hasVtlDevices()
                && Objects.equals(vtlDevices(), other.vtlDevices()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVtlDevicesResponse").add("GatewayARN", gatewayARN())
                .add("VTLDevices", hasVtlDevices() ? vtlDevices() : null).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "VTLDevices":
            return Optional.ofNullable(clazz.cast(vtlDevices()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVtlDevicesResponse, T> g) {
        return obj -> g.apply((DescribeVtlDevicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVtlDevicesResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
         * </p>
         * 
         * @param vtlDevices
         *        An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDevices(Collection<VTLDevice> vtlDevices);

        /**
         * <p>
         * An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
         * </p>
         * 
         * @param vtlDevices
         *        An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDevices(VTLDevice... vtlDevices);

        /**
         * <p>
         * An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VTLDevice>.Builder} avoiding the need to
         * create one manually via {@link List<VTLDevice>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VTLDevice>.Builder#build()} is called immediately and its
         * result is passed to {@link #vtlDevices(List<VTLDevice>)}.
         * 
         * @param vtlDevices
         *        a consumer that will call methods on {@link List<VTLDevice>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vtlDevices(List<VTLDevice>)
         */
        Builder vtlDevices(Consumer<VTLDevice.Builder>... vtlDevices);

        /**
         * <p>
         * An opaque string that indicates the position at which the VTL devices that were fetched for description
         * ended. Use the marker in your next request to fetch the next set of VTL devices in the list. If there are no
         * more VTL devices to describe, this field does not appear in the response.
         * </p>
         * 
         * @param marker
         *        An opaque string that indicates the position at which the VTL devices that were fetched for
         *        description ended. Use the marker in your next request to fetch the next set of VTL devices in the
         *        list. If there are no more VTL devices to describe, this field does not appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private List<VTLDevice> vtlDevices = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVtlDevicesResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            vtlDevices(model.vtlDevices);
            marker(model.marker);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<VTLDevice.Builder> getVtlDevices() {
            if (vtlDevices instanceof SdkAutoConstructList) {
                return null;
            }
            return vtlDevices != null ? vtlDevices.stream().map(VTLDevice::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vtlDevices(Collection<VTLDevice> vtlDevices) {
            this.vtlDevices = VTLDevicesCopier.copy(vtlDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vtlDevices(VTLDevice... vtlDevices) {
            vtlDevices(Arrays.asList(vtlDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vtlDevices(Consumer<VTLDevice.Builder>... vtlDevices) {
            vtlDevices(Stream.of(vtlDevices).map(c -> VTLDevice.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVtlDevices(Collection<VTLDevice.BuilderImpl> vtlDevices) {
            this.vtlDevices = VTLDevicesCopier.copyFromBuilder(vtlDevices);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeVtlDevicesResponse build() {
            return new DescribeVtlDevicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
