/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * AttachVolumeInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetachVolumeRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<DetachVolumeRequest.Builder, DetachVolumeRequest> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeARN").getter(getter(DetachVolumeRequest::volumeARN)).setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final SdkField<Boolean> FORCE_DETACH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceDetach").getter(getter(DetachVolumeRequest::forceDetach)).setter(setter(Builder::forceDetach))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceDetach").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD,
            FORCE_DETACH_FIELD));

    private final String volumeARN;

    private final Boolean forceDetach;

    private DetachVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.volumeARN = builder.volumeARN;
        this.forceDetach = builder.forceDetach;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the volume to detach from the gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the volume to detach from the gateway.
     */
    public String volumeARN() {
        return volumeARN;
    }

    /**
     * <p>
     * Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume and detach the volume. The
     * default is <code>false</code>. If this value is set to <code>false</code>, you must manually disconnect the iSCSI
     * connection from the target volume.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume and detach the
     *         volume. The default is <code>false</code>. If this value is set to <code>false</code>, you must manually
     *         disconnect the iSCSI connection from the target volume.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public Boolean forceDetach() {
        return forceDetach;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(forceDetach());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachVolumeRequest)) {
            return false;
        }
        DetachVolumeRequest other = (DetachVolumeRequest) obj;
        return Objects.equals(volumeARN(), other.volumeARN()) && Objects.equals(forceDetach(), other.forceDetach());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetachVolumeRequest").add("VolumeARN", volumeARN()).add("ForceDetach", forceDetach()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        case "ForceDetach":
            return Optional.ofNullable(clazz.cast(forceDetach()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetachVolumeRequest, T> g) {
        return obj -> g.apply((DetachVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetachVolumeRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the volume to detach from the gateway.
         * </p>
         * 
         * @param volumeARN
         *        The Amazon Resource Name (ARN) of the volume to detach from the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);

        /**
         * <p>
         * Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume and detach the volume.
         * The default is <code>false</code>. If this value is set to <code>false</code>, you must manually disconnect
         * the iSCSI connection from the target volume.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param forceDetach
         *        Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume and detach the
         *        volume. The default is <code>false</code>. If this value is set to <code>false</code>, you must
         *        manually disconnect the iSCSI connection from the target volume.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDetach(Boolean forceDetach);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String volumeARN;

        private Boolean forceDetach;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachVolumeRequest model) {
            super(model);
            volumeARN(model.volumeARN);
            forceDetach(model.forceDetach);
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final Boolean getForceDetach() {
            return forceDetach;
        }

        @Override
        public final Builder forceDetach(Boolean forceDetach) {
            this.forceDetach = forceDetach;
            return this;
        }

        public final void setForceDetach(Boolean forceDetach) {
            this.forceDetach = forceDetach;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachVolumeRequest build() {
            return new DetachVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
