/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists iSCSI information about a VTL device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceiSCSIAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceiSCSIAttributes.Builder, DeviceiSCSIAttributes> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetARN").getter(getter(DeviceiSCSIAttributes::targetARN)).setter(setter(Builder::targetARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetARN").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId").getter(getter(DeviceiSCSIAttributes::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<Integer> NETWORK_INTERFACE_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkInterfacePort").getter(getter(DeviceiSCSIAttributes::networkInterfacePort))
            .setter(setter(Builder::networkInterfacePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfacePort").build())
            .build();

    private static final SdkField<Boolean> CHAP_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ChapEnabled").getter(getter(DeviceiSCSIAttributes::chapEnabled)).setter(setter(Builder::chapEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChapEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD,
            NETWORK_INTERFACE_ID_FIELD, NETWORK_INTERFACE_PORT_FIELD, CHAP_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetARN;

    private final String networkInterfaceId;

    private final Integer networkInterfacePort;

    private final Boolean chapEnabled;

    private DeviceiSCSIAttributes(BuilderImpl builder) {
        this.targetARN = builder.targetARN;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.networkInterfacePort = builder.networkInterfacePort;
        this.chapEnabled = builder.chapEnabled;
    }

    /**
     * <p>
     * Specifies the unique Amazon Resource Name (ARN) that encodes the iSCSI qualified name(iqn) of a tape drive or
     * media changer target.
     * </p>
     * 
     * @return Specifies the unique Amazon Resource Name (ARN) that encodes the iSCSI qualified name(iqn) of a tape
     *         drive or media changer target.
     */
    public String targetARN() {
        return targetARN;
    }

    /**
     * <p>
     * The network interface identifier of the VTL device.
     * </p>
     * 
     * @return The network interface identifier of the VTL device.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The port used to communicate with iSCSI VTL device targets.
     * </p>
     * 
     * @return The port used to communicate with iSCSI VTL device targets.
     */
    public Integer networkInterfacePort() {
        return networkInterfacePort;
    }

    /**
     * <p>
     * Indicates whether mutual CHAP is enabled for the iSCSI target.
     * </p>
     * 
     * @return Indicates whether mutual CHAP is enabled for the iSCSI target.
     */
    public Boolean chapEnabled() {
        return chapEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetARN());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfacePort());
        hashCode = 31 * hashCode + Objects.hashCode(chapEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceiSCSIAttributes)) {
            return false;
        }
        DeviceiSCSIAttributes other = (DeviceiSCSIAttributes) obj;
        return Objects.equals(targetARN(), other.targetARN()) && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(networkInterfacePort(), other.networkInterfacePort())
                && Objects.equals(chapEnabled(), other.chapEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeviceiSCSIAttributes").add("TargetARN", targetARN())
                .add("NetworkInterfaceId", networkInterfaceId()).add("NetworkInterfacePort", networkInterfacePort())
                .add("ChapEnabled", chapEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetARN":
            return Optional.ofNullable(clazz.cast(targetARN()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "NetworkInterfacePort":
            return Optional.ofNullable(clazz.cast(networkInterfacePort()));
        case "ChapEnabled":
            return Optional.ofNullable(clazz.cast(chapEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceiSCSIAttributes, T> g) {
        return obj -> g.apply((DeviceiSCSIAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceiSCSIAttributes> {
        /**
         * <p>
         * Specifies the unique Amazon Resource Name (ARN) that encodes the iSCSI qualified name(iqn) of a tape drive or
         * media changer target.
         * </p>
         * 
         * @param targetARN
         *        Specifies the unique Amazon Resource Name (ARN) that encodes the iSCSI qualified name(iqn) of a tape
         *        drive or media changer target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetARN(String targetARN);

        /**
         * <p>
         * The network interface identifier of the VTL device.
         * </p>
         * 
         * @param networkInterfaceId
         *        The network interface identifier of the VTL device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The port used to communicate with iSCSI VTL device targets.
         * </p>
         * 
         * @param networkInterfacePort
         *        The port used to communicate with iSCSI VTL device targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacePort(Integer networkInterfacePort);

        /**
         * <p>
         * Indicates whether mutual CHAP is enabled for the iSCSI target.
         * </p>
         * 
         * @param chapEnabled
         *        Indicates whether mutual CHAP is enabled for the iSCSI target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chapEnabled(Boolean chapEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String targetARN;

        private String networkInterfaceId;

        private Integer networkInterfacePort;

        private Boolean chapEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceiSCSIAttributes model) {
            targetARN(model.targetARN);
            networkInterfaceId(model.networkInterfaceId);
            networkInterfacePort(model.networkInterfacePort);
            chapEnabled(model.chapEnabled);
        }

        public final String getTargetARN() {
            return targetARN;
        }

        @Override
        public final Builder targetARN(String targetARN) {
            this.targetARN = targetARN;
            return this;
        }

        public final void setTargetARN(String targetARN) {
            this.targetARN = targetARN;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Integer getNetworkInterfacePort() {
            return networkInterfacePort;
        }

        @Override
        public final Builder networkInterfacePort(Integer networkInterfacePort) {
            this.networkInterfacePort = networkInterfacePort;
            return this;
        }

        public final void setNetworkInterfacePort(Integer networkInterfacePort) {
            this.networkInterfacePort = networkInterfacePort;
        }

        public final Boolean getChapEnabled() {
            return chapEnabled;
        }

        @Override
        public final Builder chapEnabled(Boolean chapEnabled) {
            this.chapEnabled = chapEnabled;
            return this;
        }

        public final void setChapEnabled(Boolean chapEnabled) {
            this.chapEnabled = chapEnabled;
        }

        @Override
        public DeviceiSCSIAttributes build() {
            return new DeviceiSCSIAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
