/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTapePoolsResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<ListTapePoolsResponse.Builder, ListTapePoolsResponse> {
    private static final SdkField<List<PoolInfo>> POOL_INFOS_FIELD = SdkField
            .<List<PoolInfo>> builder(MarshallingType.LIST)
            .memberName("PoolInfos")
            .getter(getter(ListTapePoolsResponse::poolInfos))
            .setter(setter(Builder::poolInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PoolInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(PoolInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListTapePoolsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(POOL_INFOS_FIELD, MARKER_FIELD));

    private final List<PoolInfo> poolInfos;

    private final String marker;

    private ListTapePoolsResponse(BuilderImpl builder) {
        super(builder);
        this.poolInfos = builder.poolInfos;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the PoolInfos property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPoolInfos() {
        return poolInfos != null && !(poolInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there are no
     * custom tape pools, the <code>PoolInfos</code> is an empty array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPoolInfos()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If
     *         there are no custom tape pools, the <code>PoolInfos</code> is an empty array.
     */
    public List<PoolInfo> poolInfos() {
        return poolInfos;
    }

    /**
     * <p>
     * A string that indicates the position at which to begin the returned list of tape pools. Use the marker in your
     * next request to continue pagination of tape pools. If there are no more tape pools to list, this element does not
     * appear in the response body.
     * </p>
     * 
     * @return A string that indicates the position at which to begin the returned list of tape pools. Use the marker in
     *         your next request to continue pagination of tape pools. If there are no more tape pools to list, this
     *         element does not appear in the response body.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPoolInfos() ? poolInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTapePoolsResponse)) {
            return false;
        }
        ListTapePoolsResponse other = (ListTapePoolsResponse) obj;
        return hasPoolInfos() == other.hasPoolInfos() && Objects.equals(poolInfos(), other.poolInfos())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTapePoolsResponse").add("PoolInfos", hasPoolInfos() ? poolInfos() : null)
                .add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolInfos":
            return Optional.ofNullable(clazz.cast(poolInfos()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTapePoolsResponse, T> g) {
        return obj -> g.apply((ListTapePoolsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTapePoolsResponse> {
        /**
         * <p>
         * An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there
         * are no custom tape pools, the <code>PoolInfos</code> is an empty array.
         * </p>
         * 
         * @param poolInfos
         *        An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If
         *        there are no custom tape pools, the <code>PoolInfos</code> is an empty array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolInfos(Collection<PoolInfo> poolInfos);

        /**
         * <p>
         * An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there
         * are no custom tape pools, the <code>PoolInfos</code> is an empty array.
         * </p>
         * 
         * @param poolInfos
         *        An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If
         *        there are no custom tape pools, the <code>PoolInfos</code> is an empty array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolInfos(PoolInfo... poolInfos);

        /**
         * <p>
         * An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there
         * are no custom tape pools, the <code>PoolInfos</code> is an empty array.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PoolInfo>.Builder} avoiding the need to
         * create one manually via {@link List<PoolInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PoolInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #poolInfos(List<PoolInfo>)}.
         * 
         * @param poolInfos
         *        a consumer that will call methods on {@link List<PoolInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #poolInfos(List<PoolInfo>)
         */
        Builder poolInfos(Consumer<PoolInfo.Builder>... poolInfos);

        /**
         * <p>
         * A string that indicates the position at which to begin the returned list of tape pools. Use the marker in
         * your next request to continue pagination of tape pools. If there are no more tape pools to list, this element
         * does not appear in the response body.
         * </p>
         * 
         * @param marker
         *        A string that indicates the position at which to begin the returned list of tape pools. Use the marker
         *        in your next request to continue pagination of tape pools. If there are no more tape pools to list,
         *        this element does not appear in the response body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<PoolInfo> poolInfos = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTapePoolsResponse model) {
            super(model);
            poolInfos(model.poolInfos);
            marker(model.marker);
        }

        public final Collection<PoolInfo.Builder> getPoolInfos() {
            if (poolInfos instanceof SdkAutoConstructList) {
                return null;
            }
            return poolInfos != null ? poolInfos.stream().map(PoolInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder poolInfos(Collection<PoolInfo> poolInfos) {
            this.poolInfos = PoolInfosCopier.copy(poolInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolInfos(PoolInfo... poolInfos) {
            poolInfos(Arrays.asList(poolInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolInfos(Consumer<PoolInfo.Builder>... poolInfos) {
            poolInfos(Stream.of(poolInfos).map(c -> PoolInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPoolInfos(Collection<PoolInfo.BuilderImpl> poolInfos) {
            this.poolInfos = PoolInfosCopier.copyFromBuilder(poolInfos);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListTapePoolsResponse build() {
            return new ListTapePoolsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
