/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAutomaticTapeCreationPolicyRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<UpdateAutomaticTapeCreationPolicyRequest.Builder, UpdateAutomaticTapeCreationPolicyRequest> {
    private static final SdkField<List<AutomaticTapeCreationRule>> AUTOMATIC_TAPE_CREATION_RULES_FIELD = SdkField
            .<List<AutomaticTapeCreationRule>> builder(MarshallingType.LIST)
            .memberName("AutomaticTapeCreationRules")
            .getter(getter(UpdateAutomaticTapeCreationPolicyRequest::automaticTapeCreationRules))
            .setter(setter(Builder::automaticTapeCreationRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticTapeCreationRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomaticTapeCreationRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomaticTapeCreationRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(UpdateAutomaticTapeCreationPolicyRequest::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATIC_TAPE_CREATION_RULES_FIELD, GATEWAY_ARN_FIELD));

    private final List<AutomaticTapeCreationRule> automaticTapeCreationRules;

    private final String gatewayARN;

    private UpdateAutomaticTapeCreationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.automaticTapeCreationRules = builder.automaticTapeCreationRules;
        this.gatewayARN = builder.gatewayARN;
    }

    /**
     * Returns true if the AutomaticTapeCreationRules property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasAutomaticTapeCreationRules() {
        return automaticTapeCreationRules != null && !(automaticTapeCreationRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An automatic tape creation policy consists of a list of automatic tape creation rules. The rules determine when
     * and how to automatically create new tapes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAutomaticTapeCreationRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An automatic tape creation policy consists of a list of automatic tape creation rules. The rules
     *         determine when and how to automatically create new tapes.
     */
    public List<AutomaticTapeCreationRule> automaticTapeCreationRules() {
        return automaticTapeCreationRules;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAutomaticTapeCreationRules() ? automaticTapeCreationRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomaticTapeCreationPolicyRequest)) {
            return false;
        }
        UpdateAutomaticTapeCreationPolicyRequest other = (UpdateAutomaticTapeCreationPolicyRequest) obj;
        return hasAutomaticTapeCreationRules() == other.hasAutomaticTapeCreationRules()
                && Objects.equals(automaticTapeCreationRules(), other.automaticTapeCreationRules())
                && Objects.equals(gatewayARN(), other.gatewayARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateAutomaticTapeCreationPolicyRequest")
                .add("AutomaticTapeCreationRules", hasAutomaticTapeCreationRules() ? automaticTapeCreationRules() : null)
                .add("GatewayARN", gatewayARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticTapeCreationRules":
            return Optional.ofNullable(clazz.cast(automaticTapeCreationRules()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomaticTapeCreationPolicyRequest, T> g) {
        return obj -> g.apply((UpdateAutomaticTapeCreationPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAutomaticTapeCreationPolicyRequest> {
        /**
         * <p>
         * An automatic tape creation policy consists of a list of automatic tape creation rules. The rules determine
         * when and how to automatically create new tapes.
         * </p>
         * 
         * @param automaticTapeCreationRules
         *        An automatic tape creation policy consists of a list of automatic tape creation rules. The rules
         *        determine when and how to automatically create new tapes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticTapeCreationRules(Collection<AutomaticTapeCreationRule> automaticTapeCreationRules);

        /**
         * <p>
         * An automatic tape creation policy consists of a list of automatic tape creation rules. The rules determine
         * when and how to automatically create new tapes.
         * </p>
         * 
         * @param automaticTapeCreationRules
         *        An automatic tape creation policy consists of a list of automatic tape creation rules. The rules
         *        determine when and how to automatically create new tapes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticTapeCreationRules(AutomaticTapeCreationRule... automaticTapeCreationRules);

        /**
         * <p>
         * An automatic tape creation policy consists of a list of automatic tape creation rules. The rules determine
         * when and how to automatically create new tapes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AutomaticTapeCreationRule>.Builder}
         * avoiding the need to create one manually via {@link List<AutomaticTapeCreationRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutomaticTapeCreationRule>.Builder#build()} is called
         * immediately and its result is passed to {@link #automaticTapeCreationRules(List<AutomaticTapeCreationRule>)}.
         * 
         * @param automaticTapeCreationRules
         *        a consumer that will call methods on {@link List<AutomaticTapeCreationRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automaticTapeCreationRules(List<AutomaticTapeCreationRule>)
         */
        Builder automaticTapeCreationRules(Consumer<AutomaticTapeCreationRule.Builder>... automaticTapeCreationRules);

        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private List<AutomaticTapeCreationRule> automaticTapeCreationRules = DefaultSdkAutoConstructList.getInstance();

        private String gatewayARN;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomaticTapeCreationPolicyRequest model) {
            super(model);
            automaticTapeCreationRules(model.automaticTapeCreationRules);
            gatewayARN(model.gatewayARN);
        }

        public final Collection<AutomaticTapeCreationRule.Builder> getAutomaticTapeCreationRules() {
            if (automaticTapeCreationRules instanceof SdkAutoConstructList) {
                return null;
            }
            return automaticTapeCreationRules != null ? automaticTapeCreationRules.stream()
                    .map(AutomaticTapeCreationRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder automaticTapeCreationRules(Collection<AutomaticTapeCreationRule> automaticTapeCreationRules) {
            this.automaticTapeCreationRules = AutomaticTapeCreationRulesCopier.copy(automaticTapeCreationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automaticTapeCreationRules(AutomaticTapeCreationRule... automaticTapeCreationRules) {
            automaticTapeCreationRules(Arrays.asList(automaticTapeCreationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automaticTapeCreationRules(Consumer<AutomaticTapeCreationRule.Builder>... automaticTapeCreationRules) {
            automaticTapeCreationRules(Stream.of(automaticTapeCreationRules)
                    .map(c -> AutomaticTapeCreationRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAutomaticTapeCreationRules(
                Collection<AutomaticTapeCreationRule.BuilderImpl> automaticTapeCreationRules) {
            this.automaticTapeCreationRules = AutomaticTapeCreationRulesCopier.copyFromBuilder(automaticTapeCreationRules);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutomaticTapeCreationPolicyRequest build() {
            return new UpdateAutomaticTapeCreationPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
