/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.VTLDevice;
import software.amazon.awssdk.services.storagegateway.model.VTLDevicesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVtlDevicesResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeVtlDevicesResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(DescribeVtlDevicesResponse.getter(DescribeVtlDevicesResponse::gatewayARN)).setter(DescribeVtlDevicesResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<List<VTLDevice>> VTL_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VTLDevices").getter(DescribeVtlDevicesResponse.getter(DescribeVtlDevicesResponse::vtlDevices)).setter(DescribeVtlDevicesResponse.setter(Builder::vtlDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VTLDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeVtlDevicesResponse.getter(DescribeVtlDevicesResponse::marker)).setter(DescribeVtlDevicesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, VTL_DEVICES_FIELD, MARKER_FIELD));
    private final String gatewayARN;
    private final List<VTLDevice> vtlDevices;
    private final String marker;

    private DescribeVtlDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.vtlDevices = builder.vtlDevices;
        this.marker = builder.marker;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final boolean hasVtlDevices() {
        return this.vtlDevices != null && !(this.vtlDevices instanceof SdkAutoConstructList);
    }

    public final List<VTLDevice> vtlDevices() {
        return this.vtlDevices;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVtlDevices() ? this.vtlDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVtlDevicesResponse)) {
            return false;
        }
        DescribeVtlDevicesResponse other = (DescribeVtlDevicesResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && this.hasVtlDevices() == other.hasVtlDevices() && Objects.equals(this.vtlDevices(), other.vtlDevices()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVtlDevicesResponse").add("GatewayARN", (Object)this.gatewayARN()).add("VTLDevices", this.hasVtlDevices() ? this.vtlDevices() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "VTLDevices": {
                return Optional.ofNullable(clazz.cast(this.vtlDevices()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVtlDevicesResponse, T> g) {
        return obj -> g.apply((DescribeVtlDevicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private List<VTLDevice> vtlDevices = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVtlDevicesResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.vtlDevices(model.vtlDevices);
            this.marker(model.marker);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<VTLDevice.Builder> getVtlDevices() {
            if (this.vtlDevices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vtlDevices != null ? (Collection)this.vtlDevices.stream().map(VTLDevice::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vtlDevices(Collection<VTLDevice> vtlDevices) {
            this.vtlDevices = VTLDevicesCopier.copy(vtlDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vtlDevices(VTLDevice ... vtlDevices) {
            this.vtlDevices(Arrays.asList(vtlDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vtlDevices(Consumer<VTLDevice.Builder> ... vtlDevices) {
            this.vtlDevices(Stream.of(vtlDevices).map(c -> (VTLDevice)((VTLDevice.Builder)VTLDevice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVtlDevices(Collection<VTLDevice.BuilderImpl> vtlDevices) {
            this.vtlDevices = VTLDevicesCopier.copyFromBuilder(vtlDevices);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeVtlDevicesResponse build() {
            return new DescribeVtlDevicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVtlDevicesResponse> {
        public Builder gatewayARN(String var1);

        public Builder vtlDevices(Collection<VTLDevice> var1);

        public Builder vtlDevices(VTLDevice ... var1);

        public Builder vtlDevices(Consumer<VTLDevice.Builder> ... var1);

        public Builder marker(String var1);
    }
}

