/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.GatewayInfo;
import software.amazon.awssdk.services.storagegateway.model.GatewaysCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGatewaysResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, ListGatewaysResponse> {
    private static final SdkField<List<GatewayInfo>> GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Gateways").getter(ListGatewaysResponse.getter(ListGatewaysResponse::gateways)).setter(ListGatewaysResponse.setter(Builder::gateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gateways").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GatewayInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListGatewaysResponse.getter(ListGatewaysResponse::marker)).setter(ListGatewaysResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAYS_FIELD, MARKER_FIELD));
    private final List<GatewayInfo> gateways;
    private final String marker;

    private ListGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.gateways = builder.gateways;
        this.marker = builder.marker;
    }

    public final boolean hasGateways() {
        return this.gateways != null && !(this.gateways instanceof SdkAutoConstructList);
    }

    public final List<GatewayInfo> gateways() {
        return this.gateways;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGateways() ? this.gateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGatewaysResponse)) {
            return false;
        }
        ListGatewaysResponse other = (ListGatewaysResponse)((Object)obj);
        return this.hasGateways() == other.hasGateways() && Objects.equals(this.gateways(), other.gateways()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListGatewaysResponse").add("Gateways", this.hasGateways() ? this.gateways() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Gateways": {
                return Optional.ofNullable(clazz.cast(this.gateways()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGatewaysResponse, T> g) {
        return obj -> g.apply((ListGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<GatewayInfo> gateways = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGatewaysResponse model) {
            super(model);
            this.gateways(model.gateways);
            this.marker(model.marker);
        }

        public final Collection<GatewayInfo.Builder> getGateways() {
            if (this.gateways instanceof SdkAutoConstructList) {
                return null;
            }
            return this.gateways != null ? (Collection)this.gateways.stream().map(GatewayInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gateways(Collection<GatewayInfo> gateways) {
            this.gateways = GatewaysCopier.copy(gateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gateways(GatewayInfo ... gateways) {
            this.gateways(Arrays.asList(gateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gateways(Consumer<GatewayInfo.Builder> ... gateways) {
            this.gateways(Stream.of(gateways).map(c -> (GatewayInfo)((GatewayInfo.Builder)GatewayInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGateways(Collection<GatewayInfo.BuilderImpl> gateways) {
            this.gateways = GatewaysCopier.copyFromBuilder(gateways);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListGatewaysResponse build() {
            return new ListGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGatewaysResponse> {
        public Builder gateways(Collection<GatewayInfo> var1);

        public Builder gateways(GatewayInfo ... var1);

        public Builder gateways(Consumer<GatewayInfo.Builder> ... var1);

        public Builder marker(String var1);
    }
}

