/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.Tape;
import software.amazon.awssdk.services.storagegateway.model.TapesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTapesResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeTapesResponse> {
    private static final SdkField<List<Tape>> TAPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tapes").getter(DescribeTapesResponse.getter(DescribeTapesResponse::tapes)).setter(DescribeTapesResponse.setter(Builder::tapes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tapes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tape::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeTapesResponse.getter(DescribeTapesResponse::marker)).setter(DescribeTapesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPES_FIELD, MARKER_FIELD));
    private final List<Tape> tapes;
    private final String marker;

    private DescribeTapesResponse(BuilderImpl builder) {
        super(builder);
        this.tapes = builder.tapes;
        this.marker = builder.marker;
    }

    public final boolean hasTapes() {
        return this.tapes != null && !(this.tapes instanceof SdkAutoConstructList);
    }

    public final List<Tape> tapes() {
        return this.tapes;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTapes() ? this.tapes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTapesResponse)) {
            return false;
        }
        DescribeTapesResponse other = (DescribeTapesResponse)((Object)obj);
        return this.hasTapes() == other.hasTapes() && Objects.equals(this.tapes(), other.tapes()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTapesResponse").add("Tapes", this.hasTapes() ? this.tapes() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tapes": {
                return Optional.ofNullable(clazz.cast(this.tapes()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTapesResponse, T> g) {
        return obj -> g.apply((DescribeTapesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<Tape> tapes = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTapesResponse model) {
            super(model);
            this.tapes(model.tapes);
            this.marker(model.marker);
        }

        public final Collection<Tape.Builder> getTapes() {
            if (this.tapes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tapes != null ? (Collection)this.tapes.stream().map(Tape::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tapes(Collection<Tape> tapes) {
            this.tapes = TapesCopier.copy(tapes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapes(Tape ... tapes) {
            this.tapes(Arrays.asList(tapes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapes(Consumer<Tape.Builder> ... tapes) {
            this.tapes(Stream.of(tapes).map(c -> (Tape)((Tape.Builder)Tape.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTapes(Collection<Tape.BuilderImpl> tapes) {
            this.tapes = TapesCopier.copyFromBuilder(tapes);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeTapesResponse build() {
            return new DescribeTapesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTapesResponse> {
        public Builder tapes(Collection<Tape> var1);

        public Builder tapes(Tape ... var1);

        public Builder tapes(Consumer<Tape.Builder> ... var1);

        public Builder marker(String var1);
    }
}

