/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationSummary;
import software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationSummaryListCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFileSystemAssociationsResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, ListFileSystemAssociationsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListFileSystemAssociationsResponse.getter(ListFileSystemAssociationsResponse::marker)).setter(ListFileSystemAssociationsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListFileSystemAssociationsResponse.getter(ListFileSystemAssociationsResponse::nextMarker)).setter(ListFileSystemAssociationsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<FileSystemAssociationSummary>> FILE_SYSTEM_ASSOCIATION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileSystemAssociationSummaryList").getter(ListFileSystemAssociationsResponse.getter(ListFileSystemAssociationsResponse::fileSystemAssociationSummaryList)).setter(ListFileSystemAssociationsResponse.setter(Builder::fileSystemAssociationSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileSystemAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, NEXT_MARKER_FIELD, FILE_SYSTEM_ASSOCIATION_SUMMARY_LIST_FIELD));
    private final String marker;
    private final String nextMarker;
    private final List<FileSystemAssociationSummary> fileSystemAssociationSummaryList;

    private ListFileSystemAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.fileSystemAssociationSummaryList = builder.fileSystemAssociationSummaryList;
    }

    public final String marker() {
        return this.marker;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasFileSystemAssociationSummaryList() {
        return this.fileSystemAssociationSummaryList != null && !(this.fileSystemAssociationSummaryList instanceof SdkAutoConstructList);
    }

    public final List<FileSystemAssociationSummary> fileSystemAssociationSummaryList() {
        return this.fileSystemAssociationSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemAssociationSummaryList() ? this.fileSystemAssociationSummaryList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFileSystemAssociationsResponse)) {
            return false;
        }
        ListFileSystemAssociationsResponse other = (ListFileSystemAssociationsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasFileSystemAssociationSummaryList() == other.hasFileSystemAssociationSummaryList() && Objects.equals(this.fileSystemAssociationSummaryList(), other.fileSystemAssociationSummaryList());
    }

    public final String toString() {
        return ToString.builder((String)"ListFileSystemAssociationsResponse").add("Marker", (Object)this.marker()).add("NextMarker", (Object)this.nextMarker()).add("FileSystemAssociationSummaryList", this.hasFileSystemAssociationSummaryList() ? this.fileSystemAssociationSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "FileSystemAssociationSummaryList": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAssociationSummaryList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFileSystemAssociationsResponse, T> g) {
        return obj -> g.apply((ListFileSystemAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String marker;
        private String nextMarker;
        private List<FileSystemAssociationSummary> fileSystemAssociationSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFileSystemAssociationsResponse model) {
            super(model);
            this.marker(model.marker);
            this.nextMarker(model.nextMarker);
            this.fileSystemAssociationSummaryList(model.fileSystemAssociationSummaryList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final List<FileSystemAssociationSummary.Builder> getFileSystemAssociationSummaryList() {
            List<FileSystemAssociationSummary.Builder> result = FileSystemAssociationSummaryListCopier.copyToBuilder(this.fileSystemAssociationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder fileSystemAssociationSummaryList(Collection<FileSystemAssociationSummary> fileSystemAssociationSummaryList) {
            this.fileSystemAssociationSummaryList = FileSystemAssociationSummaryListCopier.copy(fileSystemAssociationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemAssociationSummaryList(FileSystemAssociationSummary ... fileSystemAssociationSummaryList) {
            this.fileSystemAssociationSummaryList(Arrays.asList(fileSystemAssociationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemAssociationSummaryList(Consumer<FileSystemAssociationSummary.Builder> ... fileSystemAssociationSummaryList) {
            this.fileSystemAssociationSummaryList(Stream.of(fileSystemAssociationSummaryList).map(c -> (FileSystemAssociationSummary)((FileSystemAssociationSummary.Builder)FileSystemAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFileSystemAssociationSummaryList(Collection<FileSystemAssociationSummary.BuilderImpl> fileSystemAssociationSummaryList) {
            this.fileSystemAssociationSummaryList = FileSystemAssociationSummaryListCopier.copyFromBuilder(fileSystemAssociationSummaryList);
        }

        @Override
        public ListFileSystemAssociationsResponse build() {
            return new ListFileSystemAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFileSystemAssociationsResponse> {
        public Builder marker(String var1);

        public Builder nextMarker(String var1);

        public Builder fileSystemAssociationSummaryList(Collection<FileSystemAssociationSummary> var1);

        public Builder fileSystemAssociationSummaryList(FileSystemAssociationSummary ... var1);

        public Builder fileSystemAssociationSummaryList(Consumer<FileSystemAssociationSummary.Builder> ... var1);
    }
}

