/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.CacheAttributes;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFileSystemAssociationRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, UpdateFileSystemAssociationRequest> {
    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemAssociationARN").getter(UpdateFileSystemAssociationRequest.getter(UpdateFileSystemAssociationRequest::fileSystemAssociationARN)).setter(UpdateFileSystemAssociationRequest.setter(Builder::fileSystemAssociationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationARN").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(UpdateFileSystemAssociationRequest.getter(UpdateFileSystemAssociationRequest::userName)).setter(UpdateFileSystemAssociationRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(UpdateFileSystemAssociationRequest.getter(UpdateFileSystemAssociationRequest::password)).setter(UpdateFileSystemAssociationRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<String> AUDIT_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditDestinationARN").getter(UpdateFileSystemAssociationRequest.getter(UpdateFileSystemAssociationRequest::auditDestinationARN)).setter(UpdateFileSystemAssociationRequest.setter(Builder::auditDestinationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditDestinationARN").build()}).build();
    private static final SdkField<CacheAttributes> CACHE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheAttributes").getter(UpdateFileSystemAssociationRequest.getter(UpdateFileSystemAssociationRequest::cacheAttributes)).setter(UpdateFileSystemAssociationRequest.setter(Builder::cacheAttributes)).constructor(CacheAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ASSOCIATION_ARN_FIELD, USER_NAME_FIELD, PASSWORD_FIELD, AUDIT_DESTINATION_ARN_FIELD, CACHE_ATTRIBUTES_FIELD));
    private final String fileSystemAssociationARN;
    private final String userName;
    private final String password;
    private final String auditDestinationARN;
    private final CacheAttributes cacheAttributes;

    private UpdateFileSystemAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemAssociationARN = builder.fileSystemAssociationARN;
        this.userName = builder.userName;
        this.password = builder.password;
        this.auditDestinationARN = builder.auditDestinationARN;
        this.cacheAttributes = builder.cacheAttributes;
    }

    public final String fileSystemAssociationARN() {
        return this.fileSystemAssociationARN;
    }

    public final String userName() {
        return this.userName;
    }

    public final String password() {
        return this.password;
    }

    public final String auditDestinationARN() {
        return this.auditDestinationARN;
    }

    public final CacheAttributes cacheAttributes() {
        return this.cacheAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemAssociationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditDestinationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemAssociationRequest)) {
            return false;
        }
        UpdateFileSystemAssociationRequest other = (UpdateFileSystemAssociationRequest)((Object)obj);
        return Objects.equals(this.fileSystemAssociationARN(), other.fileSystemAssociationARN()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.auditDestinationARN(), other.auditDestinationARN()) && Objects.equals(this.cacheAttributes(), other.cacheAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFileSystemAssociationRequest").add("FileSystemAssociationARN", (Object)this.fileSystemAssociationARN()).add("UserName", (Object)this.userName()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("AuditDestinationARN", (Object)this.auditDestinationARN()).add("CacheAttributes", (Object)this.cacheAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemAssociationARN": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAssociationARN()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "AuditDestinationARN": {
                return Optional.ofNullable(clazz.cast(this.auditDestinationARN()));
            }
            case "CacheAttributes": {
                return Optional.ofNullable(clazz.cast(this.cacheAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemAssociationRequest, T> g) {
        return obj -> g.apply((UpdateFileSystemAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String fileSystemAssociationARN;
        private String userName;
        private String password;
        private String auditDestinationARN;
        private CacheAttributes cacheAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemAssociationRequest model) {
            super(model);
            this.fileSystemAssociationARN(model.fileSystemAssociationARN);
            this.userName(model.userName);
            this.password(model.password);
            this.auditDestinationARN(model.auditDestinationARN);
            this.cacheAttributes(model.cacheAttributes);
        }

        public final String getFileSystemAssociationARN() {
            return this.fileSystemAssociationARN;
        }

        @Override
        public final Builder fileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
            return this;
        }

        public final void setFileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getAuditDestinationARN() {
            return this.auditDestinationARN;
        }

        @Override
        public final Builder auditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
            return this;
        }

        public final void setAuditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
        }

        public final CacheAttributes.Builder getCacheAttributes() {
            return this.cacheAttributes != null ? this.cacheAttributes.toBuilder() : null;
        }

        @Override
        public final Builder cacheAttributes(CacheAttributes cacheAttributes) {
            this.cacheAttributes = cacheAttributes;
            return this;
        }

        public final void setCacheAttributes(CacheAttributes.BuilderImpl cacheAttributes) {
            this.cacheAttributes = cacheAttributes != null ? cacheAttributes.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFileSystemAssociationRequest build() {
            return new UpdateFileSystemAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFileSystemAssociationRequest> {
        public Builder fileSystemAssociationARN(String var1);

        public Builder userName(String var1);

        public Builder password(String var1);

        public Builder auditDestinationARN(String var1);

        public Builder cacheAttributes(CacheAttributes var1);

        default public Builder cacheAttributes(Consumer<CacheAttributes.Builder> cacheAttributes) {
            return this.cacheAttributes((CacheAttributes)((CacheAttributes.Builder)CacheAttributes.builder().applyMutation(cacheAttributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

