/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>ListTapesOutput$Marker</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListTapesOutput$VolumeInfos</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTapesResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<ListTapesResponse.Builder, ListTapesResponse> {
    private static final SdkField<List<TapeInfo>> TAPE_INFOS_FIELD = SdkField
            .<List<TapeInfo>> builder(MarshallingType.LIST)
            .memberName("TapeInfos")
            .getter(getter(ListTapesResponse::tapeInfos))
            .setter(setter(Builder::tapeInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TapeInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(TapeInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListTapesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TAPE_INFOS_FIELD, MARKER_FIELD));

    private final List<TapeInfo> tapeInfos;

    private final String marker;

    private ListTapesResponse(BuilderImpl builder) {
        super(builder);
        this.tapeInfos = builder.tapeInfos;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the TapeInfos property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTapeInfos() {
        return tapeInfos != null && !(tapeInfos instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TapeInfos property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTapeInfos()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the TapeInfos property for this object.
     */
    public final List<TapeInfo> tapeInfos() {
        return tapeInfos;
    }

    /**
     * <p>
     * A string that indicates the position at which to begin returning the next list of tapes. Use the marker in your
     * next request to continue pagination of tapes. If there are no more tapes to list, this element does not appear in
     * the response body.
     * </p>
     * 
     * @return A string that indicates the position at which to begin returning the next list of tapes. Use the marker
     *         in your next request to continue pagination of tapes. If there are no more tapes to list, this element
     *         does not appear in the response body.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTapeInfos() ? tapeInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTapesResponse)) {
            return false;
        }
        ListTapesResponse other = (ListTapesResponse) obj;
        return hasTapeInfos() == other.hasTapeInfos() && Objects.equals(tapeInfos(), other.tapeInfos())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTapesResponse").add("TapeInfos", hasTapeInfos() ? tapeInfos() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeInfos":
            return Optional.ofNullable(clazz.cast(tapeInfos()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTapesResponse, T> g) {
        return obj -> g.apply((ListTapesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTapesResponse> {
        /**
         * Sets the value of the TapeInfos property for this object.
         *
         * @param tapeInfos
         *        The new value for the TapeInfos property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeInfos(Collection<TapeInfo> tapeInfos);

        /**
         * Sets the value of the TapeInfos property for this object.
         *
         * @param tapeInfos
         *        The new value for the TapeInfos property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeInfos(TapeInfo... tapeInfos);

        /**
         * Sets the value of the TapeInfos property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<TapeInfo>.Builder} avoiding the need to
         * create one manually via {@link List<TapeInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TapeInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #tapeInfos(List<TapeInfo>)}.
         * 
         * @param tapeInfos
         *        a consumer that will call methods on {@link List<TapeInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tapeInfos(List<TapeInfo>)
         */
        Builder tapeInfos(Consumer<TapeInfo.Builder>... tapeInfos);

        /**
         * <p>
         * A string that indicates the position at which to begin returning the next list of tapes. Use the marker in
         * your next request to continue pagination of tapes. If there are no more tapes to list, this element does not
         * appear in the response body.
         * </p>
         * 
         * @param marker
         *        A string that indicates the position at which to begin returning the next list of tapes. Use the
         *        marker in your next request to continue pagination of tapes. If there are no more tapes to list, this
         *        element does not appear in the response body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<TapeInfo> tapeInfos = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTapesResponse model) {
            super(model);
            tapeInfos(model.tapeInfos);
            marker(model.marker);
        }

        public final List<TapeInfo.Builder> getTapeInfos() {
            List<TapeInfo.Builder> result = TapeInfosCopier.copyToBuilder(this.tapeInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tapeInfos(Collection<TapeInfo> tapeInfos) {
            this.tapeInfos = TapeInfosCopier.copy(tapeInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeInfos(TapeInfo... tapeInfos) {
            tapeInfos(Arrays.asList(tapeInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeInfos(Consumer<TapeInfo.Builder>... tapeInfos) {
            tapeInfos(Stream.of(tapeInfos).map(c -> TapeInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTapeInfos(Collection<TapeInfo.BuilderImpl> tapeInfos) {
            this.tapeInfos = TapeInfosCopier.copyFromBuilder(tapeInfos);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListTapesResponse build() {
            return new ListTapesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
