/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTapePoolResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<CreateTapePoolResponse.Builder, CreateTapePoolResponse> {
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolARN").getter(getter(CreateTapePoolResponse::poolARN)).setter(setter(Builder::poolARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ARN_FIELD));

    private final String poolARN;

    private CreateTapePoolResponse(BuilderImpl builder) {
        super(builder);
        this.poolARN = builder.poolARN;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) that represents the custom tape pool. Use the <a>ListTapePools</a>
     * operation to return a list of tape pools for your account and AWS Region.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) that represents the custom tape pool. Use the <a>ListTapePools</a>
     *         operation to return a list of tape pools for your account and AWS Region.
     */
    public final String poolARN() {
        return poolARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTapePoolResponse)) {
            return false;
        }
        CreateTapePoolResponse other = (CreateTapePoolResponse) obj;
        return Objects.equals(poolARN(), other.poolARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTapePoolResponse").add("PoolARN", poolARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolARN":
            return Optional.ofNullable(clazz.cast(poolARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTapePoolResponse, T> g) {
        return obj -> g.apply((CreateTapePoolResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTapePoolResponse> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) that represents the custom tape pool. Use the <a>ListTapePools</a>
         * operation to return a list of tape pools for your account and AWS Region.
         * </p>
         * 
         * @param poolARN
         *        The unique Amazon Resource Name (ARN) that represents the custom tape pool. Use the
         *        <a>ListTapePools</a> operation to return a list of tape pools for your account and AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolARN(String poolARN);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String poolARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTapePoolResponse model) {
            super(model);
            poolARN(model.poolARN);
        }

        public final String getPoolARN() {
            return poolARN;
        }

        @Override
        public final Builder poolARN(String poolARN) {
            this.poolARN = poolARN;
            return this;
        }

        public final void setPoolARN(String poolARN) {
            this.poolARN = poolARN;
        }

        @Override
        public CreateTapePoolResponse build() {
            return new CreateTapePoolResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
