/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeChapCredentialsResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeChapCredentialsResponse.Builder, DescribeChapCredentialsResponse> {
    private static final SdkField<List<ChapInfo>> CHAP_CREDENTIALS_FIELD = SdkField
            .<List<ChapInfo>> builder(MarshallingType.LIST)
            .memberName("ChapCredentials")
            .getter(getter(DescribeChapCredentialsResponse::chapCredentials))
            .setter(setter(Builder::chapCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChapCredentials").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChapInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChapInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAP_CREDENTIALS_FIELD));

    private final List<ChapInfo> chapCredentials;

    private DescribeChapCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.chapCredentials = builder.chapCredentials;
    }

    /**
     * Returns true if the ChapCredentials property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasChapCredentials() {
        return chapCredentials != null && !(chapCredentials instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>ChapInfo</a> objects that represent CHAP credentials. Each object in the array contains CHAP
     * credential information for one target-initiator pair. If no CHAP credentials are set, an empty array is returned.
     * CHAP credential information is provided in a JSON object with the following fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>InitiatorName</b>: The iSCSI initiator that connects to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows client) must
     * provide to participate in mutual CHAP with the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in mutual CHAP with
     * the initiator (e.g. Windows client).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChapCredentials()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <a>ChapInfo</a> objects that represent CHAP credentials. Each object in the array contains
     *         CHAP credential information for one target-initiator pair. If no CHAP credentials are set, an empty array
     *         is returned. CHAP credential information is provided in a JSON object with the following fields:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>InitiatorName</b>: The iSCSI initiator that connects to the target.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows client)
     *         must provide to participate in mutual CHAP with the target.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in mutual
     *         CHAP with the initiator (e.g. Windows client).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.
     *         </p>
     *         </li>
     */
    public final List<ChapInfo> chapCredentials() {
        return chapCredentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChapCredentials() ? chapCredentials() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChapCredentialsResponse)) {
            return false;
        }
        DescribeChapCredentialsResponse other = (DescribeChapCredentialsResponse) obj;
        return hasChapCredentials() == other.hasChapCredentials() && Objects.equals(chapCredentials(), other.chapCredentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeChapCredentialsResponse")
                .add("ChapCredentials", hasChapCredentials() ? chapCredentials() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChapCredentials":
            return Optional.ofNullable(clazz.cast(chapCredentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeChapCredentialsResponse, T> g) {
        return obj -> g.apply((DescribeChapCredentialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeChapCredentialsResponse> {
        /**
         * <p>
         * An array of <a>ChapInfo</a> objects that represent CHAP credentials. Each object in the array contains CHAP
         * credential information for one target-initiator pair. If no CHAP credentials are set, an empty array is
         * returned. CHAP credential information is provided in a JSON object with the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>InitiatorName</b>: The iSCSI initiator that connects to the target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows client)
         * must provide to participate in mutual CHAP with the target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in mutual CHAP
         * with the initiator (e.g. Windows client).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.
         * </p>
         * </li>
         * </ul>
         * 
         * @param chapCredentials
         *        An array of <a>ChapInfo</a> objects that represent CHAP credentials. Each object in the array contains
         *        CHAP credential information for one target-initiator pair. If no CHAP credentials are set, an empty
         *        array is returned. CHAP credential information is provided in a JSON object with the following
         *        fields:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>InitiatorName</b>: The iSCSI initiator that connects to the target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows
         *        client) must provide to participate in mutual CHAP with the target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in
         *        mutual CHAP with the initiator (e.g. Windows client).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chapCredentials(Collection<ChapInfo> chapCredentials);

        /**
         * <p>
         * An array of <a>ChapInfo</a> objects that represent CHAP credentials. Each object in the array contains CHAP
         * credential information for one target-initiator pair. If no CHAP credentials are set, an empty array is
         * returned. CHAP credential information is provided in a JSON object with the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>InitiatorName</b>: The iSCSI initiator that connects to the target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows client)
         * must provide to participate in mutual CHAP with the target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in mutual CHAP
         * with the initiator (e.g. Windows client).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.
         * </p>
         * </li>
         * </ul>
         * 
         * @param chapCredentials
         *        An array of <a>ChapInfo</a> objects that represent CHAP credentials. Each object in the array contains
         *        CHAP credential information for one target-initiator pair. If no CHAP credentials are set, an empty
         *        array is returned. CHAP credential information is provided in a JSON object with the following
         *        fields:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>InitiatorName</b>: The iSCSI initiator that connects to the target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows
         *        client) must provide to participate in mutual CHAP with the target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in
         *        mutual CHAP with the initiator (e.g. Windows client).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chapCredentials(ChapInfo... chapCredentials);

        /**
         * <p>
         * An array of <a>ChapInfo</a> objects that represent CHAP credentials. Each object in the array contains CHAP
         * credential information for one target-initiator pair. If no CHAP credentials are set, an empty array is
         * returned. CHAP credential information is provided in a JSON object with the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>InitiatorName</b>: The iSCSI initiator that connects to the target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows client)
         * must provide to participate in mutual CHAP with the target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in mutual CHAP
         * with the initiator (e.g. Windows client).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<ChapInfo>.Builder} avoiding the need to
         * create one manually via {@link List<ChapInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChapInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #chapCredentials(List<ChapInfo>)}.
         * 
         * @param chapCredentials
         *        a consumer that will call methods on {@link List<ChapInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chapCredentials(List<ChapInfo>)
         */
        Builder chapCredentials(Consumer<ChapInfo.Builder>... chapCredentials);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<ChapInfo> chapCredentials = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChapCredentialsResponse model) {
            super(model);
            chapCredentials(model.chapCredentials);
        }

        public final List<ChapInfo.Builder> getChapCredentials() {
            List<ChapInfo.Builder> result = ChapCredentialsCopier.copyToBuilder(this.chapCredentials);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder chapCredentials(Collection<ChapInfo> chapCredentials) {
            this.chapCredentials = ChapCredentialsCopier.copy(chapCredentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder chapCredentials(ChapInfo... chapCredentials) {
            chapCredentials(Arrays.asList(chapCredentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder chapCredentials(Consumer<ChapInfo.Builder>... chapCredentials) {
            chapCredentials(Stream.of(chapCredentials).map(c -> ChapInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setChapCredentials(Collection<ChapInfo.BuilderImpl> chapCredentials) {
            this.chapCredentials = ChapCredentialsCopier.copyFromBuilder(chapCredentials);
        }

        @Override
        public DescribeChapCredentialsResponse build() {
            return new DescribeChapCredentialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
