/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachVolumeRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, AttachVolumeRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(AttachVolumeRequest.getter(AttachVolumeRequest::gatewayARN)).setter(AttachVolumeRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetName").getter(AttachVolumeRequest.getter(AttachVolumeRequest::targetName)).setter(AttachVolumeRequest.setter(Builder::targetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetName").build()}).build();
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeARN").getter(AttachVolumeRequest.getter(AttachVolumeRequest::volumeARN)).setter(AttachVolumeRequest.setter(Builder::volumeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(AttachVolumeRequest.getter(AttachVolumeRequest::networkInterfaceId)).setter(AttachVolumeRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<String> DISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiskId").getter(AttachVolumeRequest.getter(AttachVolumeRequest::diskId)).setter(AttachVolumeRequest.setter(Builder::diskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, TARGET_NAME_FIELD, VOLUME_ARN_FIELD, NETWORK_INTERFACE_ID_FIELD, DISK_ID_FIELD));
    private final String gatewayARN;
    private final String targetName;
    private final String volumeARN;
    private final String networkInterfaceId;
    private final String diskId;

    private AttachVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.targetName = builder.targetName;
        this.volumeARN = builder.volumeARN;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.diskId = builder.diskId;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final String targetName() {
        return this.targetName;
    }

    public final String volumeARN() {
        return this.volumeARN;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String diskId() {
        return this.diskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachVolumeRequest)) {
            return false;
        }
        AttachVolumeRequest other = (AttachVolumeRequest)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.targetName(), other.targetName()) && Objects.equals(this.volumeARN(), other.volumeARN()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.diskId(), other.diskId());
    }

    public final String toString() {
        return ToString.builder((String)"AttachVolumeRequest").add("GatewayARN", (Object)this.gatewayARN()).add("TargetName", (Object)this.targetName()).add("VolumeARN", (Object)this.volumeARN()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("DiskId", (Object)this.diskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "TargetName": {
                return Optional.ofNullable(clazz.cast(this.targetName()));
            }
            case "VolumeARN": {
                return Optional.ofNullable(clazz.cast(this.volumeARN()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "DiskId": {
                return Optional.ofNullable(clazz.cast(this.diskId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachVolumeRequest, T> g) {
        return obj -> g.apply((AttachVolumeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private String targetName;
        private String volumeARN;
        private String networkInterfaceId;
        private String diskId;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachVolumeRequest model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.targetName(model.targetName);
            this.volumeARN(model.volumeARN);
            this.networkInterfaceId(model.networkInterfaceId);
            this.diskId(model.diskId);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getTargetName() {
            return this.targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        public final String getVolumeARN() {
            return this.volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getDiskId() {
            return this.diskId;
        }

        @Override
        public final Builder diskId(String diskId) {
            this.diskId = diskId;
            return this;
        }

        public final void setDiskId(String diskId) {
            this.diskId = diskId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachVolumeRequest build() {
            return new AttachVolumeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AttachVolumeRequest> {
        public Builder gatewayARN(String var1);

        public Builder targetName(String var1);

        public Builder volumeARN(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder diskId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

