/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.GatewayCapacity;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGatewayInformationRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, UpdateGatewayInformationRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(UpdateGatewayInformationRequest.getter(UpdateGatewayInformationRequest::gatewayARN)).setter(UpdateGatewayInformationRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayName").getter(UpdateGatewayInformationRequest.getter(UpdateGatewayInformationRequest::gatewayName)).setter(UpdateGatewayInformationRequest.setter(Builder::gatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayName").build()}).build();
    private static final SdkField<String> GATEWAY_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayTimezone").getter(UpdateGatewayInformationRequest.getter(UpdateGatewayInformationRequest::gatewayTimezone)).setter(UpdateGatewayInformationRequest.setter(Builder::gatewayTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayTimezone").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLogGroupARN").getter(UpdateGatewayInformationRequest.getter(UpdateGatewayInformationRequest::cloudWatchLogGroupARN)).setter(UpdateGatewayInformationRequest.setter(Builder::cloudWatchLogGroupARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupARN").build()}).build();
    private static final SdkField<String> GATEWAY_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayCapacity").getter(UpdateGatewayInformationRequest.getter(UpdateGatewayInformationRequest::gatewayCapacityAsString)).setter(UpdateGatewayInformationRequest.setter(Builder::gatewayCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, GATEWAY_NAME_FIELD, GATEWAY_TIMEZONE_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, GATEWAY_CAPACITY_FIELD));
    private final String gatewayARN;
    private final String gatewayName;
    private final String gatewayTimezone;
    private final String cloudWatchLogGroupARN;
    private final String gatewayCapacity;

    private UpdateGatewayInformationRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.gatewayName = builder.gatewayName;
        this.gatewayTimezone = builder.gatewayTimezone;
        this.cloudWatchLogGroupARN = builder.cloudWatchLogGroupARN;
        this.gatewayCapacity = builder.gatewayCapacity;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final String gatewayName() {
        return this.gatewayName;
    }

    public final String gatewayTimezone() {
        return this.gatewayTimezone;
    }

    public final String cloudWatchLogGroupARN() {
        return this.cloudWatchLogGroupARN;
    }

    public final GatewayCapacity gatewayCapacity() {
        return GatewayCapacity.fromValue(this.gatewayCapacity);
    }

    public final String gatewayCapacityAsString() {
        return this.gatewayCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayCapacityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGatewayInformationRequest)) {
            return false;
        }
        UpdateGatewayInformationRequest other = (UpdateGatewayInformationRequest)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.gatewayName(), other.gatewayName()) && Objects.equals(this.gatewayTimezone(), other.gatewayTimezone()) && Objects.equals(this.cloudWatchLogGroupARN(), other.cloudWatchLogGroupARN()) && Objects.equals(this.gatewayCapacityAsString(), other.gatewayCapacityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGatewayInformationRequest").add("GatewayARN", (Object)this.gatewayARN()).add("GatewayName", (Object)this.gatewayName()).add("GatewayTimezone", (Object)this.gatewayTimezone()).add("CloudWatchLogGroupARN", (Object)this.cloudWatchLogGroupARN()).add("GatewayCapacity", (Object)this.gatewayCapacityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "GatewayName": {
                return Optional.ofNullable(clazz.cast(this.gatewayName()));
            }
            case "GatewayTimezone": {
                return Optional.ofNullable(clazz.cast(this.gatewayTimezone()));
            }
            case "CloudWatchLogGroupARN": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupARN()));
            }
            case "GatewayCapacity": {
                return Optional.ofNullable(clazz.cast(this.gatewayCapacityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGatewayInformationRequest, T> g) {
        return obj -> g.apply((UpdateGatewayInformationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private String gatewayName;
        private String gatewayTimezone;
        private String cloudWatchLogGroupARN;
        private String gatewayCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGatewayInformationRequest model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.gatewayName(model.gatewayName);
            this.gatewayTimezone(model.gatewayTimezone);
            this.cloudWatchLogGroupARN(model.cloudWatchLogGroupARN);
            this.gatewayCapacity(model.gatewayCapacity);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getGatewayName() {
            return this.gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        public final String getGatewayTimezone() {
            return this.gatewayTimezone;
        }

        @Override
        public final Builder gatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
            return this;
        }

        public final void setGatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
        }

        public final String getCloudWatchLogGroupARN() {
            return this.cloudWatchLogGroupARN;
        }

        @Override
        public final Builder cloudWatchLogGroupARN(String cloudWatchLogGroupARN) {
            this.cloudWatchLogGroupARN = cloudWatchLogGroupARN;
            return this;
        }

        public final void setCloudWatchLogGroupARN(String cloudWatchLogGroupARN) {
            this.cloudWatchLogGroupARN = cloudWatchLogGroupARN;
        }

        public final String getGatewayCapacity() {
            return this.gatewayCapacity;
        }

        @Override
        public final Builder gatewayCapacity(String gatewayCapacity) {
            this.gatewayCapacity = gatewayCapacity;
            return this;
        }

        @Override
        public final Builder gatewayCapacity(GatewayCapacity gatewayCapacity) {
            this.gatewayCapacity(gatewayCapacity == null ? null : gatewayCapacity.toString());
            return this;
        }

        public final void setGatewayCapacity(String gatewayCapacity) {
            this.gatewayCapacity = gatewayCapacity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGatewayInformationRequest build() {
            return new UpdateGatewayInformationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGatewayInformationRequest> {
        public Builder gatewayARN(String var1);

        public Builder gatewayName(String var1);

        public Builder gatewayTimezone(String var1);

        public Builder cloudWatchLogGroupARN(String var1);

        public Builder gatewayCapacity(String var1);

        public Builder gatewayCapacity(GatewayCapacity var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

