/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSnapshotFromVolumeRecoveryPointRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<CreateSnapshotFromVolumeRecoveryPointRequest.Builder, CreateSnapshotFromVolumeRecoveryPointRequest> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeARN").getter(getter(CreateSnapshotFromVolumeRecoveryPointRequest::volumeARN))
            .setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final SdkField<String> SNAPSHOT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotDescription").getter(getter(CreateSnapshotFromVolumeRecoveryPointRequest::snapshotDescription))
            .setter(setter(Builder::snapshotDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotDescription").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateSnapshotFromVolumeRecoveryPointRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD,
            SNAPSHOT_DESCRIPTION_FIELD, TAGS_FIELD));

    private final String volumeARN;

    private final String snapshotDescription;

    private final List<Tag> tags;

    private CreateSnapshotFromVolumeRecoveryPointRequest(BuilderImpl builder) {
        super(builder);
        this.volumeARN = builder.volumeARN;
        this.snapshotDescription = builder.snapshotDescription;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to
     * return to retrieve the TargetARN for specified VolumeARN.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a>
     *         operation to return to retrieve the TargetARN for specified VolumeARN.
     */
    public final String volumeARN() {
        return volumeARN;
    }

    /**
     * <p>
     * Textual description of the snapshot that appears in the Amazon EC2 console, Elastic Block Store snapshots panel
     * in the <b>Description</b> field, and in the Storage Gateway snapshot <b>Details</b> pane, <b>Description</b>
     * field.
     * </p>
     * 
     * @return Textual description of the snapshot that appears in the Amazon EC2 console, Elastic Block Store snapshots
     *         panel in the <b>Description</b> field, and in the Storage Gateway snapshot <b>Details</b> pane,
     *         <b>Description</b> field.
     */
    public final String snapshotDescription() {
        return snapshotDescription;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.
     * </p>
     * <note>
     * <p>
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
     * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
     * maximum length for a tag's value is 256.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>
     *         <p>
     *         Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
     *         the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters,
     *         and the maximum length for a tag's value is 256.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotFromVolumeRecoveryPointRequest)) {
            return false;
        }
        CreateSnapshotFromVolumeRecoveryPointRequest other = (CreateSnapshotFromVolumeRecoveryPointRequest) obj;
        return Objects.equals(volumeARN(), other.volumeARN())
                && Objects.equals(snapshotDescription(), other.snapshotDescription()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSnapshotFromVolumeRecoveryPointRequest").add("VolumeARN", volumeARN())
                .add("SnapshotDescription", snapshotDescription()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        case "SnapshotDescription":
            return Optional.ofNullable(clazz.cast(snapshotDescription()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotFromVolumeRecoveryPointRequest, T> g) {
        return obj -> g.apply((CreateSnapshotFromVolumeRecoveryPointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSnapshotFromVolumeRecoveryPointRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a>
         * operation to return to retrieve the TargetARN for specified VolumeARN.
         * </p>
         * 
         * @param volumeARN
         *        The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a>
         *        operation to return to retrieve the TargetARN for specified VolumeARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);

        /**
         * <p>
         * Textual description of the snapshot that appears in the Amazon EC2 console, Elastic Block Store snapshots
         * panel in the <b>Description</b> field, and in the Storage Gateway snapshot <b>Details</b> pane,
         * <b>Description</b> field.
         * </p>
         * 
         * @param snapshotDescription
         *        Textual description of the snapshot that appears in the Amazon EC2 console, Elastic Block Store
         *        snapshots panel in the <b>Description</b> field, and in the Storage Gateway snapshot <b>Details</b>
         *        pane, <b>Description</b> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotDescription(String snapshotDescription);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
         *        characters, and the maximum length for a tag's value is 256.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
         *        characters, and the maximum length for a tag's value is 256.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String volumeARN;

        private String snapshotDescription;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotFromVolumeRecoveryPointRequest model) {
            super(model);
            volumeARN(model.volumeARN);
            snapshotDescription(model.snapshotDescription);
            tags(model.tags);
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final String getSnapshotDescription() {
            return snapshotDescription;
        }

        @Override
        public final Builder snapshotDescription(String snapshotDescription) {
            this.snapshotDescription = snapshotDescription;
            return this;
        }

        public final void setSnapshotDescription(String snapshotDescription) {
            this.snapshotDescription = snapshotDescription;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSnapshotFromVolumeRecoveryPointRequest build() {
            return new CreateSnapshotFromVolumeRecoveryPointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
