/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DeleteTapeInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTapeRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<DeleteTapeRequest.Builder, DeleteTapeRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(DeleteTapeRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeARN").getter(getter(DeleteTapeRequest::tapeARN)).setter(setter(Builder::tapeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()).build();

    private static final SdkField<Boolean> BYPASS_GOVERNANCE_RETENTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("BypassGovernanceRetention")
            .getter(getter(DeleteTapeRequest::bypassGovernanceRetention)).setter(setter(Builder::bypassGovernanceRetention))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BypassGovernanceRetention").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            TAPE_ARN_FIELD, BYPASS_GOVERNANCE_RETENTION_FIELD));

    private final String gatewayARN;

    private final String tapeARN;

    private final Boolean bypassGovernanceRetention;

    private DeleteTapeRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.tapeARN = builder.tapeARN;
        this.bypassGovernanceRetention = builder.bypassGovernanceRetention;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is associated with. Use the
     * <a>ListGateways</a> operation to return a list of gateways for your account and Region.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is associated with.
     *         Use the <a>ListGateways</a> operation to return a list of gateways for your account and Region.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the virtual tape to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the virtual tape to delete.
     */
    public final String tapeARN() {
        return tapeARN;
    }

    /**
     * <p>
     * Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention lock. Only
     * archived tapes with tape retention lock set to <code>governance</code> can be deleted. Archived tapes with tape
     * retention lock set to <code>compliance</code> can't be deleted.
     * </p>
     * 
     * @return Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention
     *         lock. Only archived tapes with tape retention lock set to <code>governance</code> can be deleted.
     *         Archived tapes with tape retention lock set to <code>compliance</code> can't be deleted.
     */
    public final Boolean bypassGovernanceRetention() {
        return bypassGovernanceRetention;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(bypassGovernanceRetention());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTapeRequest)) {
            return false;
        }
        DeleteTapeRequest other = (DeleteTapeRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(tapeARN(), other.tapeARN())
                && Objects.equals(bypassGovernanceRetention(), other.bypassGovernanceRetention());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTapeRequest").add("GatewayARN", gatewayARN()).add("TapeARN", tapeARN())
                .add("BypassGovernanceRetention", bypassGovernanceRetention()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "TapeARN":
            return Optional.ofNullable(clazz.cast(tapeARN()));
        case "BypassGovernanceRetention":
            return Optional.ofNullable(clazz.cast(bypassGovernanceRetention()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTapeRequest, T> g) {
        return obj -> g.apply((DeleteTapeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteTapeRequest> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is associated with. Use
         * the <a>ListGateways</a> operation to return a list of gateways for your account and Region.
         * </p>
         * 
         * @param gatewayARN
         *        The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is associated
         *        with. Use the <a>ListGateways</a> operation to return a list of gateways for your account and Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the virtual tape to delete.
         * </p>
         * 
         * @param tapeARN
         *        The Amazon Resource Name (ARN) of the virtual tape to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARN(String tapeARN);

        /**
         * <p>
         * Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention lock.
         * Only archived tapes with tape retention lock set to <code>governance</code> can be deleted. Archived tapes
         * with tape retention lock set to <code>compliance</code> can't be deleted.
         * </p>
         * 
         * @param bypassGovernanceRetention
         *        Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention
         *        lock. Only archived tapes with tape retention lock set to <code>governance</code> can be deleted.
         *        Archived tapes with tape retention lock set to <code>compliance</code> can't be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bypassGovernanceRetention(Boolean bypassGovernanceRetention);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private String tapeARN;

        private Boolean bypassGovernanceRetention;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTapeRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            tapeARN(model.tapeARN);
            bypassGovernanceRetention(model.bypassGovernanceRetention);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getTapeARN() {
            return tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        public final Boolean getBypassGovernanceRetention() {
            return bypassGovernanceRetention;
        }

        @Override
        public final Builder bypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
            return this;
        }

        public final void setBypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTapeRequest build() {
            return new DeleteTapeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
