/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies network configuration information for the gateway associated with the Amazon FSx file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointNetworkConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointNetworkConfiguration.Builder, EndpointNetworkConfiguration> {
    private static final SdkField<List<String>> IP_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IpAddresses")
            .getter(getter(EndpointNetworkConfiguration::ipAddresses))
            .setter(setter(Builder::ipAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> ipAddresses;

    private EndpointNetworkConfiguration(BuilderImpl builder) {
        this.ipAddresses = builder.ipAddresses;
    }

    /**
     * Returns true if the IpAddresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpAddresses() {
        return ipAddresses != null && !(ipAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of gateway IP addresses on which the associated Amazon FSx file system is available.
     * </p>
     * <note>
     * <p>
     * If multiple file systems are associated with this gateway, this field is required.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of gateway IP addresses on which the associated Amazon FSx file system is available.</p> <note>
     *         <p>
     *         If multiple file systems are associated with this gateway, this field is required.
     *         </p>
     */
    public final List<String> ipAddresses() {
        return ipAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIpAddresses() ? ipAddresses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointNetworkConfiguration)) {
            return false;
        }
        EndpointNetworkConfiguration other = (EndpointNetworkConfiguration) obj;
        return hasIpAddresses() == other.hasIpAddresses() && Objects.equals(ipAddresses(), other.ipAddresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointNetworkConfiguration").add("IpAddresses", hasIpAddresses() ? ipAddresses() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpAddresses":
            return Optional.ofNullable(clazz.cast(ipAddresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointNetworkConfiguration, T> g) {
        return obj -> g.apply((EndpointNetworkConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointNetworkConfiguration> {
        /**
         * <p>
         * A list of gateway IP addresses on which the associated Amazon FSx file system is available.
         * </p>
         * <note>
         * <p>
         * If multiple file systems are associated with this gateway, this field is required.
         * </p>
         * </note>
         * 
         * @param ipAddresses
         *        A list of gateway IP addresses on which the associated Amazon FSx file system is available.</p> <note>
         *        <p>
         *        If multiple file systems are associated with this gateway, this field is required.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddresses(Collection<String> ipAddresses);

        /**
         * <p>
         * A list of gateway IP addresses on which the associated Amazon FSx file system is available.
         * </p>
         * <note>
         * <p>
         * If multiple file systems are associated with this gateway, this field is required.
         * </p>
         * </note>
         * 
         * @param ipAddresses
         *        A list of gateway IP addresses on which the associated Amazon FSx file system is available.</p> <note>
         *        <p>
         *        If multiple file systems are associated with this gateway, this field is required.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddresses(String... ipAddresses);
    }

    static final class BuilderImpl implements Builder {
        private List<String> ipAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointNetworkConfiguration model) {
            ipAddresses(model.ipAddresses);
        }

        public final Collection<String> getIpAddresses() {
            if (ipAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipAddresses;
        }

        @Override
        public final Builder ipAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressListCopier.copy(ipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(String... ipAddresses) {
            ipAddresses(Arrays.asList(ipAddresses));
            return this;
        }

        public final void setIpAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressListCopier.copy(ipAddresses);
        }

        @Override
        public EndpointNetworkConfiguration build() {
            return new EndpointNetworkConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
