/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a file share. Only supported S3 File Gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileShareInfo implements SdkPojo, Serializable, ToCopyableBuilder<FileShareInfo.Builder, FileShareInfo> {
    private static final SdkField<String> FILE_SHARE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareType").getter(getter(FileShareInfo::fileShareTypeAsString))
            .setter(setter(Builder::fileShareType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareType").build()).build();

    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareARN").getter(getter(FileShareInfo::fileShareARN)).setter(setter(Builder::fileShareARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()).build();

    private static final SdkField<String> FILE_SHARE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareId").getter(getter(FileShareInfo::fileShareId)).setter(setter(Builder::fileShareId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareId").build()).build();

    private static final SdkField<String> FILE_SHARE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareStatus").getter(getter(FileShareInfo::fileShareStatus))
            .setter(setter(Builder::fileShareStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareStatus").build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(FileShareInfo::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_TYPE_FIELD,
            FILE_SHARE_ARN_FIELD, FILE_SHARE_ID_FIELD, FILE_SHARE_STATUS_FIELD, GATEWAY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileShareType;

    private final String fileShareARN;

    private final String fileShareId;

    private final String fileShareStatus;

    private final String gatewayARN;

    private FileShareInfo(BuilderImpl builder) {
        this.fileShareType = builder.fileShareType;
        this.fileShareARN = builder.fileShareARN;
        this.fileShareId = builder.fileShareId;
        this.fileShareStatus = builder.fileShareStatus;
        this.gatewayARN = builder.gatewayARN;
    }

    /**
     * Returns the value of the FileShareType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileShareType}
     * will return {@link FileShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileShareTypeAsString}.
     * </p>
     * 
     * @return The value of the FileShareType property for this object.
     * @see FileShareType
     */
    public final FileShareType fileShareType() {
        return FileShareType.fromValue(fileShareType);
    }

    /**
     * Returns the value of the FileShareType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileShareType}
     * will return {@link FileShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileShareTypeAsString}.
     * </p>
     * 
     * @return The value of the FileShareType property for this object.
     * @see FileShareType
     */
    public final String fileShareTypeAsString() {
        return fileShareType;
    }

    /**
     * Returns the value of the FileShareARN property for this object.
     * 
     * @return The value of the FileShareARN property for this object.
     */
    public final String fileShareARN() {
        return fileShareARN;
    }

    /**
     * Returns the value of the FileShareId property for this object.
     * 
     * @return The value of the FileShareId property for this object.
     */
    public final String fileShareId() {
        return fileShareId;
    }

    /**
     * Returns the value of the FileShareStatus property for this object.
     * 
     * @return The value of the FileShareStatus property for this object.
     */
    public final String fileShareStatus() {
        return fileShareStatus;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileShareTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(fileShareId());
        hashCode = 31 * hashCode + Objects.hashCode(fileShareStatus());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileShareInfo)) {
            return false;
        }
        FileShareInfo other = (FileShareInfo) obj;
        return Objects.equals(fileShareTypeAsString(), other.fileShareTypeAsString())
                && Objects.equals(fileShareARN(), other.fileShareARN()) && Objects.equals(fileShareId(), other.fileShareId())
                && Objects.equals(fileShareStatus(), other.fileShareStatus()) && Objects.equals(gatewayARN(), other.gatewayARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileShareInfo").add("FileShareType", fileShareTypeAsString())
                .add("FileShareARN", fileShareARN()).add("FileShareId", fileShareId()).add("FileShareStatus", fileShareStatus())
                .add("GatewayARN", gatewayARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileShareType":
            return Optional.ofNullable(clazz.cast(fileShareTypeAsString()));
        case "FileShareARN":
            return Optional.ofNullable(clazz.cast(fileShareARN()));
        case "FileShareId":
            return Optional.ofNullable(clazz.cast(fileShareId()));
        case "FileShareStatus":
            return Optional.ofNullable(clazz.cast(fileShareStatus()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileShareInfo, T> g) {
        return obj -> g.apply((FileShareInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileShareInfo> {
        /**
         * Sets the value of the FileShareType property for this object.
         *
         * @param fileShareType
         *        The new value for the FileShareType property for this object.
         * @see FileShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileShareType
         */
        Builder fileShareType(String fileShareType);

        /**
         * Sets the value of the FileShareType property for this object.
         *
         * @param fileShareType
         *        The new value for the FileShareType property for this object.
         * @see FileShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileShareType
         */
        Builder fileShareType(FileShareType fileShareType);

        /**
         * Sets the value of the FileShareARN property for this object.
         *
         * @param fileShareARN
         *        The new value for the FileShareARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareARN(String fileShareARN);

        /**
         * Sets the value of the FileShareId property for this object.
         *
         * @param fileShareId
         *        The new value for the FileShareId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareId(String fileShareId);

        /**
         * Sets the value of the FileShareStatus property for this object.
         *
         * @param fileShareStatus
         *        The new value for the FileShareStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareStatus(String fileShareStatus);

        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);
    }

    static final class BuilderImpl implements Builder {
        private String fileShareType;

        private String fileShareARN;

        private String fileShareId;

        private String fileShareStatus;

        private String gatewayARN;

        private BuilderImpl() {
        }

        private BuilderImpl(FileShareInfo model) {
            fileShareType(model.fileShareType);
            fileShareARN(model.fileShareARN);
            fileShareId(model.fileShareId);
            fileShareStatus(model.fileShareStatus);
            gatewayARN(model.gatewayARN);
        }

        public final String getFileShareType() {
            return fileShareType;
        }

        @Override
        public final Builder fileShareType(String fileShareType) {
            this.fileShareType = fileShareType;
            return this;
        }

        @Override
        public final Builder fileShareType(FileShareType fileShareType) {
            this.fileShareType(fileShareType == null ? null : fileShareType.toString());
            return this;
        }

        public final void setFileShareType(String fileShareType) {
            this.fileShareType = fileShareType;
        }

        public final String getFileShareARN() {
            return fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        public final String getFileShareId() {
            return fileShareId;
        }

        @Override
        public final Builder fileShareId(String fileShareId) {
            this.fileShareId = fileShareId;
            return this;
        }

        public final void setFileShareId(String fileShareId) {
            this.fileShareId = fileShareId;
        }

        public final String getFileShareStatus() {
            return fileShareStatus;
        }

        @Override
        public final Builder fileShareStatus(String fileShareStatus) {
            this.fileShareStatus = fileShareStatus;
            return this;
        }

        public final void setFileShareStatus(String fileShareStatus) {
            this.fileShareStatus = fileShareStatus;
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public FileShareInfo build() {
            return new FileShareInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
