/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGatewaysResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<ListGatewaysResponse.Builder, ListGatewaysResponse> {
    private static final SdkField<List<GatewayInfo>> GATEWAYS_FIELD = SdkField
            .<List<GatewayInfo>> builder(MarshallingType.LIST)
            .memberName("Gateways")
            .getter(getter(ListGatewaysResponse::gateways))
            .setter(setter(Builder::gateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gateways").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GatewayInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(GatewayInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListGatewaysResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAYS_FIELD, MARKER_FIELD));

    private final List<GatewayInfo> gateways;

    private final String marker;

    private ListGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.gateways = builder.gateways;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the Gateways property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGateways() {
        return gateways != null && !(gateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>GatewayInfo</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGateways()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <a>GatewayInfo</a> objects.
     */
    public final List<GatewayInfo> gateways() {
        return gateways;
    }

    /**
     * <p>
     * Use the marker in your next request to fetch the next set of gateways in the list. If there are no more gateways
     * to list, this field does not appear in the response.
     * </p>
     * 
     * @return Use the marker in your next request to fetch the next set of gateways in the list. If there are no more
     *         gateways to list, this field does not appear in the response.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGateways() ? gateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGatewaysResponse)) {
            return false;
        }
        ListGatewaysResponse other = (ListGatewaysResponse) obj;
        return hasGateways() == other.hasGateways() && Objects.equals(gateways(), other.gateways())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGatewaysResponse").add("Gateways", hasGateways() ? gateways() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Gateways":
            return Optional.ofNullable(clazz.cast(gateways()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGatewaysResponse, T> g) {
        return obj -> g.apply((ListGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGatewaysResponse> {
        /**
         * <p>
         * An array of <a>GatewayInfo</a> objects.
         * </p>
         * 
         * @param gateways
         *        An array of <a>GatewayInfo</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gateways(Collection<GatewayInfo> gateways);

        /**
         * <p>
         * An array of <a>GatewayInfo</a> objects.
         * </p>
         * 
         * @param gateways
         *        An array of <a>GatewayInfo</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gateways(GatewayInfo... gateways);

        /**
         * <p>
         * An array of <a>GatewayInfo</a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GatewayInfo>.Builder} avoiding the need to
         * create one manually via {@link List<GatewayInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GatewayInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #gateways(List<GatewayInfo>)}.
         * 
         * @param gateways
         *        a consumer that will call methods on {@link List<GatewayInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gateways(List<GatewayInfo>)
         */
        Builder gateways(Consumer<GatewayInfo.Builder>... gateways);

        /**
         * <p>
         * Use the marker in your next request to fetch the next set of gateways in the list. If there are no more
         * gateways to list, this field does not appear in the response.
         * </p>
         * 
         * @param marker
         *        Use the marker in your next request to fetch the next set of gateways in the list. If there are no
         *        more gateways to list, this field does not appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<GatewayInfo> gateways = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGatewaysResponse model) {
            super(model);
            gateways(model.gateways);
            marker(model.marker);
        }

        public final List<GatewayInfo.Builder> getGateways() {
            List<GatewayInfo.Builder> result = GatewaysCopier.copyToBuilder(this.gateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder gateways(Collection<GatewayInfo> gateways) {
            this.gateways = GatewaysCopier.copy(gateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gateways(GatewayInfo... gateways) {
            gateways(Arrays.asList(gateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gateways(Consumer<GatewayInfo.Builder>... gateways) {
            gateways(Stream.of(gateways).map(c -> GatewayInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGateways(Collection<GatewayInfo.BuilderImpl> gateways) {
            this.gateways = GatewaysCopier.copyFromBuilder(gateways);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListGatewaysResponse build() {
            return new ListGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
