/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFileSystemAssociationRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<UpdateFileSystemAssociationRequest.Builder, UpdateFileSystemAssociationRequest> {
    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemAssociationARN").getter(getter(UpdateFileSystemAssociationRequest::fileSystemAssociationARN))
            .setter(setter(Builder::fileSystemAssociationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationARN").build())
            .build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(UpdateFileSystemAssociationRequest::userName))
            .setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(UpdateFileSystemAssociationRequest::password))
            .setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<String> AUDIT_DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuditDestinationARN").getter(getter(UpdateFileSystemAssociationRequest::auditDestinationARN))
            .setter(setter(Builder::auditDestinationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditDestinationARN").build())
            .build();

    private static final SdkField<CacheAttributes> CACHE_ATTRIBUTES_FIELD = SdkField
            .<CacheAttributes> builder(MarshallingType.SDK_POJO).memberName("CacheAttributes")
            .getter(getter(UpdateFileSystemAssociationRequest::cacheAttributes)).setter(setter(Builder::cacheAttributes))
            .constructor(CacheAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FILE_SYSTEM_ASSOCIATION_ARN_FIELD, USER_NAME_FIELD, PASSWORD_FIELD, AUDIT_DESTINATION_ARN_FIELD,
            CACHE_ATTRIBUTES_FIELD));

    private final String fileSystemAssociationARN;

    private final String userName;

    private final String password;

    private final String auditDestinationARN;

    private final CacheAttributes cacheAttributes;

    private UpdateFileSystemAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemAssociationARN = builder.fileSystemAssociationARN;
        this.userName = builder.userName;
        this.password = builder.password;
        this.auditDestinationARN = builder.auditDestinationARN;
        this.cacheAttributes = builder.cacheAttributes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the file system association that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the file system association that you want to update.
     */
    public final String fileSystemAssociationARN() {
        return fileSystemAssociationARN;
    }

    /**
     * <p>
     * The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file
     * system. The user account must belong to the Amazon FSx delegated admin user group.
     * </p>
     * 
     * @return The user name of the user credential that has permission to access the root share D$ of the Amazon FSx
     *         file system. The user account must belong to the Amazon FSx delegated admin user group.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The password of the user credential.
     * </p>
     * 
     * @return The password of the user credential.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the storage used for the audit logs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the storage used for the audit logs.
     */
    public final String auditDestinationARN() {
        return auditDestinationARN;
    }

    /**
     * Returns the value of the CacheAttributes property for this object.
     * 
     * @return The value of the CacheAttributes property for this object.
     */
    public final CacheAttributes cacheAttributes() {
        return cacheAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemAssociationARN());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(auditDestinationARN());
        hashCode = 31 * hashCode + Objects.hashCode(cacheAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemAssociationRequest)) {
            return false;
        }
        UpdateFileSystemAssociationRequest other = (UpdateFileSystemAssociationRequest) obj;
        return Objects.equals(fileSystemAssociationARN(), other.fileSystemAssociationARN())
                && Objects.equals(userName(), other.userName()) && Objects.equals(password(), other.password())
                && Objects.equals(auditDestinationARN(), other.auditDestinationARN())
                && Objects.equals(cacheAttributes(), other.cacheAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFileSystemAssociationRequest").add("FileSystemAssociationARN", fileSystemAssociationARN())
                .add("UserName", userName()).add("Password", password() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AuditDestinationARN", auditDestinationARN()).add("CacheAttributes", cacheAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemAssociationARN":
            return Optional.ofNullable(clazz.cast(fileSystemAssociationARN()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "AuditDestinationARN":
            return Optional.ofNullable(clazz.cast(auditDestinationARN()));
        case "CacheAttributes":
            return Optional.ofNullable(clazz.cast(cacheAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemAssociationRequest, T> g) {
        return obj -> g.apply((UpdateFileSystemAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFileSystemAssociationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the file system association that you want to update.
         * </p>
         * 
         * @param fileSystemAssociationARN
         *        The Amazon Resource Name (ARN) of the file system association that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationARN(String fileSystemAssociationARN);

        /**
         * <p>
         * The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file
         * system. The user account must belong to the Amazon FSx delegated admin user group.
         * </p>
         * 
         * @param userName
         *        The user name of the user credential that has permission to access the root share D$ of the Amazon FSx
         *        file system. The user account must belong to the Amazon FSx delegated admin user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The password of the user credential.
         * </p>
         * 
         * @param password
         *        The password of the user credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the storage used for the audit logs.
         * </p>
         * 
         * @param auditDestinationARN
         *        The Amazon Resource Name (ARN) of the storage used for the audit logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditDestinationARN(String auditDestinationARN);

        /**
         * Sets the value of the CacheAttributes property for this object.
         *
         * @param cacheAttributes
         *        The new value for the CacheAttributes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheAttributes(CacheAttributes cacheAttributes);

        /**
         * Sets the value of the CacheAttributes property for this object.
         *
         * This is a convenience that creates an instance of the {@link CacheAttributes.Builder} avoiding the need to
         * create one manually via {@link CacheAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link CacheAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheAttributes(CacheAttributes)}.
         * 
         * @param cacheAttributes
         *        a consumer that will call methods on {@link CacheAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheAttributes(CacheAttributes)
         */
        default Builder cacheAttributes(Consumer<CacheAttributes.Builder> cacheAttributes) {
            return cacheAttributes(CacheAttributes.builder().applyMutation(cacheAttributes).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String fileSystemAssociationARN;

        private String userName;

        private String password;

        private String auditDestinationARN;

        private CacheAttributes cacheAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemAssociationRequest model) {
            super(model);
            fileSystemAssociationARN(model.fileSystemAssociationARN);
            userName(model.userName);
            password(model.password);
            auditDestinationARN(model.auditDestinationARN);
            cacheAttributes(model.cacheAttributes);
        }

        public final String getFileSystemAssociationARN() {
            return fileSystemAssociationARN;
        }

        @Override
        public final Builder fileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
            return this;
        }

        public final void setFileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getAuditDestinationARN() {
            return auditDestinationARN;
        }

        @Override
        public final Builder auditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
            return this;
        }

        public final void setAuditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
        }

        public final CacheAttributes.Builder getCacheAttributes() {
            return cacheAttributes != null ? cacheAttributes.toBuilder() : null;
        }

        @Override
        public final Builder cacheAttributes(CacheAttributes cacheAttributes) {
            this.cacheAttributes = cacheAttributes;
            return this;
        }

        public final void setCacheAttributes(CacheAttributes.BuilderImpl cacheAttributes) {
            this.cacheAttributes = cacheAttributes != null ? cacheAttributes.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFileSystemAssociationRequest build() {
            return new UpdateFileSystemAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
