/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGatewayInformationRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<UpdateGatewayInformationRequest.Builder, UpdateGatewayInformationRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(UpdateGatewayInformationRequest::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayName").getter(getter(UpdateGatewayInformationRequest::gatewayName))
            .setter(setter(Builder::gatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayName").build()).build();

    private static final SdkField<String> GATEWAY_TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayTimezone").getter(getter(UpdateGatewayInformationRequest::gatewayTimezone))
            .setter(setter(Builder::gatewayTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayTimezone").build()).build();

    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogGroupARN").getter(getter(UpdateGatewayInformationRequest::cloudWatchLogGroupARN))
            .setter(setter(Builder::cloudWatchLogGroupARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupARN").build())
            .build();

    private static final SdkField<String> GATEWAY_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayCapacity").getter(getter(UpdateGatewayInformationRequest::gatewayCapacityAsString))
            .setter(setter(Builder::gatewayCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            GATEWAY_NAME_FIELD, GATEWAY_TIMEZONE_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, GATEWAY_CAPACITY_FIELD));

    private final String gatewayARN;

    private final String gatewayName;

    private final String gatewayTimezone;

    private final String cloudWatchLogGroupARN;

    private final String gatewayCapacity;

    private UpdateGatewayInformationRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.gatewayName = builder.gatewayName;
        this.gatewayTimezone = builder.gatewayTimezone;
        this.cloudWatchLogGroupARN = builder.cloudWatchLogGroupARN;
        this.gatewayCapacity = builder.gatewayCapacity;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * Returns the value of the GatewayName property for this object.
     * 
     * @return The value of the GatewayName property for this object.
     */
    public final String gatewayName() {
        return gatewayName;
    }

    /**
     * <p>
     * A value that indicates the time zone of the gateway.
     * </p>
     * 
     * @return A value that indicates the time zone of the gateway.
     */
    public final String gatewayTimezone() {
        return gatewayTimezone;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use to monitor and log events
     * in the gateway.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon
     * CloudWatch Logs?</a>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use to monitor and log
     *         events in the gateway.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon
     *         CloudWatch Logs?</a>
     */
    public final String cloudWatchLogGroupARN() {
        return cloudWatchLogGroupARN;
    }

    /**
     * <p>
     * Specifies the size of the gateway's metadata cache.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gatewayCapacity}
     * will return {@link GatewayCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gatewayCapacityAsString}.
     * </p>
     * 
     * @return Specifies the size of the gateway's metadata cache.
     * @see GatewayCapacity
     */
    public final GatewayCapacity gatewayCapacity() {
        return GatewayCapacity.fromValue(gatewayCapacity);
    }

    /**
     * <p>
     * Specifies the size of the gateway's metadata cache.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gatewayCapacity}
     * will return {@link GatewayCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gatewayCapacityAsString}.
     * </p>
     * 
     * @return Specifies the size of the gateway's metadata cache.
     * @see GatewayCapacity
     */
    public final String gatewayCapacityAsString() {
        return gatewayCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupARN());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayCapacityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGatewayInformationRequest)) {
            return false;
        }
        UpdateGatewayInformationRequest other = (UpdateGatewayInformationRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(gatewayName(), other.gatewayName())
                && Objects.equals(gatewayTimezone(), other.gatewayTimezone())
                && Objects.equals(cloudWatchLogGroupARN(), other.cloudWatchLogGroupARN())
                && Objects.equals(gatewayCapacityAsString(), other.gatewayCapacityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGatewayInformationRequest").add("GatewayARN", gatewayARN())
                .add("GatewayName", gatewayName()).add("GatewayTimezone", gatewayTimezone())
                .add("CloudWatchLogGroupARN", cloudWatchLogGroupARN()).add("GatewayCapacity", gatewayCapacityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "GatewayName":
            return Optional.ofNullable(clazz.cast(gatewayName()));
        case "GatewayTimezone":
            return Optional.ofNullable(clazz.cast(gatewayTimezone()));
        case "CloudWatchLogGroupARN":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupARN()));
        case "GatewayCapacity":
            return Optional.ofNullable(clazz.cast(gatewayCapacityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGatewayInformationRequest, T> g) {
        return obj -> g.apply((UpdateGatewayInformationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGatewayInformationRequest> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * Sets the value of the GatewayName property for this object.
         *
         * @param gatewayName
         *        The new value for the GatewayName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayName(String gatewayName);

        /**
         * <p>
         * A value that indicates the time zone of the gateway.
         * </p>
         * 
         * @param gatewayTimezone
         *        A value that indicates the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayTimezone(String gatewayTimezone);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use to monitor and log
         * events in the gateway.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon
         * CloudWatch Logs?</a>
         * </p>
         * 
         * @param cloudWatchLogGroupARN
         *        The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use to monitor and
         *        log events in the gateway.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is
         *        Amazon CloudWatch Logs?</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupARN(String cloudWatchLogGroupARN);

        /**
         * <p>
         * Specifies the size of the gateway's metadata cache.
         * </p>
         * 
         * @param gatewayCapacity
         *        Specifies the size of the gateway's metadata cache.
         * @see GatewayCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayCapacity
         */
        Builder gatewayCapacity(String gatewayCapacity);

        /**
         * <p>
         * Specifies the size of the gateway's metadata cache.
         * </p>
         * 
         * @param gatewayCapacity
         *        Specifies the size of the gateway's metadata cache.
         * @see GatewayCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayCapacity
         */
        Builder gatewayCapacity(GatewayCapacity gatewayCapacity);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private String gatewayName;

        private String gatewayTimezone;

        private String cloudWatchLogGroupARN;

        private String gatewayCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGatewayInformationRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            gatewayName(model.gatewayName);
            gatewayTimezone(model.gatewayTimezone);
            cloudWatchLogGroupARN(model.cloudWatchLogGroupARN);
            gatewayCapacity(model.gatewayCapacity);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getGatewayName() {
            return gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        public final String getGatewayTimezone() {
            return gatewayTimezone;
        }

        @Override
        public final Builder gatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
            return this;
        }

        public final void setGatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
        }

        public final String getCloudWatchLogGroupARN() {
            return cloudWatchLogGroupARN;
        }

        @Override
        public final Builder cloudWatchLogGroupARN(String cloudWatchLogGroupARN) {
            this.cloudWatchLogGroupARN = cloudWatchLogGroupARN;
            return this;
        }

        public final void setCloudWatchLogGroupARN(String cloudWatchLogGroupARN) {
            this.cloudWatchLogGroupARN = cloudWatchLogGroupARN;
        }

        public final String getGatewayCapacity() {
            return gatewayCapacity;
        }

        @Override
        public final Builder gatewayCapacity(String gatewayCapacity) {
            this.gatewayCapacity = gatewayCapacity;
            return this;
        }

        @Override
        public final Builder gatewayCapacity(GatewayCapacity gatewayCapacity) {
            this.gatewayCapacity(gatewayCapacity == null ? null : gatewayCapacity.toString());
            return this;
        }

        public final void setGatewayCapacity(String gatewayCapacity) {
            this.gatewayCapacity = gatewayCapacity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGatewayInformationRequest build() {
            return new UpdateGatewayInformationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
