/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>DescribeMaintenanceStartTimeOutput$DayOfMonth</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeMaintenanceStartTimeOutput$DayOfWeek</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeMaintenanceStartTimeOutput$HourOfDay</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeMaintenanceStartTimeOutput$MinuteOfHour</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeMaintenanceStartTimeOutput$Timezone</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMaintenanceStartTimeResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeMaintenanceStartTimeResponse.Builder, DescribeMaintenanceStartTimeResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(DescribeMaintenanceStartTimeResponse::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<Integer> HOUR_OF_DAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HourOfDay").getter(getter(DescribeMaintenanceStartTimeResponse::hourOfDay))
            .setter(setter(Builder::hourOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourOfDay").build()).build();

    private static final SdkField<Integer> MINUTE_OF_HOUR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinuteOfHour").getter(getter(DescribeMaintenanceStartTimeResponse::minuteOfHour))
            .setter(setter(Builder::minuteOfHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinuteOfHour").build()).build();

    private static final SdkField<Integer> DAY_OF_WEEK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DayOfWeek").getter(getter(DescribeMaintenanceStartTimeResponse::dayOfWeek))
            .setter(setter(Builder::dayOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfWeek").build()).build();

    private static final SdkField<Integer> DAY_OF_MONTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DayOfMonth").getter(getter(DescribeMaintenanceStartTimeResponse::dayOfMonth))
            .setter(setter(Builder::dayOfMonth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfMonth").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(DescribeMaintenanceStartTimeResponse::timezone))
            .setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            HOUR_OF_DAY_FIELD, MINUTE_OF_HOUR_FIELD, DAY_OF_WEEK_FIELD, DAY_OF_MONTH_FIELD, TIMEZONE_FIELD));

    private final String gatewayARN;

    private final Integer hourOfDay;

    private final Integer minuteOfHour;

    private final Integer dayOfWeek;

    private final Integer dayOfMonth;

    private final String timezone;

    private DescribeMaintenanceStartTimeResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.hourOfDay = builder.hourOfDay;
        this.minuteOfHour = builder.minuteOfHour;
        this.dayOfWeek = builder.dayOfWeek;
        this.dayOfMonth = builder.dayOfMonth;
        this.timezone = builder.timezone;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23).
     * The hour of the day is in the time zone of the gateway.
     * </p>
     * 
     * @return The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0
     *         to 23). The hour of the day is in the time zone of the gateway.
     */
    public final Integer hourOfDay() {
        return hourOfDay;
    }

    /**
     * <p>
     * The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (0 to
     * 59). The minute of the hour is in the time zone of the gateway.
     * </p>
     * 
     * @return The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the
     *         minute (0 to 59). The minute of the hour is in the time zone of the gateway.
     */
    public final Integer minuteOfHour() {
        return minuteOfHour;
    }

    /**
     * <p>
     * An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6 represents
     * Saturday. The day of week is in the time zone of the gateway.
     * </p>
     * 
     * @return An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6
     *         represents Saturday. The day of week is in the time zone of the gateway.
     */
    public final Integer dayOfWeek() {
        return dayOfWeek;
    }

    /**
     * <p>
     * The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where
     * 1 represents the first day of the month and 28 represents the last day of the month.
     * </p>
     * 
     * @return The day of the month component of the maintenance start time represented as an ordinal number from 1 to
     *         28, where 1 represents the first day of the month and 28 represents the last day of the month.
     */
    public final Integer dayOfMonth() {
        return dayOfMonth;
    }

    /**
     * <p>
     * A value that indicates the time zone that is set for the gateway. The start time and day of week specified should
     * be in the time zone of the gateway.
     * </p>
     * 
     * @return A value that indicates the time zone that is set for the gateway. The start time and day of week
     *         specified should be in the time zone of the gateway.
     */
    public final String timezone() {
        return timezone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(hourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(minuteOfHour());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeek());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceStartTimeResponse)) {
            return false;
        }
        DescribeMaintenanceStartTimeResponse other = (DescribeMaintenanceStartTimeResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(hourOfDay(), other.hourOfDay())
                && Objects.equals(minuteOfHour(), other.minuteOfHour()) && Objects.equals(dayOfWeek(), other.dayOfWeek())
                && Objects.equals(dayOfMonth(), other.dayOfMonth()) && Objects.equals(timezone(), other.timezone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMaintenanceStartTimeResponse").add("GatewayARN", gatewayARN())
                .add("HourOfDay", hourOfDay()).add("MinuteOfHour", minuteOfHour()).add("DayOfWeek", dayOfWeek())
                .add("DayOfMonth", dayOfMonth()).add("Timezone", timezone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "HourOfDay":
            return Optional.ofNullable(clazz.cast(hourOfDay()));
        case "MinuteOfHour":
            return Optional.ofNullable(clazz.cast(minuteOfHour()));
        case "DayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeek()));
        case "DayOfMonth":
            return Optional.ofNullable(clazz.cast(dayOfMonth()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceStartTimeResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceStartTimeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMaintenanceStartTimeResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0 to
         * 23). The hour of the day is in the time zone of the gateway.
         * </p>
         * 
         * @param hourOfDay
         *        The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour
         *        (0 to 23). The hour of the day is in the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourOfDay(Integer hourOfDay);

        /**
         * <p>
         * The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (0
         * to 59). The minute of the hour is in the time zone of the gateway.
         * </p>
         * 
         * @param minuteOfHour
         *        The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the
         *        minute (0 to 59). The minute of the hour is in the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minuteOfHour(Integer minuteOfHour);

        /**
         * <p>
         * An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6
         * represents Saturday. The day of week is in the time zone of the gateway.
         * </p>
         * 
         * @param dayOfWeek
         *        An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6
         *        represents Saturday. The day of week is in the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfWeek(Integer dayOfWeek);

        /**
         * <p>
         * The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28,
         * where 1 represents the first day of the month and 28 represents the last day of the month.
         * </p>
         * 
         * @param dayOfMonth
         *        The day of the month component of the maintenance start time represented as an ordinal number from 1
         *        to 28, where 1 represents the first day of the month and 28 represents the last day of the month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfMonth(Integer dayOfMonth);

        /**
         * <p>
         * A value that indicates the time zone that is set for the gateway. The start time and day of week specified
         * should be in the time zone of the gateway.
         * </p>
         * 
         * @param timezone
         *        A value that indicates the time zone that is set for the gateway. The start time and day of week
         *        specified should be in the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private Integer hourOfDay;

        private Integer minuteOfHour;

        private Integer dayOfWeek;

        private Integer dayOfMonth;

        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceStartTimeResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            hourOfDay(model.hourOfDay);
            minuteOfHour(model.minuteOfHour);
            dayOfWeek(model.dayOfWeek);
            dayOfMonth(model.dayOfMonth);
            timezone(model.timezone);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        @Transient
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final Integer getHourOfDay() {
            return hourOfDay;
        }

        public final void setHourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
        }

        @Override
        @Transient
        public final Builder hourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
            return this;
        }

        public final Integer getMinuteOfHour() {
            return minuteOfHour;
        }

        public final void setMinuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
        }

        @Override
        @Transient
        public final Builder minuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
            return this;
        }

        public final Integer getDayOfWeek() {
            return dayOfWeek;
        }

        public final void setDayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        @Transient
        public final Builder dayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public final Integer getDayOfMonth() {
            return dayOfMonth;
        }

        public final void setDayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        @Transient
        public final Builder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        @Transient
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        public DescribeMaintenanceStartTimeResponse build() {
            return new DescribeMaintenanceStartTimeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
