/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeTapeArchivesOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTapeArchivesResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeTapeArchivesResponse.Builder, DescribeTapeArchivesResponse> {
    private static final SdkField<List<TapeArchive>> TAPE_ARCHIVES_FIELD = SdkField
            .<List<TapeArchive>> builder(MarshallingType.LIST)
            .memberName("TapeArchives")
            .getter(getter(DescribeTapeArchivesResponse::tapeArchives))
            .setter(setter(Builder::tapeArchives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeArchives").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TapeArchive> builder(MarshallingType.SDK_POJO)
                                            .constructor(TapeArchive::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeTapeArchivesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARCHIVES_FIELD,
            MARKER_FIELD));

    private final List<TapeArchive> tapeArchives;

    private final String marker;

    private DescribeTapeArchivesResponse(BuilderImpl builder) {
        super(builder);
        this.tapeArchives = builder.tapeArchives;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the TapeArchives property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTapeArchives() {
        return tapeArchives != null && !(tapeArchives instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the Amazon Resource
     * Name (ARN) of the virtual tapes. The information returned includes the Amazon Resource Names (ARNs) of the tapes,
     * size of the tapes, status of the tapes, progress of the description, and tape barcode.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTapeArchives} method.
     * </p>
     * 
     * @return An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the Amazon
     *         Resource Name (ARN) of the virtual tapes. The information returned includes the Amazon Resource Names
     *         (ARNs) of the tapes, size of the tapes, status of the tapes, progress of the description, and tape
     *         barcode.
     */
    public final List<TapeArchive> tapeArchives() {
        return tapeArchives;
    }

    /**
     * <p>
     * An opaque string that indicates the position at which the virtual tapes that were fetched for description ended.
     * Use this marker in your next request to fetch the next set of virtual tapes in the virtual tape shelf (VTS). If
     * there are no more virtual tapes to describe, this field does not appear in the response.
     * </p>
     * 
     * @return An opaque string that indicates the position at which the virtual tapes that were fetched for description
     *         ended. Use this marker in your next request to fetch the next set of virtual tapes in the virtual tape
     *         shelf (VTS). If there are no more virtual tapes to describe, this field does not appear in the response.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTapeArchives() ? tapeArchives() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTapeArchivesResponse)) {
            return false;
        }
        DescribeTapeArchivesResponse other = (DescribeTapeArchivesResponse) obj;
        return hasTapeArchives() == other.hasTapeArchives() && Objects.equals(tapeArchives(), other.tapeArchives())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTapeArchivesResponse").add("TapeArchives", hasTapeArchives() ? tapeArchives() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeArchives":
            return Optional.ofNullable(clazz.cast(tapeArchives()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTapeArchivesResponse, T> g) {
        return obj -> g.apply((DescribeTapeArchivesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTapeArchivesResponse> {
        /**
         * <p>
         * An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the Amazon
         * Resource Name (ARN) of the virtual tapes. The information returned includes the Amazon Resource Names (ARNs)
         * of the tapes, size of the tapes, status of the tapes, progress of the description, and tape barcode.
         * </p>
         * 
         * @param tapeArchives
         *        An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the
         *        Amazon Resource Name (ARN) of the virtual tapes. The information returned includes the Amazon Resource
         *        Names (ARNs) of the tapes, size of the tapes, status of the tapes, progress of the description, and
         *        tape barcode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeArchives(Collection<TapeArchive> tapeArchives);

        /**
         * <p>
         * An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the Amazon
         * Resource Name (ARN) of the virtual tapes. The information returned includes the Amazon Resource Names (ARNs)
         * of the tapes, size of the tapes, status of the tapes, progress of the description, and tape barcode.
         * </p>
         * 
         * @param tapeArchives
         *        An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the
         *        Amazon Resource Name (ARN) of the virtual tapes. The information returned includes the Amazon Resource
         *        Names (ARNs) of the tapes, size of the tapes, status of the tapes, progress of the description, and
         *        tape barcode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeArchives(TapeArchive... tapeArchives);

        /**
         * <p>
         * An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the Amazon
         * Resource Name (ARN) of the virtual tapes. The information returned includes the Amazon Resource Names (ARNs)
         * of the tapes, size of the tapes, status of the tapes, progress of the description, and tape barcode.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TapeArchive>.Builder} avoiding the need to
         * create one manually via {@link List<TapeArchive>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TapeArchive>.Builder#build()} is called immediately and its
         * result is passed to {@link #tapeArchives(List<TapeArchive>)}.
         * 
         * @param tapeArchives
         *        a consumer that will call methods on {@link List<TapeArchive>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tapeArchives(List<TapeArchive>)
         */
        Builder tapeArchives(Consumer<TapeArchive.Builder>... tapeArchives);

        /**
         * <p>
         * An opaque string that indicates the position at which the virtual tapes that were fetched for description
         * ended. Use this marker in your next request to fetch the next set of virtual tapes in the virtual tape shelf
         * (VTS). If there are no more virtual tapes to describe, this field does not appear in the response.
         * </p>
         * 
         * @param marker
         *        An opaque string that indicates the position at which the virtual tapes that were fetched for
         *        description ended. Use this marker in your next request to fetch the next set of virtual tapes in the
         *        virtual tape shelf (VTS). If there are no more virtual tapes to describe, this field does not appear
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<TapeArchive> tapeArchives = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTapeArchivesResponse model) {
            super(model);
            tapeArchives(model.tapeArchives);
            marker(model.marker);
        }

        public final List<TapeArchive.Builder> getTapeArchives() {
            List<TapeArchive.Builder> result = TapeArchivesCopier.copyToBuilder(this.tapeArchives);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTapeArchives(Collection<TapeArchive.BuilderImpl> tapeArchives) {
            this.tapeArchives = TapeArchivesCopier.copyFromBuilder(tapeArchives);
        }

        @Override
        @Transient
        public final Builder tapeArchives(Collection<TapeArchive> tapeArchives) {
            this.tapeArchives = TapeArchivesCopier.copy(tapeArchives);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tapeArchives(TapeArchive... tapeArchives) {
            tapeArchives(Arrays.asList(tapeArchives));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tapeArchives(Consumer<TapeArchive.Builder>... tapeArchives) {
            tapeArchives(Stream.of(tapeArchives).map(c -> TapeArchive.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeTapeArchivesResponse build() {
            return new DescribeTapeArchivesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
