/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * SetSMBGuestPasswordInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetSmbGuestPasswordRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<SetSmbGuestPasswordRequest.Builder, SetSmbGuestPasswordRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(SetSmbGuestPasswordRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(SetSmbGuestPasswordRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            PASSWORD_FIELD));

    private final String gatewayARN;

    private final String password;

    private SetSmbGuestPasswordRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.password = builder.password;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated with.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated with.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The password that you want to set for your SMB server.
     * </p>
     * 
     * @return The password that you want to set for your SMB server.
     */
    public final String password() {
        return password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSmbGuestPasswordRequest)) {
            return false;
        }
        SetSmbGuestPasswordRequest other = (SetSmbGuestPasswordRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(password(), other.password());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetSmbGuestPasswordRequest").add("GatewayARN", gatewayARN())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetSmbGuestPasswordRequest, T> g) {
        return obj -> g.apply((SetSmbGuestPasswordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetSmbGuestPasswordRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated with.
         * </p>
         * 
         * @param gatewayARN
         *        The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The password that you want to set for your SMB server.
         * </p>
         * 
         * @param password
         *        The password that you want to set for your SMB server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSmbGuestPasswordRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            password(model.password);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        @Transient
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        @Transient
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetSmbGuestPasswordRequest build() {
            return new SetSmbGuestPasswordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
